/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.ui.components;

import com.bwanms.gui.Internationalizer;
import com.bwanms.model.Task;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.DateFormatter;
import com.bwanms.util.TaskPluginUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TaskManagerTableModel
extends SimpleRowTableModel {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(TaskManagerTableModel.class);
    public static final Internationalizer tI18N = Internationalizer.getInternationalizer("com.bwanms.tasks");
    private List<Task> tasks;
    private Map<Long, Integer> cache;
    private int lastSorted = -1;
    private int dir = 1;

    public TaskManagerTableModel() {
        super(new SimpleRowTableModel.ColumnDefinition[]{new SimpleRowTableModel.ColumnDefinition(i18n.translateString("Name"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("CreatedBy"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("ModifiedBy"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("Type"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("State"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("LastRun"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("Result"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("NextRun"), String.class)});
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.setColumnReadonly(i, true);
        }
        this.tasks = new ArrayList<Task>();
        this.cache = new HashMap<Long, Integer>();
    }

    public int addRow(Task task) {
        this.addNewRow(Long.toString(task.getId()), true);
        int row = this.getRowCount() - 1;
        this.setRowValues(row, task);
        this.tasks.add(task);
        this.cache.put(task.getId(), row);
        return row;
    }

    public void removeRow(Task task) {
        int rowNumber = this.cache.remove(task.getId());
        this.rows.remove(rowNumber);
        this.tasks.remove(rowNumber);
        for (Long el : this.cache.keySet()) {
            int i = this.cache.get(el);
            if (i <= rowNumber) continue;
            this.cache.put(el, i - 1);
        }
        this.fireTableRowsDeleted(rowNumber, rowNumber);
    }

    public void setRowValues(int row, Task task) {
        int col = 0;
        this.setInitialValueAt(task.getName(), row, col++);
        this.setInitialValueAt(task.getCreatedBy(), row, col++);
        this.setInitialValueAt(task.getModifiedBy(), row, col++);
        this.setInitialValueAt(tI18N.translateString(TaskPluginUtil.getTypeForClass(task.getClass())), row, col++);
        this.setInitialValueAt(Task.getStateString(task.getState()), row, col++);
        if (task.getLastRun() > 0L) {
            Calendar time = Calendar.getInstance();
            time.setTimeInMillis(task.getLastRun());
            this.setInitialValueAt(DateFormatter.format(time.getTime()), row, col++);
        } else {
            this.setInitialValueAt("", row, col++);
        }
        this.setInitialValueAt(i18n.translateString(Task.getLastResultString(task.getLastRunResult())), row, col++);
        if (task.getSchedule() != null) {
            Date nextRun = task.getSchedule().getNextRun();
            if (nextRun != null) {
                this.setInitialValueAt(DateFormatter.format(nextRun), row, col++);
            } else {
                this.setInitialValueAt(i18n.translateString("NotScheduled"), row, col++);
            }
        } else {
            this.setInitialValueAt(i18n.translateString("NotScheduled"), row, col++);
        }
    }

    public int updateRow(Task task) {
        int row = 0;
        if (this.cache.get(task.getId()) == null) {
            row = this.addRow(task);
        } else {
            row = this.cache.get(task.getId());
            this.setRowValues(row, task);
            this.tasks.set(row, task);
        }
        return row;
    }

    public Task getTask(int row) {
        return this.tasks.get(row);
    }

    public void clearTable() {
        this.cache.clear();
        this.tasks.clear();
        super.clearTable();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void sortByColumn(final int modelIndex) {
        if (this.lastSorted == modelIndex) {
            this.dir *= -1;
        } else {
            this.dir = 1;
            this.lastSorted = modelIndex;
        }
        ArrayList<Task> temp = new ArrayList<Task>();
        temp.addAll(this.tasks);
        Collections.sort(temp, new Comparator<Task>(){

            @Override
            public int compare(Task o1, Task o2) {
                switch (modelIndex) {
                    case 0: {
                        String name1 = o1.getName() != null ? o1.getName() : "";
                        String name2 = o2.getName() != null ? o2.getName() : "";
                        return TaskManagerTableModel.this.dir * name1.toLowerCase().compareTo(name2.toLowerCase());
                    }
                    case 1: {
                        String createdBy1 = o1.getCreatedBy() != null ? o1.getCreatedBy() : "";
                        String createdBy2 = o2.getCreatedBy() != null ? o2.getCreatedBy() : "";
                        return TaskManagerTableModel.this.dir * createdBy1.toLowerCase().compareTo(createdBy2.toLowerCase());
                    }
                    case 2: {
                        String modifiedBy1 = o1.getModifiedBy() != null ? o1.getModifiedBy() : "";
                        String modifiedBy2 = o2.getModifiedBy() != null ? o2.getModifiedBy() : "";
                        return TaskManagerTableModel.this.dir * modifiedBy1.toLowerCase().compareTo(modifiedBy2.toLowerCase());
                    }
                    case 3: {
                        String type1 = tI18N.translateString(TaskPluginUtil.getTypeForClass(o1.getClass()));
                        String type2 = tI18N.translateString(TaskPluginUtil.getTypeForClass(o2.getClass()));
                        return TaskManagerTableModel.this.dir * type1.toLowerCase().compareTo(type2.toLowerCase());
                    }
                    case 4: {
                        return TaskManagerTableModel.this.dir * new Integer(o1.getState()).compareTo(o2.getState());
                    }
                    case 5: {
                        if (o1.getLastRun() == 0L && o2.getLastRun() == 0L) {
                            return 0;
                        }
                        if (o1.getLastRun() == 0L && o2.getLastRun() > 0L) {
                            return TaskManagerTableModel.this.dir;
                        }
                        if (o1.getLastRun() > 0L && o2.getLastRun() == 0L) {
                            return TaskManagerTableModel.this.dir * -1;
                        }
                        return TaskManagerTableModel.this.dir * new Long(o1.getLastRun()).compareTo(o2.getLastRun());
                    }
                    case 6: {
                        return TaskManagerTableModel.this.dir * new Integer(o1.getLastRunResult()).compareTo(o2.getLastRunResult());
                    }
                    case 7: {
                        if (o1.getSchedule() == null && o2.getSchedule() == null) {
                            return 0;
                        }
                        if (o1.getSchedule() == null && o2.getSchedule() != null) {
                            return TaskManagerTableModel.this.dir;
                        }
                        if (o1.getSchedule() != null && o2.getSchedule() == null) {
                            return TaskManagerTableModel.this.dir * -1;
                        }
                        return TaskManagerTableModel.this.dir * o1.getSchedule().getNextRun().compareTo(o2.getSchedule().getNextRun());
                    }
                }
                return 0;
            }
        });
        this.clearTable();
        for (Task task : temp) {
            this.addRow(task);
        }
    }
}

