/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class SortableHeaderRenderer
extends DefaultTableCellRenderer
implements UIResource {
    private TableCellRenderer tableCellRenderer;
    private List sortingColumns = new ArrayList();
    public static final int DESCENDING = -1;
    public static final int NOT_SORTED = 0;
    public static final int ASCENDING = 1;
    private static Directive EMPTY_DIRECTIVE = new Directive(-1, 0);

    public SortableHeaderRenderer(TableCellRenderer tableCellRenderer) {
        this.tableCellRenderer = tableCellRenderer;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component c = this.tableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (c instanceof JLabel) {
            JLabel l = (JLabel)c;
            Color bgColor = table.getTableHeader().getBackground();
            if (bgColor != null && l.getBackground() == null) {
                l.setBackground(new Color(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), 1));
            }
            l.setHorizontalTextPosition(2);
            int modelColumn = table.convertColumnIndexToModel(column);
            l.setIcon(this.getHeaderRendererIcon(modelColumn, l.getFont().getSize()));
        }
        return c;
    }

    protected Icon getHeaderRendererIcon(int column, int size) {
        Directive directive = this.getDirective(column);
        if (directive == EMPTY_DIRECTIVE) {
            return null;
        }
        return new Arrow(directive.direction == -1, size, this.sortingColumns.indexOf(directive));
    }

    private Directive getDirective(int column) {
        for (int i = 0; i < this.sortingColumns.size(); ++i) {
            Directive directive = (Directive)this.sortingColumns.get(i);
            if (directive.column != column) continue;
            return directive;
        }
        return EMPTY_DIRECTIVE;
    }

    public boolean isSorting() {
        return this.sortingColumns.size() != 0;
    }

    public int getSortingStatus(int column) {
        return this.getDirective(column).direction;
    }

    public int getFirstSortingColumn() {
        if (this.sortingColumns.size() > 0) {
            Directive directive = (Directive)this.sortingColumns.get(0);
            return directive.column;
        }
        return -1;
    }

    public void setSortingStatus(int column, int status) {
        Directive directive = this.getDirective(column);
        if (directive != EMPTY_DIRECTIVE) {
            this.sortingColumns.remove(directive);
        }
        if (status != 0) {
            this.sortingColumns.add(new Directive(column, status));
        }
    }

    public void cancelSorting() {
        this.sortingColumns.clear();
    }

    public TableCellRenderer getTableCellRenderer() {
        return this.tableCellRenderer;
    }

    public int getNextAscSortingStatus(int column) {
        return (this.getSortingStatus(column) + 1 + 4) % 3 - 1;
    }

    public int getNextDescSortingStatus(int column) {
        return (this.getSortingStatus(column) - 1 + 4) % 3 - 1;
    }

    public void setTableCellRenderer(TableCellRenderer tableCellRenderer) {
        this.tableCellRenderer = tableCellRenderer;
    }

    private static class Arrow
    implements Icon {
        private boolean descending;
        private int size;
        private int priority;

        public Arrow(boolean descending, int size, int priority) {
            this.descending = descending;
            this.size = size;
            this.priority = priority;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color color = c == null ? Color.GRAY : c.getBackground();
            int dx = (int)((double)(this.size / 2) * Math.pow(0.8, this.priority));
            int dy = this.descending ? dx : -dx;
            y = y + 5 * this.size / 6 + (this.descending ? -dy : 0);
            int shift = this.descending ? 1 : -1;
            g.translate(x, y);
            g.setColor(color.darker());
            g.drawLine(dx / 2, dy, 0, 0);
            g.drawLine(dx / 2, dy + shift, 0, shift);
            g.setColor(color.brighter());
            g.drawLine(dx / 2, dy, dx, 0);
            g.drawLine(dx / 2, dy + shift, dx, shift);
            if (this.descending) {
                g.setColor(color.darker().darker());
            } else {
                g.setColor(color.brighter().brighter());
            }
            g.drawLine(dx, 0, 0, 0);
            g.setColor(color);
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }
    }

    private static class Directive {
        private int column;
        private int direction;

        public Directive(int column, int direction) {
            this.column = column;
            this.direction = direction;
        }
    }
}

