/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.ui.components;

import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public abstract class SimpleRowTableModelPanelController
implements TableModelListener {
    public void btnRevertMouseClicked() {
        FormUtil.cancelTableEditing(this.getTable());
        int[] selectedRows = this.getTable().getSelectedRows();
        Arrays.sort(selectedRows);
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            this.getTableModel().revertRow(selectedRows[i]);
        }
        this.controlTableButtons();
    }

    public void btnDeleteMouseClicked() {
        int[] selectedRows = this.getTable().getSelectedRows();
        Arrays.sort(selectedRows);
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            if (this.getTableModel().getRowState(selectedRows[i]) == 3) {
                this.getTableModel().revertRow(selectedRows[i]);
                this.getTableModel().markRowForDeletion(selectedRows[i]);
                continue;
            }
            if (this.getTableModel().getRowState(selectedRows[i]) == 2) {
                this.getTableModel().revertRow(selectedRows[i]);
                continue;
            }
            if (this.getTableModel().getRowState(selectedRows[i]) != 0) continue;
            this.getTableModel().markRowForDeletion(selectedRows[i]);
        }
        this.controlTableButtons();
    }

    public void btnAddMouseClicked() {
        this.getTableModel().addNewRow(null, false);
        FormUtil.stopTableEditing(this.getTable());
    }

    public void tableChanged(TableModelEvent e) {
        this.controlTableButtons();
    }

    public void controlTableButtons() {
        int row = this.getTable().getSelectedRow();
        if (row < 0 || row >= this.getTableModel().getRowCount()) {
            this.getRevertButton().setEnabled(false);
            this.getDeleteButton().setEnabled(false);
            return;
        }
        if (this.getTableModel().getRowState(row) == 0) {
            this.getRevertButton().setEnabled(false);
            this.getDeleteButton().setEnabled(true);
        } else if (this.getTableModel().getRowState(row) == 1 || this.getTableModel().getRowState(row) == 3) {
            this.getRevertButton().setEnabled(true);
            this.getDeleteButton().setEnabled(false);
        } else if (this.getTableModel().getRowState(row) == 5 || this.getTableModel().getRowState(row) == 2) {
            this.getRevertButton().setEnabled(true);
            this.getDeleteButton().setEnabled(false);
        } else {
            this.getRevertButton().setEnabled(false);
            this.getDeleteButton().setEnabled(false);
        }
    }

    protected SimpleRowTableModel getTableModel() {
        return (SimpleRowTableModel)this.getTable().getModel();
    }

    protected abstract JTable getTable();

    protected abstract JButton getDeleteButton();

    protected abstract JButton getRevertButton();
}

