/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.ui.components;

import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.SortableHeaderRenderer;
import com.bwanms.util.IpAddress;
import com.bwanms.util.MacAddress;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRowTableModel
extends AbstractTableModel {
    public static final int ROW_STATE_NORMAL = 0;
    public static final int ROW_STATE_TO_DELETE = 1;
    public static final int ROW_STATE_NEW = 2;
    public static final int ROW_STATE_UPDATED = 3;
    public static final int ROW_STATE_AVAILABLE = 4;
    public static final int ROW_STATE_EDIT_AVLB = 5;
    protected final List<ColumnDefinition> columns;
    protected List<TableRow> originalRows = new ArrayList<TableRow>();
    protected List<TableRow> rows = new ArrayList<TableRow>();
    protected boolean newRowReadOnlyOverride = false;
    private HashMap<Integer, Boolean> newColumnsReadOnly = new HashMap();
    public static final Comparator COMPARABLE_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    };
    public static final Comparator LEXICAL_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return o1.toString().compareToIgnoreCase(o2.toString());
        }
    };
    public static final Comparator IP_ADDRESS_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            IpAddress ipAddress2;
            IpAddress ipAddress1;
            try {
                ipAddress1 = new IpAddress(String.valueOf(o1));
            }
            catch (Exception e) {
                return -1;
            }
            try {
                ipAddress2 = new IpAddress(String.valueOf(o2));
            }
            catch (Exception e) {
                return 1;
            }
            return ipAddress1.compareTo(ipAddress2);
        }
    };
    public static final Comparator MAC_ADDRESS_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            MacAddress macAddress2;
            MacAddress macAddress1;
            try {
                macAddress1 = MacAddress.fromDashedString(String.valueOf(o1));
            }
            catch (Exception e) {
                return -1;
            }
            try {
                macAddress2 = MacAddress.fromDashedString(String.valueOf(o2));
            }
            catch (Exception e) {
                return 1;
            }
            return macAddress1.compareTo(macAddress2);
        }
    };
    public static final Comparator STRING_AS_INTEGER_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            Integer i2;
            Integer i1;
            try {
                i1 = new Integer(String.valueOf(o1));
            }
            catch (Exception e) {
                return -1;
            }
            try {
                i2 = new Integer(String.valueOf(o2));
            }
            catch (Exception e) {
                return 1;
            }
            return i1.compareTo(i2);
        }
    };
    public static final Comparator STRING_AS_DOUBLE_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            Double d2;
            Double d1;
            try {
                d1 = new Double(String.valueOf(o1));
            }
            catch (Exception e) {
                return -1;
            }
            try {
                d2 = new Double(String.valueOf(o2));
            }
            catch (Exception e) {
                return 1;
            }
            return d1.compareTo(d2);
        }
    };
    public static final Comparator STRING_AS_ID_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            int i;
            ArrayList<Integer> id1 = new ArrayList<Integer>();
            ArrayList<Integer> id2 = new ArrayList<Integer>();
            try {
                String[] array1 = String.valueOf(o1).split("\\.");
                for (i = 0; i < array1.length; ++i) {
                    id1.add(Integer.valueOf(array1[i]));
                }
            }
            catch (Exception e) {
                return -1;
            }
            try {
                String[] array2 = String.valueOf(o2).split("\\.");
                for (i = 0; i < array2.length; ++i) {
                    id2.add(Integer.valueOf(array2[i]));
                }
            }
            catch (Exception e) {
                return 1;
            }
            if (id1.size() != id2.size()) {
                return id1.size() - id2.size();
            }
            for (int i2 = 0; i2 < id1.size(); ++i2) {
                int comp = ((Integer)id1.get(i2)).compareTo((Integer)id2.get(i2));
                if (comp == 0) continue;
                return comp;
            }
            return 0;
        }
    };
    private Row[] viewToModel;
    private int[] modelToView;
    private JTableHeader tableHeader;
    private MouseListener mouseListener;
    private Map columnComparators = new HashMap();
    private Map columnByIndexComparators = new HashMap();

    public SimpleRowTableModel(List<ColumnDefinition> columns) {
        this(columns, null);
    }

    public SimpleRowTableModel(List<ColumnDefinition> columns, JTableHeader tableHeader) {
        this(columns.toArray(new ColumnDefinition[columns.size()]), tableHeader);
    }

    public SimpleRowTableModel(ColumnDefinition[] columns) {
        this(columns, null);
    }

    public SimpleRowTableModel(ColumnDefinition[] columns, JTableHeader tableHeader) {
        this.columns = new ArrayList<ColumnDefinition>(columns.length);
        for (ColumnDefinition columnDef : columns) {
            this.columns.add(columnDef);
        }
        this.mouseListener = new MouseHandler();
        this.setTableHeader(tableHeader);
        this.setColumnComparator(String.class, LEXICAL_COMPARATOR);
    }

    public void addNewRow(String rowKey, boolean isInitial) {
        TableRow tRow = new TableRow(rowKey);
        if (!isInitial) {
            tRow.setState(2);
        }
        this.addTableRow(tRow);
    }

    public void addTableRow(TableRow tRow) {
        this.rows.add(tRow);
        this.originalRows.add(this.rows.get(this.rows.size() - 1));
        if (this.viewToModel != null && this.viewToModel.length < this.rows.size()) {
            Row[] tempView = new Row[this.viewToModel.length + 1];
            System.arraycopy(this.viewToModel, 0, tempView, 0, this.viewToModel.length);
            tempView[tempView.length - 1] = new Row(tempView.length - 1);
            this.viewToModel = tempView;
        }
        this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size() - 1);
    }

    public TableRow getTableRow(int row) {
        return this.rows.get(row);
    }

    public void clearTable() {
        this.rows.clear();
        this.originalRows.clear();
        this.clearSortingState();
        this.fireTableDataChanged();
    }

    public void markRowForDeletion(int row) {
        this.setRowState(row, 1);
        this.fireTableChanged(new TableModelEvent(this, row));
    }

    public void markRowsForDeletion(int[] rows) {
        if (rows == null) {
            return;
        }
        for (int row : rows) {
            this.markRowForDeletion(row);
        }
    }

    public void revertRow(int row) {
        TableRow tRow = this.rows.get(row);
        int rState = tRow.getState();
        switch (rState) {
            case 5: {
                tRow.revert();
                tRow.setState(4);
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 3: {
                tRow.revert();
                tRow.setState(0);
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 2: {
                this.removeRow(row);
                this.fireTableRowsDeleted(row, row);
                break;
            }
            case 1: {
                tRow.setState(0);
                this.fireTableRowsUpdated(row, row);
            }
        }
    }

    public void revertRows(int[] rows) {
        for (int row : rows) {
            this.revertRow(row);
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.getColumnDefinition(columnIndex).getColumnClass();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.getColumnDefinition(columnIndex).getName();
    }

    public ColumnDefinition getColumnDefinition(int columnIndex) {
        return this.columns.get(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    public int getRowState(int row) {
        return this.rows.get(row).getState();
    }

    public boolean isHighlighted(int row) {
        return this.rows.get(row).isHighlighted();
    }

    public void setHighlighted(int row, boolean highlighted) {
        this.rows.get(row).setHighlighted(highlighted);
        this.fireTableChanged(new TableModelEvent(this, row));
    }

    public void setRowKey(int row, String key) {
        this.rows.get(row).setRowKey(key);
    }

    public String getRowKey(int row) {
        return this.rows.get(row).getRowKey();
    }

    public List<ComboItem> getValueSet(int row, int col) {
        List<ComboItem> ret = this.rows.get(row).getValueSet(col);
        if (ret == null) {
            ret = this.getColumnDefinition(col).getValueSet();
        }
        return ret;
    }

    public void setValueSet(int row, int col, List<ComboItem> valueSet) {
        if (row < 0) {
            this.getColumnDefinition(col).setValueSet(valueSet);
        } else {
            this.rows.get(row).setValueSet(col, valueSet);
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.rows.get(rowIndex).getValue(columnIndex);
    }

    public Object getInitialValueAt(int rowIndex, int columnIndex) {
        return this.rows.get(rowIndex).getInitialValue(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.getColumnClass(columnIndex).equals(JButton.class)) {
            return false;
        }
        int rowState = this.rows.get(rowIndex).getState();
        if ((rowState == 2 || rowState == 4 || rowState == 5) && this.newColumnsReadOnly.get(columnIndex) != null) {
            return this.newColumnsReadOnly.get(columnIndex) == false;
        }
        return (rowState == 2 || rowState == 4 || rowState == 5) && this.newRowReadOnlyOverride || !this.isColumnReadonly(columnIndex) && rowState != 1;
    }

    public void removeRow(int row) {
        if (row < this.rows.size()) {
            this.originalRows.remove(this.rows.remove(row));
            this.fireTableRowsDeleted(row, row);
        }
    }

    public boolean isColumnReadonly(int columnIndex) {
        return this.getColumnDefinition(columnIndex).isReadOnly();
    }

    public void setColumnReadonly(int columnIndex, boolean readonly) {
        this.getColumnDefinition(columnIndex).setReadOnly(readonly);
    }

    public void setNewColumnReadonly(int i, boolean readonly) {
        this.newColumnsReadOnly.put(i, readonly);
    }

    public void setInitialValueAt(Object value, int row, int col) {
        this.rows.get(row).setInitialValue(col, value);
        this.fireTableChanged(new TableModelEvent(this, row));
    }

    public void setRowState(int row, int state) {
        this.rows.get(row).setState(state);
        this.fireTableChanged(new TableModelEvent(this, row));
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        TableRow tRow = this.rows.get(row);
        tRow.setValue(col, value);
        if (tRow.getState() == 0) {
            tRow.setState(3);
        } else if (tRow.getState() == 4) {
            tRow.setState(5);
        }
        this.fireTableChanged(new TableModelEvent(this, row));
    }

    public boolean isNewRowReadOnlyOverride() {
        return this.newRowReadOnlyOverride;
    }

    public void setNewRowReadOnlyOverride(boolean newRowReadOnlyOverride) {
        this.newRowReadOnlyOverride = newRowReadOnlyOverride;
    }

    private void clearSortingState() {
        this.viewToModel = null;
        this.modelToView = null;
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void setTableHeader(JTableHeader tableHeader) {
        if (this.tableHeader != null) {
            this.tableHeader.removeMouseListener(this.mouseListener);
            TableCellRenderer defaultRenderer = this.tableHeader.getDefaultRenderer();
            if (defaultRenderer instanceof SortableHeaderRenderer) {
                this.tableHeader.setDefaultRenderer(((SortableHeaderRenderer)defaultRenderer).getTableCellRenderer());
            }
        }
        this.tableHeader = tableHeader;
        if (this.tableHeader != null) {
            this.tableHeader.addMouseListener(this.mouseListener);
            this.tableHeader.setDefaultRenderer(new SortableHeaderRenderer(this.tableHeader.getDefaultRenderer()));
        }
    }

    public boolean isSorting() {
        if (this.tableHeader == null) {
            return false;
        }
        return ((SortableHeaderRenderer)this.tableHeader.getDefaultRenderer()).isSorting();
    }

    private void sortingStatusChanged() {
        this.clearSortingState();
        this.fireTableDataChanged();
        if (this.tableHeader != null) {
            this.tableHeader.repaint();
        }
    }

    public int getSortingStatus(int column) {
        return ((SortableHeaderRenderer)this.tableHeader.getDefaultRenderer()).getSortingStatus(column);
    }

    public void setSortingStatus(int column, int status) {
        ((SortableHeaderRenderer)this.tableHeader.getDefaultRenderer()).setSortingStatus(column, status);
        this.sortingStatusChanged();
    }

    private void cancelSorting() {
        ((SortableHeaderRenderer)this.tableHeader.getDefaultRenderer()).cancelSorting();
        this.sortingStatusChanged();
    }

    public void setColumnComparator(Class type, Comparator comparator) {
        if (comparator == null) {
            this.columnComparators.remove(type);
        } else {
            this.columnComparators.put(type, comparator);
        }
    }

    public void setColumnComparator(Integer index, Comparator comparator) {
        if (comparator == null) {
            this.columnByIndexComparators.remove(index);
        } else {
            this.columnByIndexComparators.put(index, comparator);
        }
    }

    protected Comparator getComparator(int column) {
        Comparator comparator = (Comparator)this.columnByIndexComparators.get(column);
        if (comparator != null) {
            return comparator;
        }
        Class<?> columnType = this.getColumnClass(column);
        comparator = (Comparator)this.columnComparators.get(columnType);
        if (comparator != null) {
            return comparator;
        }
        if (Comparable.class.isAssignableFrom(columnType)) {
            return COMPARABLE_COMPARATOR;
        }
        return LEXICAL_COMPARATOR;
    }

    private Row[] getViewToModel() {
        if (this.viewToModel == null) {
            int tableModelRowCount = this.getRowCount();
            this.viewToModel = new Row[tableModelRowCount];
            for (int row = 0; row < tableModelRowCount; ++row) {
                this.viewToModel[row] = new Row(row);
            }
            if (this.isSorting()) {
                Arrays.sort(this.viewToModel);
            }
        }
        return this.viewToModel;
    }

    public int modelIndex(int viewIndex) {
        Row[] rows = this.getViewToModel();
        if (viewIndex < 0 || rows.length <= viewIndex) {
            return -1;
        }
        return rows[viewIndex].modelIndex;
    }

    public int getSortedIndexFromOriginalIndex(int originalIndex) {
        if (originalIndex == -1) {
            return -1;
        }
        Row[] rows = this.getViewToModel();
        for (int i = 0; i < rows.length; ++i) {
            if (rows[i].modelIndex != originalIndex) continue;
            return i;
        }
        return -1;
    }

    private int[] getModelToView() {
        if (this.modelToView == null) {
            int n = this.getViewToModel().length;
            this.modelToView = new int[n];
            for (int i = 0; i < n; ++i) {
                this.modelToView[this.modelIndex((int)i)] = i;
            }
        }
        return this.modelToView;
    }

    public void sort() {
        int n = this.originalRows.size();
        for (int i = 0; i < n; ++i) {
            if (i >= this.rows.size() || this.modelIndex(i) >= this.originalRows.size()) continue;
            this.rows.set(i, this.originalRows.get(this.modelIndex(i)));
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            int viewColumn;
            JTableHeader h = (JTableHeader)e.getSource();
            TableColumnModel columnModel = h.getColumnModel();
            int column = columnModel.getColumn(viewColumn = columnModel.getColumnIndexAtX(e.getX())).getModelIndex();
            if (column != -1) {
                int nextStatus;
                int n = nextStatus = e.isShiftDown() ? ((SortableHeaderRenderer)SimpleRowTableModel.this.tableHeader.getDefaultRenderer()).getNextDescSortingStatus(column) : ((SortableHeaderRenderer)SimpleRowTableModel.this.tableHeader.getDefaultRenderer()).getNextAscSortingStatus(column);
                if (!e.isControlDown()) {
                    SimpleRowTableModel.this.cancelSorting();
                }
                SimpleRowTableModel.this.setSortingStatus(column, nextStatus);
            }
            SimpleRowTableModel.this.sort();
        }
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        public void tableChanged(TableModelEvent e) {
            if (!SimpleRowTableModel.this.isSorting()) {
                SimpleRowTableModel.this.clearSortingState();
                SimpleRowTableModel.this.fireTableChanged(e);
                return;
            }
            if (e.getFirstRow() == -1) {
                SimpleRowTableModel.this.cancelSorting();
                SimpleRowTableModel.this.fireTableChanged(e);
                return;
            }
            int column = e.getColumn();
            if (e.getFirstRow() == e.getLastRow() && column != -1 && SimpleRowTableModel.this.getSortingStatus(column) == 0 && SimpleRowTableModel.this.modelToView != null) {
                int viewIndex = SimpleRowTableModel.this.getModelToView()[e.getFirstRow()];
                SimpleRowTableModel.this.fireTableChanged(new TableModelEvent(SimpleRowTableModel.this, viewIndex, viewIndex, column, e.getType()));
                return;
            }
            SimpleRowTableModel.this.clearSortingState();
            SimpleRowTableModel.this.fireTableDataChanged();
        }
    }

    private class Row
    implements Comparable {
        private int modelIndex;

        public Row(int index) {
            this.modelIndex = index;
        }

        public int compareTo(Object o) {
            int row1 = this.modelIndex;
            int row2 = ((Row)o).modelIndex;
            for (int column = 0; column < SimpleRowTableModel.this.columns.size(); ++column) {
                int sortOrder = SimpleRowTableModel.this.getSortingStatus(column);
                if (sortOrder == 0) continue;
                ColumnDefinition cd = SimpleRowTableModel.this.columns.get(column);
                List<ComboItem> valuesForCombos = cd.getValueSet();
                Object o1 = SimpleRowTableModel.this.originalRows.get(row1).getValue(column);
                Object o2 = SimpleRowTableModel.this.originalRows.get(row2).getValue(column);
                if (valuesForCombos.size() > 0) {
                    for (ComboItem combo : valuesForCombos) {
                        if (combo.getValue().equals(o1)) {
                            o1 = combo.getText();
                        }
                        if (!combo.getValue().equals(o2)) continue;
                        o2 = combo.getText();
                    }
                    if (!(o1 instanceof String)) {
                        o1 = "";
                    }
                    if (!(o2 instanceof String)) {
                        o2 = "";
                    }
                }
                int comparison = 0;
                comparison = o1 == null && o2 == null ? 0 : (o1 == null ? -1 : (o2 == null ? 1 : SimpleRowTableModel.this.getComparator(column).compare(o1, o2)));
                if (comparison == 0) continue;
                return sortOrder == -1 ? -comparison : comparison;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ColumnDefinition {
        private String name;
        private Class columnClass;
        private List<ComboItem> valueSet;
        private boolean readOnly;

        public ColumnDefinition(String name, Class columnClass, List<ComboItem> valueSet, boolean readOnly) {
            this.name = name;
            this.columnClass = columnClass;
            this.readOnly = readOnly;
            this.setValueSet(valueSet);
        }

        public ColumnDefinition(String name, Class columnClass, List<ComboItem> valueSet) {
            this(name, columnClass, valueSet, false);
        }

        public ColumnDefinition(String name, Class columnClass, ComboItem[] valueSet) {
            this(name, columnClass, valueSet != null ? Arrays.asList(valueSet) : null);
        }

        public ColumnDefinition(String name, Class columnClass, ComboItem[] valueSet, boolean readOnly) {
            this(name, columnClass, valueSet != null ? Arrays.asList(valueSet) : null, readOnly);
        }

        public ColumnDefinition(String name, Class columnClass, boolean readOnly) {
            this(name, columnClass, (List<ComboItem>)null, readOnly);
        }

        public ColumnDefinition(String name, Class columnClass) {
            this(name, columnClass, (ComboItem[])null);
        }

        public void setValueSet(List<ComboItem> valueSet) {
            this.valueSet = new ArrayList<ComboItem>();
            if (valueSet != null) {
                this.valueSet.addAll(valueSet);
            }
        }

        public List<ComboItem> getValueSet() {
            return this.valueSet;
        }

        public String getName() {
            return this.name;
        }

        public Class getColumnClass() {
            return this.columnClass;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public void setReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TableRow {
        private String rowKey;
        private Object[] values;
        private Object[] initialValues;
        private List<?>[] valueSets;
        private boolean highlighted;
        private boolean readOnly = false;
        private int state = 0;

        public TableRow(String rowKey) {
            this.values = new Object[SimpleRowTableModel.this.columns.size()];
            this.initialValues = new Object[SimpleRowTableModel.this.columns.size()];
            this.valueSets = new List[SimpleRowTableModel.this.columns.size()];
            this.rowKey = rowKey;
        }

        public void setValue(int column, Object value) {
            this.values[column] = value;
        }

        public void setValueSet(int column, List<ComboItem> valueSet) {
            ArrayList vs = new ArrayList();
            vs.addAll(valueSet);
            this.valueSets[column] = vs;
        }

        public List<ComboItem> getValueSet(int column) {
            return this.valueSets[column];
        }

        public void setInitialValue(int column, Object value) {
            this.values[column] = value;
            this.initialValues[column] = value;
        }

        public Object getValue(int column) {
            return this.values[column];
        }

        public Object getInitialValue(int column) {
            return this.initialValues[column];
        }

        public void setValues(Object[] values) {
            this.values = values;
        }

        public Object[] getValues() {
            return this.values;
        }

        public void setState(int state) {
            this.state = state;
        }

        public int getState() {
            return this.state;
        }

        public boolean isChanged() {
            for (int i = 0; i < this.values.length; ++i) {
                if (!(this.values[i] != null ? !this.values[i].equals(this.initialValues[i]) : this.initialValues[i] != null)) continue;
                return true;
            }
            return false;
        }

        public void revert() {
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = this.initialValues[i];
            }
        }

        public String getRowKey() {
            return this.rowKey;
        }

        public void setRowKey(String rowKey) {
            this.rowKey = rowKey;
        }

        public boolean isHighlighted() {
            return this.highlighted;
        }

        public void setHighlighted(boolean highlighted) {
            this.highlighted = highlighted;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public void setReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
            for (ColumnDefinition column : SimpleRowTableModel.this.columns) {
                column.setReadOnly(readOnly);
            }
        }
    }
}

