/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.ui.components;

import com.bwanms.gui.RegexFormatter;
import com.bwanms.gui.selectors.TableCellSelectorComponent;
import com.bwanms.model.Location;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.FormattedTextEditor;
import com.bwanms.ui.components.SelectorEditor;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.ui.components.SimpleRowTableModelPanelController;
import com.bwanms.ui.components.SpinnerEditor;
import com.bwanms.util.FormUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventObject;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.DefaultFormatter;

public class SimpleRowTable {
    public static final Color[] ROW_STATE_COLORS = new Color[]{Color.BLACK, Color.RED, new Color(0, 150, 0), Color.BLUE, Color.GRAY, new Color(0, 150, 0)};
    public static final Color HIGHLIGHT_COLOR = Color.LIGHT_GRAY;
    public static final Color READONLY_COLOR = new Color(230, 230, 230);
    private JTable table;
    private SimpleRowTableModel model;
    private SimpleRowTableModelPanelController controller = null;
    private RowBackgroundCallback backgroundCallback;

    public SimpleRowTable(JTable table, SimpleRowTableModel model) {
        this(table, model, null);
        this.setHeaderListener();
    }

    public SimpleRowTable(JTable table, SimpleRowTableModel model, SimpleRowTableModelPanelController controller) {
        this.table = table;
        this.model = model;
        this.controller = controller;
        this.install();
        this.setHeaderListener();
    }

    private void install() {
        if (this.controller != null) {
            this.model.addTableModelListener(this.controller);
        }
        this.table.setModel(this.model);
        this.readOnlyTabBehavior();
        TableColumnModel columnModel = this.table.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            TableColumn col = columnModel.getColumn(i);
            if (!Boolean.class.equals(this.model.getColumnClass(i))) {
                if (this.table.getColumnClass(col.getModelIndex()).equals(Location.class)) {
                    col.setCellRenderer(new SelectorCellRenderer(new DefaultTableCellRenderer(), i));
                    continue;
                }
                col.setCellRenderer(new RowCellRendererDecorator(new DefaultTableCellRenderer(), i));
                continue;
            }
            col.setCellRenderer(new BooleanRenderer(i));
        }
    }

    private void readOnlyTabBehavior() {
        InputMap im = this.table.getInputMap(1);
        KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
        final Action oldTabAction = this.table.getActionMap().get(im.get(tab));
        AbstractAction tabAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                int column;
                int row;
                oldTabAction.actionPerformed(e);
                JTable table = (JTable)e.getSource();
                int originalRow = row = table.getSelectedRow();
                int originalColumn = column = table.getSelectedColumn();
                while (!table.isCellEditable(row, column)) {
                    oldTabAction.actionPerformed(e);
                    row = table.getSelectedRow();
                    column = table.getSelectedColumn();
                    if (row != originalRow || column != originalColumn) continue;
                    break;
                }
            }
        };
        this.table.getActionMap().put(im.get(tab), tabAction);
    }

    private void setHeaderListener() {
        if (this.table.getTableHeader() != null) {
            this.table.getTableHeader().addMouseListener(new MouseListener(){

                private void stopTableEditing(MouseEvent e) {
                    JTableHeader header = (JTableHeader)e.getSource();
                    FormUtil.stopTableEditing(header.getTable());
                }

                public void mouseClicked(MouseEvent e) {
                    this.stopTableEditing(e);
                }

                public void mouseReleased(MouseEvent e) {
                    this.stopTableEditing(e);
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }

                public void mousePressed(MouseEvent e) {
                    this.stopTableEditing(e);
                }
            });
        }
    }

    public void setComboCellEditor(int columnIdx, JComboBox combo) {
        TableColumnModel columnModel = this.table.getColumnModel();
        columnModel.getColumn(columnIdx).setCellEditor(new RowTableCellEditor(combo, columnIdx));
    }

    public void setComboCellEditor(int columnIdx) {
        this.setComboCellEditor(columnIdx, new JComboBox());
    }

    public void setSpinnerCellEditor(int columnIdx) {
        TableColumnModel columnModel = this.table.getColumnModel();
        columnModel.getColumn(columnIdx).setCellEditor(new SpinnerEditor(new SpinnerNumberModel()));
    }

    public void setSpinnerCellEditor(int columnIdx, SpinnerModel model) {
        TableColumnModel columnModel = this.table.getColumnModel();
        columnModel.getColumn(columnIdx).setCellEditor(new SpinnerEditor(model));
    }

    public void setSelectorCellEditor(int columnIdx) {
        TableColumnModel columnModel = this.table.getColumnModel();
        columnModel.getColumn(columnIdx).setCellEditor(new SelectorEditor());
    }

    public void setFormattedTextCellEditor(int columnIdx, RegexFormatter formatter, Pattern pattern) {
        TableColumnModel columnModel = this.table.getColumnModel();
        columnModel.getColumn(columnIdx).setCellEditor(new FormattedTextEditor(formatter, pattern));
    }

    public void setFormattedTextCellEditor(int columnIdx, JFormattedTextField jFText) {
        TableColumnModel columnModel = this.table.getColumnModel();
        columnModel.getColumn(columnIdx).setCellEditor(new FormattedTextEditor(jFText));
    }

    public void setFormattedTextCellEditor(int columnIdx, DefaultFormatter formatter) {
        TableColumnModel columnModel = this.table.getColumnModel();
        columnModel.getColumn(columnIdx).setCellEditor(new FormattedTextEditor(formatter));
    }

    public void setBackgroundCallback(RowBackgroundCallback bc) {
        this.backgroundCallback = bc;
    }

    public RowBackgroundCallback getBackgroundCallback() {
        return this.backgroundCallback;
    }

    public static class RowBackgroundCallback {
        public Color getUnselectedRowBackgroundColor(int rowIndex) {
            return null;
        }

        public Color getUnselectedCellBackgroundColor(int rowIndex, int colIndex) {
            return null;
        }
    }

    public class RowTableCellEditor
    extends DefaultCellEditor {
        private int column;

        public RowTableCellEditor(JTextField textField) {
            super(textField);
        }

        public RowTableCellEditor(JCheckBox checkBox) {
            super(checkBox);
        }

        public RowTableCellEditor(final JComboBox comboBox, int column) {
            super(comboBox);
            this.clickCountToStart = 2;
            this.column = column;
            comboBox.removeActionListener(this.delegate);
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                public void setValue(Object value) {
                    if (value instanceof ComboItem) {
                        comboBox.setSelectedItem(value);
                    } else {
                        int count = comboBox.getItemCount();
                        for (int i = 0; i < count; ++i) {
                            ComboItem item = (ComboItem)comboBox.getItemAt(i);
                            if (!item.value.equals(value)) continue;
                            comboBox.setSelectedItem(item);
                            return;
                        }
                    }
                }

                public Object getCellEditorValue() {
                    Object selectedItem = comboBox.getSelectedItem();
                    if (selectedItem instanceof ComboItem) {
                        return ((ComboItem)selectedItem).value;
                    }
                    return selectedItem;
                }

                public boolean shouldSelectCell(EventObject anEvent) {
                    if (anEvent instanceof MouseEvent) {
                        MouseEvent e = (MouseEvent)anEvent;
                        return e.getID() != 506;
                    }
                    return true;
                }

                public boolean stopCellEditing() {
                    if (comboBox.isEditable()) {
                        comboBox.actionPerformed(new ActionEvent(RowTableCellEditor.this, 0, ""));
                    }
                    return super.stopCellEditing();
                }
            };
            comboBox.addActionListener(this.delegate);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (this.editorComponent instanceof JComboBox) {
                JComboBox editor = (JComboBox)this.editorComponent;
                editor.removeAllItems();
                List<ComboItem> valueSet = SimpleRowTable.this.model.getValueSet(row, this.column);
                for (ComboItem item : valueSet) {
                    editor.addItem(item);
                }
                ComboItem selectedItem = ComboItem.searchByValue(valueSet, value);
                if (selectedItem != null) {
                    editor.setSelectedItem(selectedItem);
                }
                return editor;
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        public Object getCellEditorValue() {
            return super.getCellEditorValue();
        }
    }

    private class SelectorCellRenderer
    implements TableCellRenderer {
        private TableCellRenderer renderer;
        private int column;

        public SelectorCellRenderer(TableCellRenderer renderer, int column) {
            this.renderer = renderer;
            this.column = column;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color color;
            TableCellSelectorComponent selComp = new TableCellSelectorComponent((Location)value);
            Color color2 = color = SimpleRowTable.this.model.getRowState(row) > -1 ? ROW_STATE_COLORS[SimpleRowTable.this.model.getRowState(row)] : null;
            if (null != color) {
                selComp.getTxtName().setForeground(color);
            }
            if (SimpleRowTable.this.model.isHighlighted(row)) {
                if (isSelected) {
                    selComp.getTxtName().setBackground(table.getSelectionBackground());
                } else if (SimpleRowTable.this.backgroundCallback != null && SimpleRowTable.this.backgroundCallback.getUnselectedRowBackgroundColor(row) != null) {
                    selComp.setBackground(SimpleRowTable.this.backgroundCallback.getUnselectedCellBackgroundColor(row, column));
                } else if (SimpleRowTable.this.backgroundCallback != null && SimpleRowTable.this.backgroundCallback.getUnselectedRowBackgroundColor(row) != null) {
                    selComp.setBackground(SimpleRowTable.this.backgroundCallback.getUnselectedRowBackgroundColor(row));
                } else {
                    selComp.getTxtName().setBackground(HIGHLIGHT_COLOR);
                }
            } else if (isSelected) {
                selComp.getTxtName().setBackground(table.getSelectionBackground());
            } else if (SimpleRowTable.this.backgroundCallback != null && SimpleRowTable.this.backgroundCallback.getUnselectedCellBackgroundColor(row, column) != null) {
                selComp.setBackground(SimpleRowTable.this.backgroundCallback.getUnselectedCellBackgroundColor(row, column));
            } else if (SimpleRowTable.this.backgroundCallback != null && SimpleRowTable.this.backgroundCallback.getUnselectedRowBackgroundColor(row) != null) {
                selComp.setBackground(SimpleRowTable.this.backgroundCallback.getUnselectedRowBackgroundColor(row));
            } else {
                selComp.getTxtName().setBackground(table.getBackground());
            }
            return selComp;
        }

        public int getColumn() {
            return this.column;
        }
    }

    private class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private SimpleRowTableModel model;

        public BooleanRenderer(Integer i) {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
            this.model = (SimpleRowTableModel)SimpleRowTable.this.table.getModel();
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (this.model.isHighlighted(row)) {
                if (isSelected) {
                    this.setBackground(table.getSelectionBackground());
                } else if (SimpleRowTable.this.backgroundCallback != null && SimpleRowTable.this.backgroundCallback.getUnselectedCellBackgroundColor(row, column) != null) {
                    this.setBackground(SimpleRowTable.this.backgroundCallback.getUnselectedCellBackgroundColor(row, column));
                } else if (SimpleRowTable.this.backgroundCallback != null && SimpleRowTable.this.backgroundCallback.getUnselectedRowBackgroundColor(row) != null) {
                    this.setBackground(SimpleRowTable.this.backgroundCallback.getUnselectedRowBackgroundColor(row));
                } else {
                    this.setBackground(HIGHLIGHT_COLOR);
                    if (!table.isCellEditable(row, column)) {
                        this.setBackground(READONLY_COLOR);
                    }
                }
            } else if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else if (SimpleRowTable.this.backgroundCallback != null && SimpleRowTable.this.backgroundCallback.getUnselectedCellBackgroundColor(row, column) != null) {
                this.setBackground(SimpleRowTable.this.backgroundCallback.getUnselectedCellBackgroundColor(row, column));
            } else if (SimpleRowTable.this.backgroundCallback != null && SimpleRowTable.this.backgroundCallback.getUnselectedRowBackgroundColor(row) != null) {
                this.setBackground(SimpleRowTable.this.backgroundCallback.getUnselectedRowBackgroundColor(row));
            } else {
                this.setBackground(table.getBackground());
                if (!table.isCellEditable(row, column)) {
                    this.setBackground(READONLY_COLOR);
                }
            }
            this.setSelected(value != null && (Boolean)value != false);
            return this;
        }
    }

    public class RowCellRendererDecorator
    implements TableCellRenderer {
        private TableCellRenderer renderer;
        private int column;
        private int horizontalAlignment = 2;

        public RowCellRendererDecorator(TableCellRenderer renderer, int column) {
            this.renderer = renderer;
            this.column = column;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color color;
            if (value instanceof JButton) {
                return (Component)value;
            }
            List<ComboItem> valueSet = SimpleRowTable.this.model.getValueSet(row, this.column);
            ComboItem selectedItem = ComboItem.searchByValue(valueSet, value);
            if (selectedItem != null) {
                value = selectedItem.toString();
            }
            Component comp = this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Color color2 = color = SimpleRowTable.this.model.getRowState(row) > -1 ? ROW_STATE_COLORS[SimpleRowTable.this.model.getRowState(row)] : ROW_STATE_COLORS[0];
            if (null != color) {
                comp.setForeground(color);
            }
            if (SimpleRowTable.this.model.isHighlighted(row)) {
                if (isSelected) {
                    comp.setBackground(table.getSelectionBackground());
                } else if (SimpleRowTable.this.backgroundCallback != null && SimpleRowTable.this.backgroundCallback.getUnselectedCellBackgroundColor(row, column) != null) {
                    comp.setBackground(SimpleRowTable.this.backgroundCallback.getUnselectedCellBackgroundColor(row, column));
                } else if (SimpleRowTable.this.backgroundCallback != null && SimpleRowTable.this.backgroundCallback.getUnselectedRowBackgroundColor(row) != null) {
                    comp.setBackground(SimpleRowTable.this.backgroundCallback.getUnselectedRowBackgroundColor(row));
                } else {
                    comp.setBackground(HIGHLIGHT_COLOR);
                    if (!table.isCellEditable(row, column)) {
                        comp.setBackground(READONLY_COLOR);
                    }
                }
            } else if (isSelected) {
                comp.setBackground(table.getSelectionBackground());
            } else if (SimpleRowTable.this.backgroundCallback != null && SimpleRowTable.this.backgroundCallback.getUnselectedCellBackgroundColor(row, column) != null) {
                comp.setBackground(SimpleRowTable.this.backgroundCallback.getUnselectedCellBackgroundColor(row, column));
            } else if (SimpleRowTable.this.backgroundCallback != null && SimpleRowTable.this.backgroundCallback.getUnselectedRowBackgroundColor(row) != null) {
                comp.setBackground(SimpleRowTable.this.backgroundCallback.getUnselectedRowBackgroundColor(row));
            } else {
                comp.setBackground(table.getBackground());
                if (!table.isCellEditable(row, column)) {
                    comp.setBackground(READONLY_COLOR);
                }
            }
            if (comp instanceof JLabel) {
                ((JLabel)comp).setHorizontalAlignment(this.horizontalAlignment);
            }
            return comp;
        }

        public int getColumn() {
            return this.column;
        }

        public void setHorizontalAlignment(int horizontalAlignment) {
            this.horizontalAlignment = horizontalAlignment;
        }
    }
}

