/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.ui.components;

import com.bwanms.gui.Internationalizer;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class SimpleFileChooser
extends JPanel {
    private static final String toString = Internationalizer.getInternationalizer(SimpleFileChooser.class).translateString("SimpleFileChooserFromDisk");
    private JTextField fileName;
    private JButton openFileChooser;
    private String path = "";
    private FileFilter fileFilter;

    public SimpleFileChooser(String path) {
        this.path = path;
        this.initComponents();
        this.postInitComponents();
    }

    public SimpleFileChooser(String path, FileFilter ffilter) {
        this.path = path;
        this.fileFilter = ffilter;
        this.initComponents();
        this.postInitComponents();
    }

    private void initComponents() {
        this.fileName = new JTextField();
        this.openFileChooser = new JButton();
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)new FormLayout("default:grow, left:12dlu", "12dlu:grow"));
        this.fileName.setEditable(false);
        this.add((Component)this.fileName, cc.xy(1, 1));
        this.openFileChooser.setText("...");
        this.openFileChooser.setFont(new Font("Times New Roman", 0, 11));
        this.add((Component)this.openFileChooser, cc.xy(2, 1));
    }

    private void postInitComponents() {
        this.openFileChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SimpleFileChooser.this.openFileChooser();
            }
        });
    }

    public void openFileChooser() {
        File file;
        int returnVal;
        JFileChooser fc = "".equals(this.fileName.getText()) ? new JFileChooser(this.path) : new JFileChooser(this.fileName.getText());
        if (this.fileFilter != null) {
            fc.setAcceptAllFileFilterUsed(false);
            fc.setFileFilter(this.fileFilter);
        }
        if ((returnVal = fc.showOpenDialog(this)) == 0 && (file = fc.getSelectedFile()).isFile()) {
            this.fileName.setText(file.getAbsolutePath());
            this.path = file.getParent();
        }
        this.fileName.setCaretPosition(this.fileName.getText().length());
    }

    public void setFileFilter(FileFilter ffilter) {
        this.fileFilter = ffilter;
    }

    public String getText() {
        return this.fileName.getText();
    }

    public String toString() {
        return toString;
    }
}

