/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.ui.components;

import com.bwanms.ui.components.ComboItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class JRadioPanel
extends JPanel
implements ActionListener {
    private List<ComboItem> data = new ArrayList<ComboItem>();
    private ButtonGroup buttonGroup = new ButtonGroup();
    private boolean fakeRadios = true;
    private int fakeButtonsNr = 3;

    public JRadioPanel() {
        this.initComponents();
    }

    public void addItem(ComboItem value) {
        if (this.fakeRadios) {
            this.clearAllButtons();
            this.fakeRadios = false;
        }
        this.data.add(value);
        this.createRadioButtonForItem(value, this.data.size());
    }

    public ComboItem getItem(int idx) {
        return this.data.get(idx);
    }

    public int getItemCount() {
        return this.data.size();
    }

    private void initComponents() {
        GridBagLayout gb = new GridBagLayout();
        gb.columnWidths = new int[]{0, 0};
        gb.columnWeights = new double[]{1.0, 1.0E-4};
        this.setLayout(gb);
        for (int i = 0; i < this.fakeButtonsNr; ++i) {
            this.createRadioButtonForItem("test" + i, i);
        }
    }

    public void clearAllButtons() {
        ArrayList<JRadioButton> test = new ArrayList<JRadioButton>();
        Enumeration<AbstractButton> jr = this.buttonGroup.getElements();
        while (jr.hasMoreElements()) {
            test.add((JRadioButton)jr.nextElement());
        }
        for (JRadioButton button : test) {
            this.remove(button);
            this.buttonGroup.remove(button);
        }
    }

    private Enumeration getAllButtons() {
        return this.buttonGroup.getElements();
    }

    private JRadioButton getRadioButton(String key) {
        Enumeration<AbstractButton> jr = this.buttonGroup.getElements();
        while (jr.hasMoreElements()) {
            JRadioButton tempButton = (JRadioButton)jr.nextElement();
            if (!tempButton.getActionCommand().equals(key)) continue;
            return tempButton;
        }
        return null;
    }

    private String getKeyForValue(Object value) {
        for (ComboItem element : this.data) {
            if (!element.getValue().toString().equals(value.toString())) continue;
            return element.getText();
        }
        return null;
    }

    public void setSelected(Object value) {
        String key = this.getKeyForValue(value);
        this.setSelected(this.getRadioButton(key).getModel());
    }

    public void setSelected(JRadioButton jr) {
        this.setSelected(jr.getModel());
    }

    private void setSelected(ButtonModel model) {
        this.buttonGroup.setSelected(model, true);
    }

    private void createRadioButtonForItem(Object item, int idx) {
        GridBagConstraints gbc = new GridBagConstraints(0, idx, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0);
        JRadioButton jRadioButton = new JRadioButton(item.toString());
        jRadioButton.setActionCommand(item.toString());
        this.buttonGroup.add(jRadioButton);
        this.add((Component)jRadioButton, gbc);
        this.validate();
        jRadioButton.addActionListener(this);
    }

    public ComboItem getSelected() {
        String mapKey;
        if (null != this.buttonGroup.getSelection() && null != (mapKey = this.buttonGroup.getSelection().getActionCommand())) {
            for (int i = 0; i < this.data.size(); ++i) {
                if (!this.data.get(i).toString().equals(mapKey)) continue;
                return this.data.get(i);
            }
        }
        return null;
    }

    public int getFakeButtonsNr() {
        return this.fakeButtonsNr;
    }

    public void setFakeButtonsNr(int fakeButtonsNr) {
        this.fakeButtonsNr = fakeButtonsNr;
        this.clearAllButtons();
        for (int i = 0; i < fakeButtonsNr; ++i) {
            this.createRadioButtonForItem("test" + i, i);
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    public void actionPerformed(ActionEvent e) {
        for (ActionListener listener : (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
            listener.actionPerformed(e);
        }
    }

    public void setAllButtonsEnabled(boolean b) {
        Enumeration<AbstractButton> jr = this.buttonGroup.getElements();
        while (jr.hasMoreElements()) {
            JRadioButton tempButton = (JRadioButton)jr.nextElement();
            tempButton.setEnabled(b);
        }
    }
}

