/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.ui.components;

import com.bwanms.ui.components.ComboItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCheckBoxPanel
extends JPanel
implements ActionListener {
    private List<ComboItem> data = new ArrayList<ComboItem>();
    private HashMap<ComboItem, JCheckBox> items = new HashMap();
    private boolean fakeCheckBoxes = true;
    private int fakeButtonsNr = 13;
    private int numberOfRowsToSplitFrom = 0;
    private int deductFromIndex = 0;
    private int row = 0;

    public JCheckBoxPanel() {
        this.initComponents();
    }

    public void addItem(ComboItem value) {
        if (this.fakeCheckBoxes) {
            this.clearAllButtons();
            this.fakeCheckBoxes = false;
        }
        this.data.add(value);
        this.createJCheckBoxForItem(value, this.data.size() - 1);
    }

    public ComboItem getItem(int idx) {
        return this.data.get(idx);
    }

    public int getItemCount() {
        return this.data.size();
    }

    private void initComponents() {
        GridBagLayout gb = new GridBagLayout();
        gb.columnWidths = new int[]{0, 0};
        gb.columnWeights = new double[]{1.0, 1.0E-4};
        this.setLayout(gb);
        for (int i = 0; i < this.fakeButtonsNr; ++i) {
            this.createJCheckBoxForItem(new ComboItem("i", "test" + i), i);
        }
    }

    public void clearAllButtons() {
        for (JCheckBox jc : this.items.values()) {
            this.remove(jc);
        }
        this.data.clear();
        this.items.clear();
    }

    private ComboItem getComboItemForValue(Object value) {
        for (ComboItem element : this.data) {
            if (!element.getValue().toString().equals(value.toString())) continue;
            return element;
        }
        return null;
    }

    public void setSelected(Object value) {
        this.setSelected(value, true);
    }

    public void setSelected(Object value, boolean enabled) {
        ComboItem item = this.getComboItemForValue(value);
        this.items.get(item).setSelected(enabled);
    }

    public void setEnabled(Object itemValue, boolean enabled) {
        ComboItem item = this.getComboItemForValue(itemValue);
        this.items.get(item).setEnabled(enabled);
    }

    public boolean isSelected(int itemIndex) {
        ComboItem item = this.getItem(itemIndex);
        return this.items.get(item).isSelected();
    }

    private void createJCheckBoxForItem(ComboItem item, int idx) {
        if (this.numberOfRowsToSplitFrom > 0 && idx > 0 && idx % this.numberOfRowsToSplitFrom == 0) {
            ++this.row;
            this.deductFromIndex += this.numberOfRowsToSplitFrom;
        }
        GridBagConstraints gbc = new GridBagConstraints(this.row, idx -= this.deductFromIndex, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 10), 0, 0);
        JCheckBox jCheckBox = new JCheckBox(item.toString());
        jCheckBox.setActionCommand(item.toString());
        this.items.put(item, jCheckBox);
        this.add((Component)jCheckBox, gbc);
        this.validate();
        jCheckBox.addActionListener(this);
    }

    public List<ComboItem> getSelected() {
        ArrayList<ComboItem> tempList = new ArrayList<ComboItem>();
        for (ComboItem item : this.data) {
            JCheckBox jc = this.items.get(item);
            if (!jc.isSelected()) continue;
            tempList.add(item);
        }
        return tempList;
    }

    public int getFakeButtonsNr() {
        return this.fakeButtonsNr;
    }

    public void setFakeButtonsNr(int fakeButtonsNr) {
        this.fakeButtonsNr = fakeButtonsNr;
        this.clearAllButtons();
        for (int i = 0; i < fakeButtonsNr; ++i) {
            this.createJCheckBoxForItem(new ComboItem("i", "test" + i), i);
        }
    }

    public static final void main(String[] args) {
        JCheckBoxPanel jc = new JCheckBoxPanel();
        JFrame jf = new JFrame();
        jf.add(jc);
        jf.validate();
        jf.setVisible(true);
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (ActionListener listener : (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
            listener.actionPerformed(e);
        }
    }

    public void setAllButtonsEnabled(boolean b) {
        for (JCheckBox ckb : this.items.values()) {
            ckb.setEnabled(b);
        }
    }

    public void setAllButtonsSelected(boolean b) {
        for (JCheckBox ckb : this.items.values()) {
            ckb.setSelected(b);
        }
    }

    public int getNumberOfRowsToSplitFrom() {
        return this.numberOfRowsToSplitFrom;
    }

    public void setNumberOfRowsToSplitFrom(int numberOfRowsToSplitFrom) {
        this.numberOfRowsToSplitFrom = numberOfRowsToSplitFrom;
    }
}

