/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.ui.components;

import com.bwanms.ui.components.JCheckBoxListItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCheckBoxList<T extends JCheckBoxListItem>
extends JPanel {
    private List<T> data = new ArrayList<T>();
    private Map<T, JCheckBox> values = new HashMap<T, JCheckBox>();
    private boolean fakeCheckBoxes = true;
    private int fakeButtonsNr = 3;

    public JCheckBoxList() {
        this.fakeCheckBoxes = true;
        this.initComponents();
    }

    public JCheckBoxList(T[] initData) {
        this.fakeCheckBoxes = false;
        for (int i = 0; i < initData.length; ++i) {
            this.data.add(initData[i]);
        }
        this.initComponents();
    }

    public JCheckBoxList(List<T> data) {
        this.fakeCheckBoxes = false;
        this.data = data;
        this.initComponents();
    }

    public void addItem(T item) {
        if (this.fakeCheckBoxes) {
            this.clear();
            this.fakeCheckBoxes = false;
        }
        this.data.add(item);
        this.createCheckBoxForItem(item, this.data.size());
    }

    public void removeItemAtIndex(int idx) {
        if (idx < this.data.size()) {
            JCheckBoxListItem item = (JCheckBoxListItem)this.data.remove(idx);
            JCheckBox removedCheckBox = this.values.remove(item);
            this.remove(removedCheckBox);
            this.revalidate();
        }
    }

    public int getItemsCount() {
        return this.data.size();
    }

    public T getItem(int idx) {
        return (T)((JCheckBoxListItem)this.data.get(idx));
    }

    public void setSelectedItems(List<T> selItems) {
        for (JCheckBoxListItem item : selItems) {
            this.setIsSectedItem(item, true);
        }
    }

    public void setSelectedItems(T ... selItems) {
        for (T item : selItems) {
            this.setIsSectedItem(item, true);
        }
    }

    public void setSelectedIndexes(int ... indexes) throws ArrayIndexOutOfBoundsException {
        for (int idx : indexes) {
            this.setIsSectedIndex(idx, true);
        }
    }

    public List<T> getSelectedItems() {
        ArrayList<JCheckBoxListItem> ret = new ArrayList<JCheckBoxListItem>();
        JCheckBox checkBox = null;
        for (JCheckBoxListItem item : this.data) {
            checkBox = this.values.get(item);
            if (!checkBox.isSelected()) continue;
            ret.add(item);
        }
        return ret;
    }

    public boolean isItemSelected(T item) {
        JCheckBox checkBox = this.values.get(item);
        return checkBox.isSelected();
    }

    public void setIsSectedItem(T item, boolean select) {
        JCheckBox checkBox = this.values.get(item);
        checkBox.setSelected(select);
    }

    public void setIsSectedIndex(int index, boolean select) throws ArrayIndexOutOfBoundsException {
        if (index > this.data.size()) {
            throw new ArrayIndexOutOfBoundsException(index + " out of range.");
        }
        this.setIsSectedItem((JCheckBoxListItem)this.data.get(index), select);
    }

    private void initComponents() {
        GridBagLayout gb = new GridBagLayout();
        gb.columnWidths = new int[]{0, 0};
        gb.columnWeights = new double[]{1.0, 1.0E-4};
        this.setLayout(gb);
        this.initCheckBoxes();
    }

    private void initCheckBoxes() {
        if (this.fakeCheckBoxes) {
            for (int i = 0; i < this.fakeButtonsNr; ++i) {
                JCheckBoxListTestItem testItem = new JCheckBoxListTestItem("test" + i, i);
                this.data.add(i, testItem);
                this.createCheckBoxForItem(testItem, i);
            }
        } else {
            int y = 0;
            for (JCheckBoxListItem item : this.data) {
                this.createCheckBoxForItem(item, y++);
            }
        }
        this.validate();
    }

    private void createCheckBoxForItem(T item, int idx) {
        GridBagConstraints gbc = new GridBagConstraints(0, idx, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0);
        JCheckBox checkBox = new JCheckBox(item.getDisplayString());
        this.values.put(item, checkBox);
        this.add((Component)checkBox, gbc);
        this.validate();
    }

    public int getFakeButtonsNr() {
        return this.fakeButtonsNr;
    }

    public void setFakeButtonsNr(int fakeButtonsNr) {
        this.fakeButtonsNr = fakeButtonsNr;
        this.fakeCheckBoxes = true;
        this.clear();
        this.initCheckBoxes();
    }

    public void clear() {
        int noOfItems = this.getItemsCount();
        for (int i = noOfItems - 1; i >= 0; --i) {
            this.removeItemAtIndex(i);
        }
    }

    public static final void main(String[] args) {
        JCheckBoxList jc = new JCheckBoxList();
        JFrame jf = new JFrame();
        jf.add(jc);
        jf.validate();
        jf.setVisible(true);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (int i = 0; i < this.values.size(); ++i) {
            this.values.get(this.data.get(i)).setEnabled(enabled);
        }
    }

    private class JCheckBoxListTestItem
    implements JCheckBoxListItem {
        private String text;
        private Object val;

        public JCheckBoxListTestItem(String text, Object val) {
            this.text = text;
            this.val = val;
        }

        public String getDisplayString() {
            return this.text;
        }

        public Object getMappedValue() {
            return this.val;
        }
    }
}

