/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.ui.components;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private Image backgroundImage;
    private boolean sizeToImage;
    private int displayMode = 0;
    public static final int DISPLAY_MODE_NONE = 0;
    public static final int DISPLAY_MODE_STRETCH = 1;
    public static final int DISPLAY_MODE_TILE = 2;

    public boolean isSizeToImage() {
        return this.sizeToImage;
    }

    public void setSizeToImage(boolean sizeToImage) {
        this.sizeToImage = sizeToImage;
    }

    public Dimension getPreferredSize() {
        Dimension superSize = super.getPreferredSize();
        if (this.sizeToImage && this.backgroundImage != null) {
            Dimension ret = new Dimension(Math.max(superSize.width, this.backgroundImage.getWidth(this)), Math.max(superSize.height, this.backgroundImage.getHeight(this)));
            return ret;
        }
        return superSize;
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(Image backgroundImage) {
        this.backgroundImage = backgroundImage;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Rectangle r = this.getBounds();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, r.width, r.height);
        }
        if (this.backgroundImage != null) {
            switch (this.displayMode) {
                case 1: {
                    g.drawImage(this.backgroundImage, 0, 0, r.width, r.height, this);
                    break;
                }
                case 2: {
                    this.drawTiled(g);
                    break;
                }
                default: {
                    g.drawImage(this.backgroundImage, 0, 0, this);
                }
            }
        }
    }

    private void drawTiled(Graphics g) {
        Rectangle r = this.getBounds();
        int widthCount = r.width / this.backgroundImage.getWidth(this) + 1;
        int heightCount = r.height / this.backgroundImage.getHeight(this) + 1;
        int xDraw = 0;
        int yDraw = 0;
        for (int i = 0; i < widthCount; ++i) {
            for (int j = 0; j < heightCount; ++j) {
                g.drawImage(this.backgroundImage, xDraw, yDraw, this);
                yDraw += this.backgroundImage.getHeight(this);
            }
            xDraw += this.backgroundImage.getWidth(this);
            yDraw = 0;
        }
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(int displayMode) {
        this.displayMode = displayMode;
    }
}

