/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.ui.components;

import com.bwanms.gui.RegexFormatter;
import java.awt.Component;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.text.DefaultFormatter;
import org.apache.log4j.Logger;

public class FormattedTextEditor
extends DefaultCellEditor
implements TableCellEditor {
    private static final Logger logger = Logger.getLogger(FormattedTextEditor.class);
    private JFormattedTextField textField;
    private Pattern pattern = null;

    public FormattedTextEditor(JFormattedTextField textField) {
        super(textField);
        this.textField = textField;
        this.clickCountToStart = 2;
    }

    public FormattedTextEditor(DefaultFormatter formatter) {
        super(new JFormattedTextField(formatter));
        this.textField = (JFormattedTextField)this.editorComponent;
    }

    public FormattedTextEditor(RegexFormatter formatter, Pattern pattern) {
        super(new JFormattedTextField(formatter));
        this.pattern = pattern;
        this.textField = (JFormattedTextField)this.getComponent();
    }

    public FormattedTextEditor(JFormattedTextField jFText, RegexFormatter formatter) {
        super(jFText);
    }

    public Object getCellEditorValue() {
        return this.textField.getValue();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.textField.setValue(value == null ? "" : value);
        return this.textField;
    }

    public boolean stopCellEditing() {
        try {
            this.textField.commitEdit();
            if (this.pattern == null) {
                return super.stopCellEditing();
            }
            Matcher matcher = this.pattern.matcher(this.textField.getValue().toString());
            if (matcher.matches()) {
                return super.stopCellEditing();
            }
            return false;
        }
        catch (ParseException pe) {
            logger.error((Object)"stopCellEditing() - Pattern did not match", (Throwable)pe);
            return false;
        }
    }

    public void cancelCellEditing() {
        this.textField.setValue("");
        try {
            this.textField.commitEdit();
        }
        catch (ParseException e) {
            logger.error((Object)"cancelCellEditing() - Pattern did not match", (Throwable)e);
        }
        super.cancelCellEditing();
    }
}

