/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.ui.components;

import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.filechooser.FileFilter;

public class ExtensionFileFilter
extends FileFilter {
    private Map<String, FileFilter> filters = null;
    private String description = null;

    public ExtensionFileFilter() {
    }

    public ExtensionFileFilter(String extension, String description) {
        this.filters = new Hashtable<String, FileFilter>(5);
        if (extension != null) {
            this.filters.put(extension.toLowerCase(), this);
        }
        this.description = description;
    }

    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String extension = this.getExtension(f);
        return extension != null && this.filters.get(extension) != null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String extension) {
        if (this.filters == null) {
            this.filters = new Hashtable<String, FileFilter>(5);
        }
        if (extension != null) {
            this.filters.put(extension.toLowerCase(), this);
        }
        this.description = null;
    }
}

