/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.ui.components;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.manager.generic.EntityManagerRowTableModel;
import com.bwanms.gui.manager.generic.EventManagerRowTableModel;
import java.awt.Color;
import java.awt.Component;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class EventCellRenderer
implements TableCellRenderer {
    public static final DefaultTableCellRenderer DEFAULT_RENDERER = new DefaultTableCellRenderer();
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(EventCellRenderer.class);
    private EventManagerRowTableModel tableModel;

    public EventCellRenderer(EntityManagerRowTableModel tableModel) {
        this.tableModel = (EventManagerRowTableModel)tableModel;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent comp = (JComponent)DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (isSelected) {
            DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column).setBackground(table.getSelectionBackground());
        } else {
            Color color = this.tableModel.getRowColor(row, column);
            if (color == null) {
                comp.repaint();
            }
            comp.setBackground(color);
        }
        String eventAdvisor = this.tableModel.getEventAdvisor(row, column);
        if (eventAdvisor != null && !eventAdvisor.equals("")) {
            StringBuffer advisorBuffer = new StringBuffer("<html>");
            advisorBuffer.append(this.splitAdvisor(eventAdvisor));
            advisorBuffer.append("<!--").append(row).append(column).append("-->");
            comp.setToolTipText(advisorBuffer.toString());
        }
        return comp;
    }

    private String splitAdvisor(String advisor) {
        StringBuffer advisorBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(advisor, " ");
        if (stringTokenizer.countTokens() > 10) {
            int counter = 0;
            while (stringTokenizer.hasMoreTokens()) {
                advisorBuffer.append(stringTokenizer.nextToken()).append(" ");
                if (++counter <= 10) continue;
                advisorBuffer.append("<br>");
                counter = 0;
            }
        } else {
            int beginIndex = 0;
            for (int endIndex = 80; endIndex < advisor.length(); endIndex *= 2) {
                advisorBuffer.append(advisor.substring(beginIndex, endIndex)).append("<br>");
                beginIndex = endIndex++;
            }
            advisorBuffer.append(advisor.substring(beginIndex++, advisor.length()));
        }
        return advisorBuffer.toString();
    }
}

