/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.ui.components;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.equipmentmanager.AbstractEquipmentManagerConfig;
import com.bwanms.gui.equipmentmanager.AllEquipmentManagerConfig;
import com.bwanms.gui.util.treetable.AbstractTreeTableModel;
import com.bwanms.gui.util.treetable.TreeTableModel;
import com.bwanms.model.EqTreeNode;
import com.bwanms.model.EqTreeNodeValue;
import com.bwanms.model.Equipment;
import com.bwanms.model.StandardSoftwareVersions;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquipmentSelectorTreeTableModel
extends AbstractTreeTableModel {
    protected static final Internationalizer i18n = AbstractEquipmentManagerConfig.i18n;
    protected static final String platformType = System.getProperty("com.bwanms.platform", "remote");
    protected static final String[] columnNames;
    protected static final Class[] columnTypes;
    protected static final int IDX_NAME = 0;
    protected static final int IDX_MODEL = 1;
    protected static final int IDX_HW_REVISION = 2;
    protected static final int IDX_RUNNING_VERSION = 3;
    protected static final int IDX_MAIN_VERSION = 4;
    protected static final int IDX_SHADOW_VERSION = 5;
    protected static final int IDX_LOCATION = 6;
    protected List<EqTreeNode> nodes = new LinkedList<EqTreeNode>();

    protected String[] getColumnNames() {
        return columnNames;
    }

    protected Class[] getColumnTypes() {
        return columnTypes;
    }

    public EquipmentSelectorTreeTableModel() {
        this(new EqTreeNode());
    }

    public EquipmentSelectorTreeTableModel(EqTreeNode root) {
        super(root);
    }

    @Override
    public EqTreeNode getRoot() {
        return (EqTreeNode)this.root;
    }

    @Override
    public int getColumnCount() {
        return this.getColumnNames().length;
    }

    @Override
    public String getColumnName(int column) {
        return this.getColumnNames()[column];
    }

    @Override
    public Class getColumnClass(int column) {
        return this.getColumnTypes()[column];
    }

    @Override
    public Object getValueAt(Object node, int column) {
        EqTreeNodeValue eqNodeValue = ((EqTreeNode)node).getValue();
        if (eqNodeValue == null) {
            return null;
        }
        Equipment equipment = eqNodeValue.getEquipment();
        if (equipment == null) {
            return null;
        }
        switch (column) {
            case 0: {
                return equipment.getName();
            }
            case 1: {
                return AllEquipmentManagerConfig.ddI18N.translateString(equipment.getClass().getName());
            }
            case 2: {
                return equipment.getHardwareRevision();
            }
            case 3: {
                return equipment.getFirmwareVersion();
            }
            case 4: {
                if (equipment instanceof StandardSoftwareVersions) {
                    return ((StandardSoftwareVersions)((Object)equipment)).getOperationalSoftwareVersion();
                }
                return null;
            }
            case 5: {
                if (equipment instanceof StandardSoftwareVersions) {
                    return ((StandardSoftwareVersions)((Object)equipment)).getShadowSoftwareVersion();
                }
                return null;
            }
            case 6: {
                return equipment.getLocation() == null ? null : equipment.getLocation().getName();
            }
        }
        return null;
    }

    @Override
    public Object getChild(Object parent, int childIndex) {
        EqTreeNode parentNode = (EqTreeNode)parent;
        return parentNode.getChildAt(childIndex);
    }

    @Override
    public int getChildCount(Object parent) {
        EqTreeNode parentNode = (EqTreeNode)parent;
        return parentNode.getChildCount();
    }

    public void addNode(EqTreeNode parent, EqTreeNode child) {
        if (child == null || this.nodes.contains(child)) {
            return;
        }
        if (parent == null) {
            parent = (EqTreeNode)this.root;
        }
        parent.addChild(child);
        this.nodes.add(child);
        int[] childIndices = new int[]{this.getIndexOfChild(parent, child)};
        Object[] children = new Object[]{child};
        this.fireTreeNodesInserted(this, this.getPath(parent), childIndices, children);
    }

    public EqTreeNode getNode(Equipment searchEquipment) {
        if (searchEquipment == null) {
            return null;
        }
        for (EqTreeNode node : this.nodes) {
            EqTreeNodeValue nodeValue = node.getValue();
            if (nodeValue == null || searchEquipment.getId() != nodeValue.getEquipment().getId()) continue;
            return node;
        }
        return null;
    }

    public TreePath getTreePath(TreeNode node) {
        return new TreePath(this.getPath(node));
    }

    protected Object[] getPath(TreeNode node) {
        if (node == null) {
            return new Object[0];
        }
        LinkedList<TreeNode> nodes = new LinkedList<TreeNode>();
        do {
            nodes.add(0, node);
        } while ((node = node.getParent()) != null);
        return nodes.toArray();
    }

    public void removeChildrenNodes(EqTreeNode node) {
        int count = node.getChildCount();
        if (count == 0) {
            return;
        }
        for (int i = count - 1; i >= 0; --i) {
            EqTreeNode child = (EqTreeNode)node.getChildAt(i);
            if (child.getChildCount() > 0) {
                this.removeChildrenNodes(child);
            }
            this.removeNode(child);
        }
    }

    public void removeNode(EqTreeNode node) {
        EqTreeNode parentNode;
        if (!this.nodes.contains(node)) {
            return;
        }
        this.nodes.remove(node);
        if (node.getChildCount() > 0) {
            this.removeChildrenNodes(node);
        }
        if ((parentNode = (EqTreeNode)node.getParent()) != null) {
            int[] childIndices = new int[]{this.getIndexOfChild(parentNode, node)};
            Object[] children = new Object[]{node};
            parentNode.removeChildAt(childIndices[0]);
            this.fireTreeNodesRemoved(this, this.getPath(parentNode), childIndices, children);
        }
    }

    public List<EqTreeNode> getNodes() {
        return new ArrayList<EqTreeNode>(this.nodes);
    }

    public void updateNode(EqTreeNode node, Equipment equipment, int eqType, boolean selected) {
        if (node == null || equipment == null) {
            return;
        }
        EqTreeNodeValue eqValue = new EqTreeNodeValue(equipment, equipment.getName());
        eqValue.setType(eqType);
        eqValue.setSelected(selected);
        node.setValue(eqValue);
        TreeNode parentNode = node.getParent();
        int[] childIndices = new int[]{this.getIndexOfChild(parentNode, node)};
        Object[] children = new Object[]{node};
        this.fireTreeNodesChanged(this, this.getPath(parentNode), childIndices, children);
    }

    static {
        LinkedHashMap<String, Class<String>> columns = new LinkedHashMap<String, Class<String>>(10);
        columns.put(i18n.translateString("Name"), TreeTableModel.class);
        columns.put(i18n.translateString("Model"), String.class);
        columns.put(i18n.translateString("HardwareRevision"), String.class);
        columns.put(i18n.translateString("RunningSoftwareVersion"), String.class);
        columns.put(i18n.translateString("MainSoftwareVersion"), String.class);
        columns.put(i18n.translateString("ShadowSoftwareVersion"), String.class);
        if (!platformType.equalsIgnoreCase("local")) {
            columns.put(i18n.translateString("Location"), String.class);
        }
        columnNames = columns.keySet().toArray(new String[0]);
        columnTypes = columns.values().toArray(new Class[0]);
    }
}

