/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.ui.components;

import com.bwanms.gui.util.AbstractTreeCellEditor;
import com.bwanms.gui.util.treetable.JTreeTable;
import com.bwanms.model.EqTreeNode;
import com.bwanms.model.EqTreeNodeValue;
import com.bwanms.ui.components.EqNodeEditorPanel;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.EventObject;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;

public class EqNodeTreeCellEditor
extends AbstractTreeCellEditor {
    private EqNodeEditorPanel panel;
    private EqTreeNodeValue value = null;
    private JTreeTable jTreeTable;

    public EqNodeTreeCellEditor(EqNodeEditorPanel panel) {
        this(panel, null);
    }

    public EqNodeTreeCellEditor(EqNodeEditorPanel panel, JTreeTable jTreeTable) {
        this.panel = panel;
        this.jTreeTable = jTreeTable;
        this.initComponents();
    }

    private void initComponents() {
        this.panel.getChkEquipment().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                EqNodeTreeCellEditor.this.setValueSelected(!EqNodeTreeCellEditor.this.panel.getChkEquipment().isSelected());
                EqNodeTreeCellEditor.this.stopTableEditing();
            }
        });
        this.panel.getLblEquipment().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                EqNodeTreeCellEditor.this.stopTableEditing();
            }
        });
    }

    private void setValueSelected(boolean selected) {
        if (this.value != null) {
            this.value.setSelected(selected);
        }
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
        EqTreeNode eqNode = (EqTreeNode)value;
        EqTreeNodeValue eqValue = eqNode.getValue();
        if (eqValue instanceof EqTreeNodeValue) {
            JCheckBox chkEquipment = this.panel.getChkEquipment();
            JLabel lblEquipment = this.panel.getLblEquipment();
            this.value = eqValue;
            lblEquipment.setText(eqValue.getName());
            lblEquipment.setForeground(selected ? this.textSelectionColor : this.textNonSelectionColor);
            lblEquipment.setBackground(selected ? this.backgroundSelectionColor : this.backgroundNonSelectionColor);
            chkEquipment.setSelected(eqValue.isSelected());
            chkEquipment.setVisible(eqValue.isSelectable());
            chkEquipment.setForeground(selected ? this.textSelectionColor : this.textNonSelectionColor);
            chkEquipment.setBackground(selected ? this.backgroundSelectionColor : this.backgroundNonSelectionColor);
            this.panel.setBackground(selected ? this.backgroundSelectionColor : this.backgroundNonSelectionColor);
            this.panel.revalidate();
        } else {
            this.value = null;
        }
        this.stopTableEditing();
        return this.panel;
    }

    public Object getCellEditorValue() {
        return this.value;
    }

    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return false;
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped(new ChangeEvent(this));
        return true;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled(new ChangeEvent(this));
    }

    private void stopTableEditing() {
        this.stopCellEditing();
        if (this.jTreeTable != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EqNodeTreeCellEditor.this.jTreeTable.dispatchEvent(new KeyEvent(EqNodeTreeCellEditor.this.jTreeTable, 401, new Date().getTime(), 0, 27, '\uffff'));
                }
            });
        }
    }
}

