/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.ui.components;

import com.bwanms.ui.components.SimpleRowTableModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.JTableHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntityManagerTableModel<T>
extends SimpleRowTableModel {
    private List<T> entities = new ArrayList<T>();
    private Map<String, Integer> cache = new HashMap<String, Integer>();

    public EntityManagerTableModel(SimpleRowTableModel.ColumnDefinition[] columns) {
        super(columns);
    }

    public EntityManagerTableModel(SimpleRowTableModel.ColumnDefinition[] columns, JTableHeader jTableHeader) {
        super(columns, jTableHeader);
    }

    public void addRow(T entity, String key) {
        this.addNewRow(key, true);
        int row = this.getRowCount() - 1;
        this.setRowValues(row, entity);
        this.entities.add(entity);
        this.cache.put(key, row);
    }

    public void removeRows(int[] rows) {
        if (rows == null) {
            return;
        }
        for (int i = rows.length - 1; i >= 0; --i) {
            this.removeRow(this.getKeyOfRow(rows[i]));
        }
    }

    public void removeRow(String key) {
        int rowNumber = this.cache.remove(key);
        this.rows.remove(rowNumber);
        this.entities.remove(rowNumber);
        for (String el : this.cache.keySet()) {
            int i = this.cache.get(el);
            if (i <= rowNumber) continue;
            this.cache.put(el, i - 1);
        }
        this.fireTableRowsDeleted(rowNumber, rowNumber);
    }

    @Override
    public void removeRow(int row) {
        String key = this.getKeyOfRow(row);
        this.removeRow(key);
    }

    private String getKeyOfRow(int row) {
        for (Map.Entry<String, Integer> entry : this.cache.entrySet()) {
            if (entry.getValue() != row) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("Inexistent row: " + row);
    }

    public abstract void setRowValues(int var1, T var2);

    public void updateRow(T entity, String key) {
        if (this.cache.get(key) == null) {
            this.addRow(entity, key);
        } else {
            this.setRowValues(this.cache.get(key), entity);
            this.entities.set(this.cache.get(key), entity);
        }
    }

    public T getEntity(int row) {
        return this.entities.get(row);
    }

    public int getEntityRow(String key) {
        Integer row = this.cache.get(key);
        return null != row ? row : -1;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.getRowState(rowIndex) != 1;
    }

    @Override
    public void clearTable() {
        super.clearTable();
        this.entities.clear();
        this.cache.clear();
    }

    public void sortByColumn(int modelIndex) {
    }

    public List<T> getEntities() {
        return this.entities;
    }
}

