/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.ui.components;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComboBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboItem
implements Serializable {
    private static final long serialVersionUID = 9046658672425963267L;
    private static TextComparator textComparator;
    Object value;
    private String text;
    private boolean invalidItem = false;

    public ComboItem(Object value, String text) {
        if (text == null) {
            throw new IllegalArgumentException("Null text not allowed");
        }
        this.value = value;
        this.text = text;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return this.text;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof ComboItem) {
            if (this.value == null) {
                return ((ComboItem)o).getValue() == null;
            }
            return this.value.equals(((ComboItem)o).getValue());
        }
        if (o instanceof String) {
            return this.value.toString().equals(o);
        }
        return this.value.equals(o);
    }

    public static ComboItem[] fromArrays(Object[] values, String[] labels) {
        if (values.length != labels.length || values.length == 0) {
            throw new IllegalArgumentException("Zero");
        }
        ComboItem[] ret = new ComboItem[values.length];
        for (int i = 0; i < values.length; ++i) {
            ret[i] = new ComboItem(values[i], labels[i]);
        }
        return ret;
    }

    public static ComboItem findItemByText(JComboBox comboBox, String text) {
        int comboItemCount = comboBox.getItemCount();
        for (int i = 0; i < comboItemCount; ++i) {
            if (!text.equals(((ComboItem)comboBox.getItemAt(i)).toString())) continue;
            return (ComboItem)comboBox.getItemAt(i);
        }
        return null;
    }

    public static ComboItem findItemByValue(JComboBox comboBox, Object value) {
        int comboItemCount = comboBox.getItemCount();
        for (int i = 0; i < comboItemCount; ++i) {
            if (!value.equals(((ComboItem)comboBox.getItemAt(i)).getValue())) continue;
            return (ComboItem)comboBox.getItemAt(i);
        }
        return null;
    }

    public static ComboItem findItemByStringValue(JComboBox comboBox, String value) {
        int comboItemCount = comboBox.getItemCount();
        for (int i = 0; i < comboItemCount; ++i) {
            ComboItem item = (ComboItem)comboBox.getItemAt(i);
            if (null == item.getValue() || !value.equals(item.getValue().toString())) continue;
            return item;
        }
        return null;
    }

    public static Object getSelectedItem(JComboBox comboBox) {
        return ((ComboItem)comboBox.getSelectedItem()).getValue();
    }

    public static ComboItem selectItemByValue(JComboBox comboBox, Object value) {
        ComboItem selected = ComboItem.findItemByValue(comboBox, value);
        if (selected != null) {
            comboBox.setSelectedItem(selected);
        }
        return selected;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public static ComboItem searchByValue(List<ComboItem> valueSet, Object value) {
        if (valueSet != null) {
            for (ComboItem item : valueSet) {
                if (!item.getValue().equals(value)) continue;
                return item;
            }
        }
        return null;
    }

    public boolean isInvalidItem() {
        return this.invalidItem;
    }

    public void setInvalidItem(boolean invalidItem) {
        this.invalidItem = invalidItem;
    }

    public static TextComparator getTextComparator() {
        if (textComparator == null) {
            textComparator = new TextComparator();
        }
        return textComparator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TextComparator
    implements Comparator<ComboItem> {
        @Override
        public int compare(ComboItem o1, ComboItem o2) {
            return o1.getText().toLowerCase().compareTo(o2.getText().toLowerCase());
        }
    }
}

