/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.ui;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvalidValuesUtil {
    private static final Logger log = Logger.getLogger(InvalidValuesUtil.class);
    private Map<JComponent, InputPropertyChangeListener> inputPropertyChangeListeners;
    private Map<Object, Boolean> marked = new HashMap<Object, Boolean>();

    public InvalidValuesUtil() {
        this.inputPropertyChangeListeners = new HashMap<JComponent, InputPropertyChangeListener>();
    }

    private void addChangeListener(JComponent component) {
        if (component instanceof JTextField) {
            ((JTextField)component).getDocument().addDocumentListener(this.getInputPropertyChangeListener(component));
        }
    }

    private void addOutsideBorder(JComponent component, Border outsideBorder) {
        component.setBorder(BorderFactory.createCompoundBorder(outsideBorder, component.getBorder()));
    }

    private void changed(JComponent component) {
        log.debug((Object)("Changed " + component));
        this.removeOutsideBorder(component);
        this.addOutsideBorder(component, BorderFactory.createLineBorder(Color.yellow, 2));
    }

    public void clearReportedInvalidValues(List<InvalidValue> invalidValues) {
        for (InvalidValue value : invalidValues) {
            if (!(value.getBean() instanceof JComponent) || !this.marked.containsKey(value.getBean())) continue;
            JComponent component = (JComponent)value.getBean();
            this.removeOutsideBorder(component);
            this.removeChangeListener(component);
            this.marked.remove(value.getBean());
        }
        invalidValues.clear();
        if (this.marked.size() > 0) {
            throw new RuntimeException("Logical error. Marked should be empty");
        }
    }

    public void clearAllInvalidValues(List<InvalidValue> invalidValues) {
        invalidValues.clear();
        this.marked.clear();
    }

    private InputPropertyChangeListener getInputPropertyChangeListener(JComponent component) {
        InputPropertyChangeListener result = this.inputPropertyChangeListeners.get(component);
        if (result == null) {
            result = new InputPropertyChangeListener(component);
            this.inputPropertyChangeListeners.put(component, result);
        }
        return result;
    }

    private void removeChangeListener(JComponent component) {
        if (component instanceof JTextField) {
            ((JTextField)component).getDocument().removeDocumentListener(this.getInputPropertyChangeListener(component));
        }
    }

    private void removeOutsideBorder(JComponent component) {
        component.setBorder(((CompoundBorder)component.getBorder()).getInsideBorder());
    }

    public void reportInvalidValues(List<InvalidValue> invalidValues) {
        for (InvalidValue value : invalidValues) {
            if (!(value.getBean() instanceof JComponent) || this.marked.containsKey(value.getBean())) continue;
            JComponent component = (JComponent)value.getBean();
            this.addOutsideBorder(component, BorderFactory.createLineBorder(Color.red, 2));
            this.addChangeListener(component);
            this.marked.put(component, Boolean.TRUE);
        }
    }

    private class InputPropertyChangeListener
    implements DocumentListener {
        private JComponent component;
        private final Logger logger = Logger.getLogger(InputPropertyChangeListener.class);

        public InputPropertyChangeListener(JComponent component) {
            this.component = component;
        }

        public void changedUpdate(DocumentEvent e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("changedUpdate() - inputChanged-changedUpdate" + e));
            }
            InvalidValuesUtil.this.changed(this.component);
        }

        public void insertUpdate(DocumentEvent e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("insertUpdate() - inputChanged-insertUpdate" + e));
            }
            InvalidValuesUtil.this.changed(this.component);
        }

        public void removeUpdate(DocumentEvent e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("removeUpdate() - inputChanged-removeUpdate" + e));
            }
            InvalidValuesUtil.this.changed(this.component);
        }
    }
}

