/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.ui;

import com.bwanms.ui.components.ComboItem;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public class CustomComboRenderer
extends JLabel
implements ListCellRenderer {
    private static final Logger logger = Logger.getLogger(CustomComboRenderer.class);
    private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private Class clazz;

    public CustomComboRenderer(Class clazz, JPanel panel) {
        this.clazz = clazz;
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setComponentOrientation(list.getComponentOrientation());
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        Border border = null;
        if (cellHasFocus) {
            if (isSelected) {
                border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
        } else {
            border = noFocusBorder;
        }
        this.setBorder(border);
        String iconResourceName = (String)((ComboItem)value).getValue();
        logger.debug((Object)("Search resouce for icon [" + iconResourceName + "]"));
        ImageIcon icon = new ImageIcon(this.clazz.getResource(iconResourceName));
        this.setIcon(icon);
        this.setText(value.toString());
        return this;
    }
}

