/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.tasks.singlerangescan;

import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JSpinnerBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.model.Contact;
import com.bwanms.model.Location;
import com.bwanms.model.SNMPAgentAuthentication;
import com.bwanms.model.SingleRangeScanTask;
import com.bwanms.model.Task;
import com.bwanms.tasks.singlerangescan.SingleRangeScanTaskPanel;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.util.FormUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleRangeScanTaskView
extends AbstractBindedEditorView<Task> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(SingleRangeScanTaskView.class);
    private SingleRangeScanTaskPanel panel = new SingleRangeScanTaskPanel();

    public List<InvalidValue> validate() {
        return new ArrayList<InvalidValue>();
    }

    @Override
    public List<Binder> getBinders() {
        ArrayList<Binder> binders = new ArrayList<Binder>();
        binders.add(new DefaultBinder(this.getUI(), this.entity).add(new JTextFieldBinding("txtName", "name", i18n.translateString("Name"))).add(new JTextFieldBinding("txtRangeStart", "rangeStart", i18n.translateString("RangeStart"))).add(new JTextFieldBinding("txtRangeEndSubnetMask", "rangeEnd", i18n.translateString("RangeEndSubnetMask"))).add(new JSpinnerBinding("spnrRetries", "retries", i18n.translateString("Retries"))).add(new JSpinnerBinding("spnrTimeout", "timeout", i18n.translateString("Timeout"))));
        return binders;
    }

    @Override
    public void fillUI(Task task) {
        SingleRangeScanTask temp = (SingleRangeScanTask)task;
        if (temp.getRangeType() != null) {
            if (temp.getRangeType() == 1) {
                this.panel.getComboRangeType().setSelectedIndex(0);
            } else {
                this.panel.getComboRangeType().setSelectedIndex(1);
            }
        }
        this.panel.getSelectorLocation().setValue(temp.getLocation());
        this.panel.getSelectorContact().setValue(temp.getContact());
        if (temp.getRetries() != null) {
            this.panel.getSpnrRetries().setValue(temp.getRetries());
        }
        if (temp.getTimeout() != null) {
            this.panel.getSpnrTimeout().setValue(temp.getTimeout() / 1000L);
        }
        List<SNMPAgentAuthentication> communities = temp.getCommunities();
        this.panel.getTableModel().clearTable();
        if (communities != null) {
            int i = 0;
            for (SNMPAgentAuthentication auth : communities) {
                this.panel.getTableModel().addNewRow(null, false);
                this.panel.getTableModel().setInitialValueAt(auth.getReadCommunity(), i, 0);
                this.panel.getTableModel().setInitialValueAt(auth.getWriteCommunity(), i++, 1);
            }
        }
    }

    @Override
    public List<InvalidValue> configureEntity(Task task) {
        FormUtil.stopTableEditing(this.panel.getTable());
        SingleRangeScanTask temp = (SingleRangeScanTask)task;
        temp.setName(this.panel.getTxtName().getText());
        temp.setRangeStart(this.panel.getTxtRangeStart().getText());
        temp.setRangeEnd(this.panel.getTxtRangeEndSubnetMask().getText());
        temp.setRangeType((Integer)((ComboItem)this.panel.getComboRangeType().getSelectedItem()).getValue());
        temp.setRetries(((Number)this.panel.getSpnrRetries().getValue()).intValue());
        long timeoutInSeconds = ((Number)this.panel.getSpnrTimeout().getValue()).longValue();
        temp.setTimeout(timeoutInSeconds);
        ArrayList<SNMPAgentAuthentication> communities = new ArrayList<SNMPAgentAuthentication>();
        for (int i = 0; i < this.panel.getTableModel().getRowCount(); ++i) {
            SNMPAgentAuthentication auth = new SNMPAgentAuthentication();
            auth.setReadCommunity((String)this.panel.getTableModel().getValueAt(i, 0));
            auth.setWriteCommunity((String)this.panel.getTableModel().getValueAt(i, 1));
            communities.add(auth);
        }
        temp.setCommunities(communities);
        temp.setContact((Contact)this.panel.getSelectorContact().getValue());
        temp.setLocation((Location)this.panel.getSelectorLocation().getValue());
        List<InvalidValue> invaldValues = super.configureEntity(task);
        temp.setTimeout(1000L * timeoutInSeconds);
        return invaldValues;
    }

    @Override
    public JComponent getUI() {
        return this.panel;
    }

    @Override
    public boolean close() {
        return true;
    }

    @Override
    public String getTitle() {
        return i18n.translateString("SingleRangeScanTask");
    }

    @Override
    public String getApplicationPermission() {
        return "Av:ConfigureTasks";
    }

    @Override
    public String getHelpTopic() {
        return "bwanms.help.tasks.rangescan";
    }
}

