/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.tasks.singlerangescan;

import com.bwanms.gui.TaskRuntimeResultsView;
import com.bwanms.gui.taskmanager.ClientDataCallback;
import com.bwanms.model.IPScanResult;
import com.bwanms.model.SingleRangeScanTask;
import com.bwanms.model.SingleRangeScanTaskRuntimeStatus;
import com.bwanms.model.Task;
import com.bwanms.model.TaskRuntimeStatus;
import com.bwanms.tasks.singlerangescan.SingleRangeScanTaskRuntimeResultsPanel;
import com.bwanms.util.IpAddressRange;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class SingleRangeScanTaskRuntimeResultsView
implements TaskRuntimeResultsView {
    private static final Logger log = Logger.getLogger(SingleRangeScanTaskRuntimeResultsView.class);
    private SingleRangeScanTaskRuntimeResultsPanel panel = new SingleRangeScanTaskRuntimeResultsPanel();
    private ClientDataCallback callback;

    public void setTask(Task task) {
        SingleRangeScanTask sTask = (SingleRangeScanTask)task;
        IpAddressRange range = sTask.getRange();
        this.panel.setRange(range);
    }

    public void updateResults(TaskRuntimeStatus runtime) {
        SingleRangeScanTaskRuntimeStatus runtimeStatus = (SingleRangeScanTaskRuntimeStatus)runtime;
        log.info((Object)(" [[[[[[ SCANNED ]]]]]  --> " + runtimeStatus.getResults().size()));
        for (IPScanResult result : runtimeStatus.getResults()) {
            this.panel.getTableModel().setResultForAddress(result);
        }
    }

    public JComponent getUI() {
        return this.panel;
    }

    public boolean close() {
        return false;
    }

    public void cleanup() {
    }

    public String getTitle() {
        return "RuntimeResultsViewer";
    }

    public void setClientDataCallback(ClientDataCallback callback) {
        this.callback = callback;
    }
}

