/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.tasks.singlerangescan;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.Selectors;
import com.bwanms.gui.selectors.SelectorComponent;
import com.bwanms.gui.selectors.SelectorViewValueDisplay;
import com.bwanms.model.Contact;
import com.bwanms.model.Location;
import com.bwanms.tasks.singlerangescan.SingleRangeScanTaskPanelController;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;

public class SingleRangeScanTaskPanel
extends JPanel {
    private SingleRangeScanTaskPanelController controller;
    private SimpleRowTableModel tableModel;
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(SingleRangeScanTaskPanel.class);
    private JLabel lblName;
    private JTextField txtName;
    private JLabel lblRangeType;
    private JComboBox comboRangeType;
    private JLabel lblRangeStart;
    private JTextField txtRangeStart;
    private JLabel lblRangeEndSubnetMask;
    private JTextField txtRangeEndSubnetMask;
    private JComponent goodiesFormsSeparator3;
    private JLabel label1;
    private SelectorComponent selectorLocation;
    private JLabel label4;
    private SelectorComponent selectorContact;
    private JComponent goodiesFormsSeparator2;
    private JLabel label2;
    private JSpinner spnrRetries;
    private JLabel label3;
    private JSpinner spnrTimeout;
    private JComponent goodiesFormsSeparator1;
    private JButton btnAdd;
    private JButton btnDelete;
    private JScrollPane scrollPane1;
    private JTable table;

    public SingleRangeScanTaskPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        i18n.getSwingInternationalizer().translateComponent(this);
        this.controller = new SingleRangeScanTaskPanelController(this);
        this.tableModel = new SimpleRowTableModel(new SimpleRowTableModel.ColumnDefinition[]{new SimpleRowTableModel.ColumnDefinition(i18n.translateString("ReadCommunity"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("WriteCommunity"), String.class)});
        this.table.setModel(this.tableModel);
        this.table.setSelectionMode(0);
        this.comboRangeType.addItem(new ComboItem(1, i18n.translateString("IPRange")));
        this.comboRangeType.addItem(new ComboItem(2, i18n.translateString("Subnet")));
        this.selectorLocation.setDisplay(new SelectorViewValueDisplay(){

            public String toDisplayString(Object value) {
                return ((Location)value).getName();
            }
        });
        this.selectorLocation.setSelectorView(Selectors.getSelectorView(Location.class, "0"));
        this.selectorContact.setDisplay(new SelectorViewValueDisplay(){

            public String toDisplayString(Object value) {
                return ((Contact)value).getContactId();
            }
        });
        this.selectorContact.setSelectorView(Selectors.getSelectorView(Contact.class, null));
    }

    private void initComponents() {
        DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.lblRangeType = new JLabel();
        this.comboRangeType = new JComboBox();
        this.lblRangeStart = new JLabel();
        this.txtRangeStart = new JTextField();
        this.lblRangeEndSubnetMask = new JLabel();
        this.txtRangeEndSubnetMask = new JTextField();
        this.goodiesFormsSeparator3 = compFactory.createSeparator("NMSReference");
        this.label1 = new JLabel();
        this.selectorLocation = new SelectorComponent();
        this.label4 = new JLabel();
        this.selectorContact = new SelectorComponent();
        this.goodiesFormsSeparator2 = compFactory.createSeparator("SNMPParameters");
        this.label2 = new JLabel();
        this.spnrRetries = new JSpinner();
        this.label3 = new JLabel();
        this.spnrTimeout = new JSpinner();
        this.goodiesFormsSeparator1 = compFactory.createSeparator("SNMPCommunities");
        this.btnAdd = new JButton();
        this.btnDelete = new JButton();
        this.scrollPane1 = new JScrollPane();
        this.table = new JTable();
        CellConstraints cc = new CellConstraints();
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.dluX((int)50), 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)45)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.DLUX14), new ColumnSpec((Size)Sizes.dluX((int)29)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec("max(default;50dlu)")}));
        this.lblName.setText("Name");
        this.add((Component)this.lblName, cc.xy(3, 3));
        this.add((Component)this.txtName, cc.xywh(5, 3, 4, 1));
        this.lblRangeType.setText("RangeType");
        this.add((Component)this.lblRangeType, cc.xy(3, 5));
        this.comboRangeType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SingleRangeScanTaskPanel.this.comboRangeTypeActionPerformed(e);
            }
        });
        this.add((Component)this.comboRangeType, cc.xywh(5, 5, 4, 1));
        this.lblRangeStart.setText("RangeStart");
        this.add((Component)this.lblRangeStart, cc.xy(3, 7));
        this.add((Component)this.txtRangeStart, cc.xywh(5, 7, 4, 1));
        this.lblRangeEndSubnetMask.setText("RangeEndSubnetMask");
        this.add((Component)this.lblRangeEndSubnetMask, cc.xy(3, 9));
        this.add((Component)this.txtRangeEndSubnetMask, cc.xywh(5, 9, 4, 1));
        this.add((Component)this.goodiesFormsSeparator3, cc.xywh(1, 11, 10, 1));
        this.label1.setText("Location");
        this.add((Component)this.label1, cc.xy(3, 13));
        this.selectorLocation.setNullable(true);
        this.add((Component)this.selectorLocation, cc.xywh(5, 13, 4, 1));
        this.label4.setText("Contact");
        this.add((Component)this.label4, cc.xy(3, 15));
        this.selectorContact.setNullable(true);
        this.add((Component)this.selectorContact, cc.xywh(5, 15, 4, 1));
        this.add((Component)this.goodiesFormsSeparator2, cc.xywh(1, 17, 10, 1));
        this.label2.setText("Retries");
        this.add((Component)this.label2, cc.xy(3, 19));
        this.spnrRetries.setModel(new SpinnerNumberModel(new Integer(2), null, null, new Integer(1)));
        this.add((Component)this.spnrRetries, cc.xy(5, 19));
        this.label3.setText("Timeout(s)");
        this.add((Component)this.label3, cc.xy(3, 21));
        this.spnrTimeout.setModel(new SpinnerNumberModel(new Long(15L), null, null, new Long(1L)));
        this.add((Component)this.spnrTimeout, cc.xy(5, 21));
        this.add((Component)this.goodiesFormsSeparator1, cc.xywh(1, 23, 10, 1));
        this.btnAdd.setText("Add");
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SingleRangeScanTaskPanel.this.btnAddActionPerformed(e);
            }
        });
        this.add((Component)this.btnAdd, cc.xy(5, 25));
        this.btnDelete.setText("Delete");
        this.btnDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SingleRangeScanTaskPanel.this.btnDeleteActionPerformed(e);
            }
        });
        this.add((Component)this.btnDelete, cc.xywh(7, 25, 2, 1));
        this.scrollPane1.setViewportView(this.table);
        this.add((Component)this.scrollPane1, cc.xywh(3, 27, 6, 3));
    }

    private void comboRangeTypeActionPerformed(ActionEvent e) {
        this.controller.toggleSubnetRange();
    }

    private void btnAddActionPerformed(ActionEvent e) {
        this.controller.addCommunity();
    }

    private void btnDeleteActionPerformed(ActionEvent e) {
        this.controller.deleteCommunity();
    }

    public JComboBox getComboRangeType() {
        return this.comboRangeType;
    }

    public JLabel getLblName() {
        return this.lblName;
    }

    public JLabel getLblRangeEndSubnetMask() {
        return this.lblRangeEndSubnetMask;
    }

    public JLabel getLblRangeStart() {
        return this.lblRangeStart;
    }

    public JLabel getLblRangeType() {
        return this.lblRangeType;
    }

    public JTextField getTxtName() {
        return this.txtName;
    }

    public JTextField getTxtRangeEndSubnetMask() {
        return this.txtRangeEndSubnetMask;
    }

    public JTextField getTxtRangeStart() {
        return this.txtRangeStart;
    }

    public JTable getTable() {
        return this.table;
    }

    public SimpleRowTableModel getTableModel() {
        return this.tableModel;
    }

    public JSpinner getSpnrRetries() {
        return this.spnrRetries;
    }

    public JSpinner getSpnrTimeout() {
        return this.spnrTimeout;
    }

    public SelectorComponent getSelectorContact() {
        return this.selectorContact;
    }

    public SelectorComponent getSelectorLocation() {
        return this.selectorLocation;
    }
}

