/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.tasks.singlerangescan;

import com.bwanms.gui.Internationalizer;
import com.bwanms.model.IPScanResult;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.IpAddress;
import com.bwanms.util.IpAddressRange;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class RangeScanTaskRuntimeResultsTableModel
extends SimpleRowTableModel {
    private static final Logger log = Logger.getLogger(RangeScanTaskRuntimeResultsTableModel.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RangeScanTaskRuntimeResultsTableModel.class);
    private Map<String, Integer> rowForAddress = new HashMap<String, Integer>();

    public RangeScanTaskRuntimeResultsTableModel(IpAddressRange range) {
        super(new SimpleRowTableModel.ColumnDefinition[]{new SimpleRowTableModel.ColumnDefinition(i18n.translateString("IPAddress"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("Result"), String.class)});
        this.initRows(range);
    }

    private void initRows(IpAddressRange range) {
        int row = 0;
        Iterator<IpAddress> iterator = range.getIterator();
        while (iterator.hasNext()) {
            String address = iterator.next().toString();
            this.addNewRow(address, true);
            this.setInitialValueAt(address, row, 0);
            this.rowForAddress.put(address, row++);
        }
    }

    public void setResultForAddress(IPScanResult result) {
        Integer row = this.rowForAddress.get(result.getIpAddress());
        if (row == null) {
            log.warn((Object)("attempted to set result for out-of-range address : " + result.getIpAddress()));
        }
        this.setValueAt(i18n.translateString(result.getResultString(), result.getEqName()), row, 1);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }
}

