/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.tasks.pmcollection;

import com.bwanms.performance.PerformanceCollectionActiveEntity;
import com.bwanms.tasks.pmcollection.GroupingStrategy;
import com.bwanms.tasks.pmcollection.UserData;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.snmp4j.event.ResponseEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleEntityGroupingStrategy
implements GroupingStrategy<PerformanceCollectionActiveEntity, List<ResponseEvent>> {
    Map<PerformanceCollectionActiveEntity, List<ResponseEvent>> map = new LinkedHashMap<PerformanceCollectionActiveEntity, List<ResponseEvent>>();

    @Override
    public void group(List<ResponseEvent> events) {
        for (ResponseEvent event : events) {
            UserData userData = (UserData)event.getUserObject();
            PerformanceCollectionActiveEntity activeEntity = userData.getActiveEntity();
            List<ResponseEvent> respList = this.map.get(activeEntity);
            if (respList == null) {
                respList = new LinkedList<ResponseEvent>();
                this.map.put(activeEntity, respList);
            }
            respList.add(event);
        }
    }

    @Override
    public Iterator<Map.Entry<PerformanceCollectionActiveEntity, List<ResponseEvent>>> iterator() {
        return this.map.entrySet().iterator();
    }
}

