/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.tasks.pmcollection;

import com.bwanms.be.QueueI;
import com.bwanms.model.file.FileData;
import com.bwanms.model.file.FileUtil;
import com.bwanms.model.file.PerformanceCollectionFile;
import com.bwanms.model.task.PerformanceCollectionGenericTask;
import com.bwanms.performance.IPerformanceCounterFilter;
import com.bwanms.performance.MeasCollecProcessor;
import com.bwanms.performance.PMCollectionEntityTypeUtil;
import com.bwanms.performance.PMCollectionFactoriesProvider;
import com.bwanms.performance.PerformanceCollectionActiveEntity;
import com.bwanms.performance.db.PmDirectDataCollector;
import com.bwanms.persistence.Datastore;
import com.bwanms.persistence.DatastoreDecoratorUtil;
import com.bwanms.tasks.pmcollection.GroupingStrategy;
import com.bwanms.tasks.pmcollection.MeasCollecContext;
import com.bwanms.tasks.pmcollection.PMCollectionTaskExecutor;
import com.bwanms.tasks.pmcollection.UserData;
import com.bwanms.util.SystemPropertyUtil;
import com.bwanms.util.task.OperationStatus;
import com.ngnms.apps.pmcollection.db.AvPmDataItem;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.snmp4j.event.ResponseEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessResultsJob
implements Runnable {
    private static final Logger log = Logger.getLogger(ProcessResultsJob.class);
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_HHmm");
    private final PMCollectionTaskExecutor taskExecutor;
    private final QueueI<ResponseEvent> queue;
    private final PerformanceCollectionGenericTask task;
    private long period;
    private long baseTime;
    private PmDirectDataCollector collector;
    private AtomicInteger cycleIdx = new AtomicInteger();
    private Integer endOcurrences;

    public ProcessResultsJob(PMCollectionTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
        this.task = taskExecutor.getTask();
        this.queue = taskExecutor.getResponseEventQueue();
        this.period = taskExecutor.getResultsPeriod();
        this.collector = new PmDirectDataCollector(String.valueOf(this.task.getId()), (int)(this.period / 1000L));
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public long getBaseTime() {
        return this.baseTime;
    }

    public void setBaseTime(long baseTime) {
        this.baseTime = baseTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.cycleIdx.incrementAndGet();
            if (this.endOcurrences != null && this.cycleIdx.intValue() > this.endOcurrences) {
                this.taskExecutor.abort();
                log.debug((Object)"stop executing jobs due to exceeded cycle limits");
                return;
            }
            log.debug((Object)String.format("starting basetime %d period %d", this.baseTime, this.period));
            ArrayList<ResponseEvent> list = new ArrayList<ResponseEvent>();
            this.queue.drainTo(list);
            IPerformanceCounterFilter performanceCounterFilter = PMCollectionEntityTypeUtil.getPerformanceCounterFilter(this.task.getEntityType());
            if (performanceCounterFilter != null) {
                performanceCounterFilter.filterResponse(list);
            }
            this.taskExecutor.startNewCycle(this.baseTime + this.period);
            int size = list.size();
            if (log.isDebugEnabled()) {
                StringBuilder builder = new StringBuilder();
                if (size > 0) {
                    for (int i = 0; i < size; ++i) {
                        ResponseEvent event = list.get(i);
                        if (i > 0) {
                            builder.append(" ,");
                        }
                        builder.append(event.getRequest().getRequestID());
                    }
                }
                log.debug((Object)String.format("Process %d responses: [%s]", size, builder.toString()));
            }
            if (size > 0) {
                if (this.task.getStorage() == 2) {
                    this.processFileStorage(list);
                } else if (this.task.getStorage() == 1) {
                    this.processRawStorage(list);
                } else {
                    log.debug((Object)("unimplemented storage " + this.task.getStorage()));
                }
            } else {
                log.debug((Object)"No pm collection counters, skip process");
            }
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
        }
        finally {
            this.baseTime += this.period;
        }
    }

    private void processRawStorage(ArrayList<ResponseEvent> list) {
        this.taskExecutor.getOperationsCache().logDataProcessorStatus(OperationStatus.IN_PROGRESS);
        int size = list.size();
        log.debug((Object)String.format("process list for raw storage: %d responses", size));
        LinkedHashMap<Integer, ArrayList<ResponseEvent>> cycleMaps = new LinkedHashMap<Integer, ArrayList<ResponseEvent>>();
        for (int i = 0; i < size; ++i) {
            ResponseEvent event = list.get(i);
            UserData userData = (UserData)event.getUserObject();
            int cycleIndex = userData.getCycleIndex();
            log.debug((Object)String.format("Cycle idx = %d", cycleIndex));
            ArrayList<ResponseEvent> cycleList = (ArrayList<ResponseEvent>)cycleMaps.get(cycleIndex);
            if (cycleList == null) {
                cycleList = new ArrayList<ResponseEvent>();
                log.debug((Object)String.format("found new cycle %d", cycleIndex));
                cycleMaps.put(cycleIndex, cycleList);
            }
            cycleList.add(event);
        }
        this.taskExecutor.getOperationsCache().logCycleInfo(this.cycleIdx.intValue());
        this.collector.cycleStarted();
        this.taskExecutor.getOperationsCache().logDataCollectorStatus(OperationStatus.IN_PROGRESS);
        for (Integer cycleIndex : cycleMaps.keySet()) {
            List eventsList = (List)cycleMaps.get(cycleIndex);
            log.debug((Object)String.format("process %d responses for cycle index %d", eventsList.size(), cycleIndex));
            ArrayList<AvPmDataItem> pDataItems = new ArrayList<AvPmDataItem>();
            for (ResponseEvent event : eventsList) {
                UserData userData = (UserData)event.getUserObject();
                PerformanceCollectionActiveEntity activeEntity = userData.getActiveEntity();
                pDataItems.addAll(activeEntity.processResponse(event.getRequest(), event.getResponse(), userData.getCountersIndex(), userData.getTimeStamps()));
            }
            log.debug((Object)String.format("store %d AvPmDataItem on cycle %d", pDataItems.size(), cycleIndex));
            this.collector.storePmData(pDataItems);
        }
        this.collector.cycleFinished();
        this.taskExecutor.getOperationsCache().logDataCollectorStatus(OperationStatus.IDLE);
        this.taskExecutor.getOperationsCache().logDataProcessorStatus(OperationStatus.IDLE);
    }

    private void processFileStorage(ArrayList<ResponseEvent> list) {
        int size = list.size();
        log.debug((Object)String.format("process list for file storage: %d responses", size));
        GroupingStrategy<?, ?> groupingStrategy = PMCollectionFactoriesProvider.INSTANCE.getPMCollectionFactory().createGroupingStrategy();
        groupingStrategy.group(list);
        log.debug((Object)"store to file for export");
        Iterator<Map.Entry<?, ?>> it = groupingStrategy.iterator();
        while (it.hasNext()) {
            this.processCollectionForExport(PMCollectionFactoriesProvider.INSTANCE.getPMCollectionFactory().createMeasCollecCtx(it.next(), this.task.getId(), this.task.getPollingInterval(), this.baseTime - this.period, this.baseTime));
        }
    }

    private void deleteOldPmFilesFromDB() {
        try {
            DatastoreDecoratorUtil.run(new Runnable(){

                public void run() {
                    try {
                        long pmFileTTL = SystemPropertyUtil.getLong("com.bwanms.pmcollection.pmFileTTL", 1L);
                        log.info((Object)("PmCollectionFiles TTL in days: " + pmFileTTL));
                        StringBuffer queryBuffer = new StringBuffer("DELETE FROM ");
                        queryBuffer.append(PerformanceCollectionFile.class.getName()).append(" WHERE timestamp < :timestamp");
                        Query query = Datastore.session().createQuery(queryBuffer.toString());
                        query.setLong("timestamp", System.currentTimeMillis() - (pmFileTTL *= 86400000L));
                        int deleted = query.executeUpdate();
                        log.info((Object)("PmCollectionFiles deleted: " + deleted));
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                }
            });
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
    }

    private void processCollectionForExport(final MeasCollecContext ctx) {
        PerformanceCollectionFile pmFile = null;
        try {
            pmFile = DatastoreDecoratorUtil.call(new Callable<PerformanceCollectionFile>(){

                @Override
                public PerformanceCollectionFile call() throws Exception {
                    PerformanceCollectionFile pmFile = new PerformanceCollectionFile(ProcessResultsJob.this.task);
                    String groupUID = ctx.getGroupUID();
                    Date now = new Date(ProcessResultsJob.this.baseTime);
                    pmFile.setPollingInterval(ProcessResultsJob.this.task.getPollingInterval());
                    pmFile.setTimestamp(now.getTime());
                    pmFile.setEntityName(groupUID);
                    pmFile.setDescription(ProcessResultsJob.this.task.getDescription());
                    String fileName = String.format("PM_%s_%s_%s", ProcessResultsJob.this.task.getName(), groupUID, format.format(now));
                    FileData fileData = new FileData();
                    byte[] fileBytes = (byte[])new MeasCollecProcessor(ctx).process();
                    try {
                        byte[] compressedBytes = FileUtil.compressBytes(fileBytes, fileName + ".xml");
                        fileData.setType((byte)1);
                        fileData.setCompressed(true);
                        fileData.setBytes(compressedBytes);
                    }
                    catch (Exception e) {
                        log.error((Object)("Failed to compress performance collection file: " + fileName + ".xml"), (Throwable)e);
                        fileData.setType((byte)2);
                        fileData.setCompressed(false);
                        fileData.setBytes(fileBytes);
                    }
                    pmFile.setFileData(fileData);
                    pmFile.setFileName(fileName + (fileData.isCompressed() ? ".zip" : ".xml"));
                    Datastore.session().save((Object)pmFile);
                    return pmFile;
                }
            });
        }
        catch (Exception e) {
            log.error((Object)"Failed to persist file content into file manager table", (Throwable)e);
        }
        if (this.task.isAutoExport() && pmFile != null) {
            try {
                String folderName = this.task.getExportFolder();
                File exportFolder = new File(folderName);
                if (!exportFolder.exists()) {
                    exportFolder.mkdir();
                } else if (!exportFolder.isDirectory()) {
                    throw new Exception("Export file has an invalid folder destination: " + folderName);
                }
                String outputStr = folderName + File.separator + FileUtil.escapeForFilesystem(pmFile.getFileName());
                File outputFile = new File(outputStr);
                if (!outputFile.createNewFile()) {
                    throw new Exception("Export file already exists or cannot be created: " + outputFile);
                }
                BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(outputFile));
                output.write(pmFile.getFileData().getBytes());
                output.close();
            }
            catch (Exception e) {
                log.error((Object)"Failed to export file content.", (Throwable)e);
            }
        }
    }

    public void setEndOcurrences(Integer endOcurrences) {
        this.endOcurrences = endOcurrences;
    }

    public Integer getEndOcurrences() {
        return this.endOcurrences;
    }
}

