/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.tasks.pmcollection;

import com.bwanms.be.QueueHelper;
import com.bwanms.be.QueueI;
import com.bwanms.model.ScheduleRecurrence;
import com.bwanms.model.Task;
import com.bwanms.model.TaskExecutionContext;
import com.bwanms.model.TaskRuntimeStatus;
import com.bwanms.model.TaskSchedule;
import com.bwanms.model.task.PerformanceCollectionGenericTask;
import com.bwanms.performance.PMCollectionEntityTypeUtil;
import com.bwanms.performance.PerformanceCollectionActiveEntity;
import com.bwanms.performance.PerformanceCollectionActiveTaskHelper;
import com.bwanms.performance.PerformanceCollectionEntity;
import com.bwanms.performance.db.PmCollectionVariable;
import com.bwanms.persistence.CallableDatastoreDecorator;
import com.bwanms.persistence.Datastore;
import com.bwanms.tasks.pmcollection.AbstractPMCollectionTaskExecutor;
import com.bwanms.tasks.pmcollection.BaseTimeStrategy;
import com.bwanms.tasks.pmcollection.GetCountersJob;
import com.bwanms.tasks.pmcollection.PMCollectionOperationsCache;
import com.bwanms.tasks.pmcollection.ProcessResultsJob;
import com.bwanms.tasks.pmcollection.SignalAction;
import com.bwanms.util.task.Operation;
import com.bwanms.util.task.OperationStatus;
import com.bwanms.util.task.OperationTaskRuntimeStatus;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.snmp4j.event.ResponseEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMCollectionTaskExecutor
extends AbstractPMCollectionTaskExecutor {
    private static final Logger log = Logger.getLogger(PMCollectionTaskExecutor.class);
    private BaseTimeStrategy baseTimeStrategy;
    private final PerformanceCollectionGenericTask task;
    private ScheduledExecutorService getCountersExecutor;
    private ScheduledExecutorService processResultsExecutor;
    private OperationTaskRuntimeStatus runtimeStatus;
    private Operation rootOperation;
    private Operation collectionOperation;
    private transient TaskExecutionContext ctx = null;
    private int taskResult;
    private TreeMap<Long, PerformanceCollectionActiveEntity> activeEntities = new TreeMap();
    public static int snmpRetries = Integer.getInteger("com.ngnms.apps.pmcollection.AvPmCollectionActiveSession.snmpRetries", 0);
    public static int batchSize = Integer.getInteger("com.ngnms.apps.pmcollection.AvPmCollectionActiveSession.batchSize", 100);
    private ProcessResultsJob processResultsJob;
    private GetCountersJob getCountersJob;
    private int resultsPeriod = 900000;
    private long resultsDelay;
    private PMCollectionOperationsCache operationsCache;
    private static final Object lock = new Object();

    public PMCollectionTaskExecutor(PerformanceCollectionGenericTask task) {
        this.task = task;
        this.taskResult = 0;
    }

    public PMCollectionOperationsCache getOperationsCache() {
        if (this.operationsCache == null) {
            throw new IllegalStateException("The operations cache is null");
        }
        return this.operationsCache;
    }

    public PMCollectionTaskExecutor init() {
        this.runtimeStatus = new OperationTaskRuntimeStatus();
        this.operationsCache = new PMCollectionOperationsCache(this.runtimeStatus);
        this.rootOperation = this.runtimeStatus.addOperation(null, "PerformanceCollectionTaskWithName", this.task.getName());
        Operation initOperation = this.runtimeStatus.addOperation(this.rootOperation, "CreateGetCounterJob");
        List<PerformanceCollectionEntity> pmCollectionEntities = this.initActiveEntities();
        this.update(pmCollectionEntities);
        try {
            this.getCountersJob = new GetCountersJob(this);
            this.runtimeStatus.logOperationStatus(initOperation, OperationStatus.COMPLETED);
        }
        catch (IOException e) {
            log.error((Object)"Failed create GetCountersJob", (Throwable)e);
            this.taskResult = 3;
            this.runtimeStatus.logOperationStatus(initOperation, OperationStatus.FAILED);
        }
        this.processResultsJob = new ProcessResultsJob(this);
        log.debug((Object)"create executors services");
        this.processResultsExecutor = Executors.newSingleThreadScheduledExecutor();
        this.getCountersExecutor = Executors.newSingleThreadScheduledExecutor();
        return this;
    }

    public OperationTaskRuntimeStatus getOperationTaskRuntimeStatus() {
        return this.runtimeStatus;
    }

    private void update(final List<PerformanceCollectionEntity> pmCollectionEntities) {
        try {
            new CallableDatastoreDecorator<Object>(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Session session = Datastore.session();
                    for (PerformanceCollectionEntity pmCollEntity : pmCollectionEntities) {
                        session.update((Object)pmCollEntity);
                    }
                    return null;
                }
            }).call();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Deprecated
    private List<PerformanceCollectionEntity> initActiveEntities() {
        String entityType = this.task.getEntityType();
        PerformanceCollectionActiveTaskHelper activeTaskHelper = new PerformanceCollectionActiveTaskHelper(entityType);
        String[] counters = this.task.getCounters();
        log.debug((Object)String.format("Task %s counters %d", entityType, counters.length));
        if (log.isDebugEnabled() && counters.length > 0) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < counters.length; ++i) {
                if (i > 0) {
                    builder.append(" ,");
                }
                builder.append(counters[i]);
            }
            log.debug((Object)String.format("Counters %s", builder.toString()));
        }
        List<PerformanceCollectionEntity> entities = this.task.getEntities();
        ArrayList<PerformanceCollectionEntity> entitiesToUpdate = new ArrayList<PerformanceCollectionEntity>();
        for (PerformanceCollectionEntity pmEntity : entities) {
            Serializable entity = pmEntity.getEntity();
            if (entity == null) continue;
            log.debug((Object)String.format("Entity %s - %s - %s", pmEntity.getEntityName(), counters, entity));
            long entityId = pmEntity.getEntityId();
            PerformanceCollectionActiveEntity activeEntity = PMCollectionTaskExecutor.getActiveEntity(entityType, pmEntity);
            if (activeEntity.isCollectable()) {
                if (!pmEntity.isCollected()) {
                    pmEntity.setCollected(true);
                }
                if (activeEntity.updateCounterList(activeTaskHelper, entity, counters)) {
                    List<Object[]> currentCounters = activeEntity.getCounters();
                    activeEntity.getSnmpRequests();
                    this.logCounters(currentCounters);
                    pmEntity.setCounters((Serializable)((Object)currentCounters));
                    entitiesToUpdate.add(pmEntity);
                }
            }
            this.activeEntities.put(entityId, activeEntity);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)String.format("ActiveEntity %b %s", activeEntity.isCollectable(), activeEntity));
            List<Object[]> activeEntityCounters = activeEntity.getCounters();
            this.logCounters(activeEntityCounters);
        }
        return entitiesToUpdate;
    }

    private void logCounters(List<Object[]> activeEntityCounters) {
        for (Object[] objects : activeEntityCounters) {
            String name = (String)objects[0];
            List keys = (List)objects[1];
            List vars = (List)objects[2];
            log.debug((Object)String.format("Counter name %s vars %s keys %s", name, this.listPmCollectionVariableToString(vars), this.listPmCollectionVariableToString(keys)));
        }
    }

    private String listPmCollectionVariableToString(List<PmCollectionVariable> vars) {
        StringBuilder builder = new StringBuilder();
        builder.append("List<PmCollectionVariable>[");
        if (vars != null) {
            for (PmCollectionVariable pmCollectionVariable : vars) {
                builder.append("name ").append(pmCollectionVariable.getName()).append(" snmpoid ").append(pmCollectionVariable.getOid().toString()).append(" type ").append(pmCollectionVariable.getType()).append(";");
            }
        }
        builder.append("]");
        return builder.toString();
    }

    private static PerformanceCollectionActiveEntity getActiveEntity(String taskType, PerformanceCollectionEntity pmEntity) {
        PerformanceCollectionActiveEntity ret = null;
        Class cls = PMCollectionEntityTypeUtil.getTaskEntityHandlerClassByType(taskType);
        try {
            ret = (PerformanceCollectionActiveEntity)cls.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        ret.init(pmEntity);
        ret.setSnmpRetries(snmpRetries);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(TaskExecutionContext ctx) {
        Object endType;
        this.ctx = ctx;
        this.taskResult = 1;
        TaskSchedule schedule = this.task.getSchedule();
        log.debug((Object)String.format("Task schedule %s", schedule != null ? schedule.toString() : "null"));
        if (schedule != null) {
            ScheduleRecurrence recurrence = schedule.getRecurrence();
            endType = recurrence.getEndType();
            log.debug((Object)String.format("Schedule end type %s", PMCollectionTaskExecutor.getEndType((Integer)endType)));
            if ((Integer)endType == 2) {
                final Date endDate = recurrence.getEndDate();
                log.debug((Object)String.format("End task at %tc", endDate));
                new Thread(new Runnable(){

                    public void run() {
                        while (System.currentTimeMillis() <= endDate.getTime()) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        PMCollectionTaskExecutor.this.abort();
                    }
                }).start();
            } else if ((Integer)endType == 1) {
                Integer endOcurrences = recurrence.getEndOcurrences();
                this.processResultsJob.setEndOcurrences(endOcurrences);
            }
        }
        Operation initOperation = this.runtimeStatus.addOperation(this.rootOperation, "TaskInitialization");
        this.runtimeStatus.logOperationStatus(initOperation, OperationStatus.COMPLETED);
        if (this.task.getEntities().size() == 0) {
            this.taskResult = 3;
            log.debug((Object)("PerformanceCollectionTaskExecutor activeTask " + this.task.getId() + " cannot be started: No Entities"));
            this.collectionOperation = this.runtimeStatus.addOperation(this.rootOperation, "CollectingPerformanceDataNoEntities");
            this.runtimeStatus.logOperationStatus(this.collectionOperation, OperationStatus.FAILED);
            this.runtimeStatus.logOperationStatus(this.rootOperation, OperationStatus.FAILED);
            this.ctx.taskFinished();
            this.task.setState(1);
            this.taskResult = 4;
        } else {
            endType = lock;
            synchronized (endType) {
                if (this.processResultsExecutor == null) {
                    this.processResultsExecutor = Executors.newSingleThreadScheduledExecutor();
                }
                if (this.getCountersExecutor == null) {
                    this.getCountersExecutor = Executors.newSingleThreadScheduledExecutor();
                }
            }
            this.task.setState(2);
            this.taskResult = 1;
            this.collectionOperation = this.runtimeStatus.addOperation(this.rootOperation, "CollectingPerformanceData", String.valueOf(this.task.getEntities().size()), String.valueOf(this.task.getEntities().size()), String.valueOf(this.task.getPollingInterval()));
            this.collectionOperation.setDisplayStyle(0);
            this.runtimeStatus.logOperationStatus(this.collectionOperation, OperationStatus.IN_PROGRESS);
            log.debug((Object)("PerformanceCollectionTaskExecutor activeTask " + this.task.getId() + " started"));
            long currentTimeMillis = System.currentTimeMillis();
            long baseTime = this.getBaseTimeStrategy().getBaseTime(currentTimeMillis);
            this.resultsDelay = baseTime - currentTimeMillis;
            this.processResultsJob.setBaseTime(baseTime);
            long period = Long.getLong("com.bwanms.pmcollection.getcounters", this.task.getPollingInterval() * 60000);
            this.getCountersJob.setPeriod(period);
            this.getCountersJob.setBaseTime(baseTime);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("ResultsDelay %d ResultsPeriod %d CounterPeriod %d", this.resultsDelay, this.resultsPeriod, period));
            }
            this.processResultsExecutor.scheduleAtFixedRate(this.processResultsJob, this.resultsDelay, this.resultsPeriod, TimeUnit.MILLISECONDS);
            this.getCountersExecutor.scheduleAtFixedRate(this.getCountersJob, this.resultsDelay, period, TimeUnit.MILLISECONDS);
        }
    }

    public void startNewCycle(long cycleEndTime) {
        this.getCountersJob.startNewCycle(cycleEndTime);
    }

    private static String getEndType(Integer endType) {
        switch (endType) {
            case 1: {
                return "END AFTER";
            }
            case 0: {
                return "END NO END";
            }
            case 2: {
                return "END ON";
            }
        }
        throw new IllegalArgumentException("Unknown end type " + endType);
    }

    @Override
    public int getExecutionResult() {
        return this.taskResult;
    }

    @Override
    public String getReport() {
        return this.runtimeStatus.toXMLString();
    }

    @Override
    public TaskRuntimeStatus getStatus(Object clientData) {
        if (clientData instanceof SignalAction) {
            SignalAction action = (SignalAction)((Object)clientData);
            switch (action) {
                case ABORT: {
                    log.debug((Object)String.format("abort %s", Task.getStateString(this.task.getState())));
                    this.abort();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Signal action not supported " + (Object)((Object)action));
                }
            }
            return null;
        }
        Integer idx = null != clientData ? (Integer)clientData : 0;
        return this.runtimeStatus.getDiff(idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        Object object = lock;
        synchronized (object) {
            this.getCountersExecutor.shutdown();
            this.processResultsExecutor.shutdown();
            this.getCountersExecutor = null;
            this.processResultsExecutor = null;
        }
        this.taskResult = 2;
        this.ctx.taskFinished();
    }

    public int getResultsPeriod() {
        return this.resultsPeriod;
    }

    public void setResultsPeriod(int resultsPeriod) {
        this.resultsPeriod = resultsPeriod;
        log.debug((Object)String.format("results period %d", resultsPeriod));
    }

    public long getResultsDelay() {
        return this.resultsDelay;
    }

    public BaseTimeStrategy getBaseTimeStrategy() {
        return this.baseTimeStrategy;
    }

    public void setBaseTimeStrategy(BaseTimeStrategy baseTimeStrategy) {
        this.baseTimeStrategy = baseTimeStrategy;
    }

    public static void refreshTask(final PerformanceCollectionGenericTask task) {
        try {
            new CallableDatastoreDecorator<PerformanceCollectionGenericTask>(new Callable<PerformanceCollectionGenericTask>(){

                @Override
                public PerformanceCollectionGenericTask call() throws Exception {
                    Datastore.session().refresh((Object)task);
                    return task;
                }
            }).call();
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public final PerformanceCollectionGenericTask getTask() {
        return this.task;
    }

    public final TreeMap<Long, PerformanceCollectionActiveEntity> getActiveEntities() {
        return this.activeEntities;
    }

    public final QueueI<ResponseEvent> getResponseEventQueue() {
        return QueueHelper.getQueueI(this.task.getClass().getName() + "." + this.task.getId(), ResponseEvent.class);
    }
}

