/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.tasks.pmcollection;

import com.bwanms.util.task.Operation;
import com.bwanms.util.task.OperationStatus;
import com.bwanms.util.task.OperationTaskRuntimeStatus;
import com.bwanms.util.task.OperationTree;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class PMCollectionOperationsCache {
    private static final String ROOT_OP = "ROOT";
    private static final String TASK_SUMMARY_OP = "TaskSummary";
    private static final String TASK_SUMMARY_CYCLES_OP = "Cycles";
    private static final String TASK_SUMMARY_CYCLES_NUMBER = "CyclesNumber";
    private static final String ERRORS_OP = "Errors";
    private static final String LATE_SNMP_RESPONSES_OP = "LateSNMPResponses";
    private static final String SNMP_RESPONSES_WITH_ERROR_OP = "SNMPResponsesWithError";
    private static final String CURRENT_CYCLE_OP = "CurentCycle";
    private static final String DATA_COLLECTOR_OP = "DataCollector";
    private static final String DATA_PROCESSOR_OP = "DataProcessor";
    private OperationTaskRuntimeStatus runtimeStatus;
    private Map<String, Operation> operations = new HashMap<String, Operation>();

    public PMCollectionOperationsCache(OperationTaskRuntimeStatus runtimeStatus2) {
        this.runtimeStatus = runtimeStatus2;
    }

    private Operation getErrorOperation(OperationTaskRuntimeStatus runtimeStatus) {
        return this.getErrorOperation(runtimeStatus, OperationStatus.IN_PROGRESS);
    }

    private Operation getErrorOperation(OperationTaskRuntimeStatus runtimeStatus, OperationStatus status) {
        Operation ret;
        if (this.operations.get(ERRORS_OP) == null) {
            ret = runtimeStatus.addOperation(this.getOperationRoot(runtimeStatus), ERRORS_OP);
            ret.setDisplayStyle(0);
            runtimeStatus.logOperationStatus(ret, status);
            this.operations.put(ERRORS_OP, ret);
        }
        ret = this.operations.get(ERRORS_OP);
        return ret;
    }

    private Operation getErrorResponsesOperation(OperationTaskRuntimeStatus runtimeStatus) {
        return this.getErrorResponsesOperation(runtimeStatus, OperationStatus.IN_PROGRESS);
    }

    private Operation getErrorResponsesOperation(OperationTaskRuntimeStatus runtimeStatus, OperationStatus status) {
        Operation ret;
        if (this.operations.get(SNMP_RESPONSES_WITH_ERROR_OP) == null) {
            ret = runtimeStatus.addOperation(this.getErrorOperation(runtimeStatus), SNMP_RESPONSES_WITH_ERROR_OP);
            ret.setDisplayStyle(0);
            runtimeStatus.logOperationStatus(ret, status);
            this.operations.put(SNMP_RESPONSES_WITH_ERROR_OP, ret);
        }
        ret = this.operations.get(SNMP_RESPONSES_WITH_ERROR_OP);
        return ret;
    }

    private Operation getTaskSummayOperation(OperationTaskRuntimeStatus runtimeStatus) {
        return this.getTaskSummayOperation(runtimeStatus, OperationStatus.IN_PROGRESS);
    }

    private Operation getTaskSummayOperation(OperationTaskRuntimeStatus runtimeStatus, OperationStatus status) {
        Operation ret;
        if (this.operations.get(TASK_SUMMARY_OP) == null) {
            ret = runtimeStatus.addOperation(this.getOperationRoot(runtimeStatus), TASK_SUMMARY_OP);
            ret.setDisplayStyle(0);
            runtimeStatus.logOperationStatus(ret, status);
            this.operations.put(TASK_SUMMARY_OP, ret);
        }
        ret = this.operations.get(TASK_SUMMARY_OP);
        return ret;
    }

    private Operation getTimeoutResponsesOperation(OperationTaskRuntimeStatus runtimeStatus) {
        return this.getTimeoutResponsesOperation(runtimeStatus, OperationStatus.IN_PROGRESS);
    }

    private Operation getTimeoutResponsesOperation(OperationTaskRuntimeStatus runtimeStatus, OperationStatus status) {
        Operation ret;
        if (this.operations.get(LATE_SNMP_RESPONSES_OP) == null) {
            ret = runtimeStatus.addOperation(this.getErrorOperation(runtimeStatus), LATE_SNMP_RESPONSES_OP);
            ret.setDisplayStyle(0);
            runtimeStatus.logOperationStatus(ret, status);
            this.operations.put(LATE_SNMP_RESPONSES_OP, ret);
        }
        ret = this.operations.get(LATE_SNMP_RESPONSES_OP);
        return ret;
    }

    private Operation getTaskSummayCyclesOperation(OperationTaskRuntimeStatus runtimeStatus) {
        return this.getTaskSummayCyclesOperation(runtimeStatus, OperationStatus.IN_PROGRESS);
    }

    private Operation getTaskSummayCyclesOperation(OperationTaskRuntimeStatus runtimeStatus, OperationStatus status) {
        Operation ret;
        if (this.operations.get(TASK_SUMMARY_CYCLES_OP) == null) {
            ret = runtimeStatus.addOperation(this.getTaskSummayOperation(runtimeStatus), TASK_SUMMARY_CYCLES_OP);
            ret.setDisplayStyle(0);
            runtimeStatus.logOperationStatus(ret, status);
            this.operations.put(TASK_SUMMARY_CYCLES_OP, ret);
        }
        ret = this.operations.get(TASK_SUMMARY_CYCLES_OP);
        return ret;
    }

    public void logCycleInfo(int cycleIdx) {
        this.getRuntimeStatus().logOperationStatus(this.getTaskSummayCyclesOperation(this.getRuntimeStatus()), OperationStatus.IN_PROGRESS, (Serializable)((Object)TASK_SUMMARY_CYCLES_NUMBER), cycleIdx);
    }

    public void logDataCollectorStatus(OperationStatus status) {
        this.getRuntimeStatus().logOperationStatus(this.getDataCollectorOperation(this.getRuntimeStatus(), status), status);
    }

    public void logDataProcessorStatus(OperationStatus status) {
        this.getRuntimeStatus().logOperationStatus(this.getDataProcessorOperation(this.getRuntimeStatus(), status), status);
    }

    private Operation getDataProcessorOperation(OperationTaskRuntimeStatus runtimeStatus, OperationStatus status) {
        Operation ret;
        if (this.operations.get(DATA_PROCESSOR_OP) == null) {
            ret = runtimeStatus.addOperation(this.getCurrentCycleOperation(runtimeStatus), DATA_PROCESSOR_OP);
            runtimeStatus.logOperationStatus(ret, status);
            this.operations.put(DATA_PROCESSOR_OP, ret);
        }
        ret = this.operations.get(DATA_PROCESSOR_OP);
        return ret;
    }

    private Operation getDataCollectorOperation(OperationTaskRuntimeStatus runtimeStatus, OperationStatus status) {
        Operation ret;
        if (this.operations.get(DATA_COLLECTOR_OP) == null) {
            ret = runtimeStatus.addOperation(this.getCurrentCycleOperation(runtimeStatus), DATA_COLLECTOR_OP);
            runtimeStatus.logOperationStatus(ret, status);
            this.operations.put(DATA_COLLECTOR_OP, ret);
        }
        ret = this.operations.get(DATA_COLLECTOR_OP);
        return ret;
    }

    private Operation getCurrentCycleOperation(OperationTaskRuntimeStatus runtimeStatus) {
        return this.getCurrentCycleOperation(runtimeStatus, OperationStatus.IN_PROGRESS);
    }

    private Operation getCurrentCycleOperation(OperationTaskRuntimeStatus runtimeStatus, OperationStatus status) {
        Operation ret;
        if (this.operations.get(CURRENT_CYCLE_OP) == null) {
            ret = runtimeStatus.addOperation(this.getOperationRoot(runtimeStatus), CURRENT_CYCLE_OP);
            ret.setDisplayStyle(0);
            runtimeStatus.logOperationStatus(ret, status);
            this.operations.put(CURRENT_CYCLE_OP, ret);
        }
        ret = this.operations.get(CURRENT_CYCLE_OP);
        return ret;
    }

    private Operation getOperationRoot(OperationTaskRuntimeStatus runtimeStatus) {
        if (this.operations.get(ROOT_OP) == null) {
            OperationTree.OperationTreeNode root = (OperationTree.OperationTreeNode)runtimeStatus.getOperationTree().getRoot();
            if (root == null) {
                throw new IllegalStateException("There is no root for this Operation Task Runtime Status");
            }
            Operation rootOp = root.getOperation();
            this.operations.put(ROOT_OP, rootOp);
            return rootOp;
        }
        return this.operations.get(ROOT_OP);
    }

    private OperationTaskRuntimeStatus getRuntimeStatus() {
        if (this.runtimeStatus == null) {
            throw new IllegalStateException("Opeation task runtime status is null");
        }
        return this.runtimeStatus;
    }
}

