/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.tasks.pmcollection;

import com.bwanms.performance.PerformanceCollectionActiveEntity;
import com.bwanms.performance.PerformanceCollectionActiveEntityGroup;
import com.bwanms.tasks.pmcollection.GroupingStrategy;
import com.bwanms.tasks.pmcollection.UserData;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.snmp4j.event.ResponseEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleEntityGroupingStrategy
implements GroupingStrategy<PerformanceCollectionActiveEntityGroup, Map<PerformanceCollectionActiveEntity, List<ResponseEvent>>> {
    Map<PerformanceCollectionActiveEntityGroup, Map<PerformanceCollectionActiveEntity, List<ResponseEvent>>> map = new LinkedHashMap<PerformanceCollectionActiveEntityGroup, Map<PerformanceCollectionActiveEntity, List<ResponseEvent>>>();

    @Override
    public void group(List<ResponseEvent> events) {
        PerformanceCollectionActiveEntity activeEntity;
        LinkedHashMap<PerformanceCollectionActiveEntity, LinkedList<ResponseEvent>> entityMap = new LinkedHashMap<PerformanceCollectionActiveEntity, LinkedList<ResponseEvent>>();
        for (ResponseEvent event : events) {
            UserData userData = (UserData)event.getUserObject();
            activeEntity = userData.getActiveEntity();
            LinkedList<ResponseEvent> respList = (LinkedList<ResponseEvent>)entityMap.get(activeEntity);
            if (respList == null) {
                respList = new LinkedList<ResponseEvent>();
                entityMap.put(activeEntity, respList);
            }
            respList.add(event);
        }
        LinkedHashMap<String, PerformanceCollectionActiveEntityGroup> entityGroupMap = new LinkedHashMap<String, PerformanceCollectionActiveEntityGroup>();
        for (Map.Entry entry : entityMap.entrySet()) {
            activeEntity = (PerformanceCollectionActiveEntity)entry.getKey();
            List respEventList = (List)entry.getValue();
            PerformanceCollectionActiveEntityGroup entityGroup = (PerformanceCollectionActiveEntityGroup)entityGroupMap.get(activeEntity.getIpAddress());
            if (entityGroup == null) {
                entityGroup = new PerformanceCollectionActiveEntityGroup();
                entityGroup.setGroupUID(activeEntity.getGroupUID());
                entityGroup.setElementUID(activeEntity.getElementUID());
                entityGroup.setElementName(activeEntity.getElementName());
                entityGroup.setElementType(activeEntity.getEntityType());
                entityGroup.setSwVersion(activeEntity.getSwVersion());
                entityGroupMap.put(activeEntity.getIpAddress(), entityGroup);
                this.map.put(entityGroup, new LinkedHashMap());
            }
            this.map.get(entityGroup).put(activeEntity, respEventList);
        }
    }

    @Override
    public Iterator<Map.Entry<PerformanceCollectionActiveEntityGroup, Map<PerformanceCollectionActiveEntity, List<ResponseEvent>>>> iterator() {
        return this.map.entrySet().iterator();
    }
}

