/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.tasks.pmcollection;

import com.bwanms.be.QueueI;
import com.bwanms.model.task.PerformanceCollectionGenericTask;
import com.bwanms.performance.PerformanceCollectionActiveEntity;
import com.bwanms.tasks.pmcollection.PMCollectionTaskExecutor;
import com.bwanms.tasks.pmcollection.SnmpSessionFactory;
import com.bwanms.tasks.pmcollection.UserData;
import com.bwanms.util.task.OperationTaskRuntimeStatus;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;

public class GetCountersJob
implements Runnable {
    private static final Logger log = Logger.getLogger(GetCountersJob.class);
    private Snmp snmpSession;
    private final PMCollectionTaskExecutor executor;
    private final PerformanceCollectionGenericTask task;
    private final TreeMap<Long, PerformanceCollectionActiveEntity> activeEntities;
    private CountersResponseListener listener;
    private AtomicLong baseTime;
    private long cycleEndTime;
    private long period;
    private AtomicInteger cycleIndex = new AtomicInteger();

    public GetCountersJob(PMCollectionTaskExecutor executor) throws IOException {
        this.executor = executor;
        this.task = executor.getTask();
        this.activeEntities = executor.getActiveEntities();
        this.snmpSession = SnmpSessionFactory.getSnmpSessionV1V2();
        this.listener = new CountersResponseListener(executor.getResponseEventQueue(), this);
        this.snmpSession.listen();
    }

    public void run() {
        try {
            long totalWaitTime = 0L;
            while (totalWaitTime < 10000L && System.currentTimeMillis() > this.cycleEndTime) {
                try {
                    totalWaitTime += 100L;
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {}
            }
            Date startDate = new Date();
            log.debug((Object)"======================");
            log.debug((Object)String.format("Starting getCountersJob scheduller at %TT, %d.%n", startDate, startDate.getTime()));
            log.debug((Object)"======================");
            this.cycleIndex.incrementAndGet();
            Collection<PerformanceCollectionActiveEntity> values = this.activeEntities.values();
            log.debug((Object)String.format("starting %d active entities", values.size()));
            for (PerformanceCollectionActiveEntity activeEntity : values) {
                Target target = activeEntity.getTarget();
                if (target == null) continue;
                List<PDU> snmpRequests = activeEntity.getSnmpRequests();
                log.debug((Object)String.format("Snmp %d requests", snmpRequests.size()));
                for (int i = 0; i < snmpRequests.size(); ++i) {
                    PDU request = snmpRequests.get(i);
                    log.debug((Object)String.format("Send request %s", request.getRequestID()));
                    Vector variableBindings = request.getVariableBindings();
                    UserData handle = new UserData();
                    handle.setTarget(target);
                    handle.setVariableBindings(variableBindings);
                    handle.setActiveEntity(activeEntity);
                    handle.setCountersIndex(i);
                    handle.setCycleIndex(this.cycleIndex.get());
                    this.sendSnmpRequest(target, request, handle);
                }
            }
            this.baseTime.addAndGet(this.period);
        }
        catch (Throwable e) {
            log.error((Object)e.getLocalizedMessage(), e);
        }
    }

    private void sendSnmpRequest(Target target, PDU request, UserData handle) {
        try {
            target.setTimeout(this.computeTimeout());
            if (target.getTimeout() < 0L) {
                log.info((Object)("timeout is less than 0: " + target.getTimeout() + "  request ignored."));
                return;
            }
            log.debug((Object)String.format("Send %s %d request to %s with timeout %d", PDU.getTypeString((int)request.getType()), request.getRequestID().toLong(), target.getAddress().toString(), target.getTimeout()));
            this.snmpSession.send(request, target, (Object)handle, (ResponseListener)this.listener);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private long computeTimeout() {
        long currentTime = System.currentTimeMillis();
        if (currentTime + this.period <= this.cycleEndTime) {
            return this.period;
        }
        return this.cycleEndTime - currentTime;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public long getBaseTime() {
        return this.baseTime.get();
    }

    public void setBaseTime(long baseTime) {
        if (this.baseTime == null) {
            this.baseTime = new AtomicLong(baseTime);
        } else {
            this.baseTime.set(baseTime);
        }
    }

    public void startNewCycle(long cycleEndTime) {
        this.cycleEndTime = cycleEndTime - 2000L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CountersResponseListener
    implements ResponseListener {
        private final QueueI<ResponseEvent> queue;
        private final GetCountersJob getCountersJob;

        public CountersResponseListener(QueueI<ResponseEvent> queue, GetCountersJob getCountersJob2) {
            this.queue = queue;
            this.getCountersJob = getCountersJob2;
        }

        public void onResponse(ResponseEvent event) {
            block13: {
                try {
                    long timeStamp = System.currentTimeMillis();
                    log.debug((Object)"======================");
                    log.debug((Object)String.format("Response timestamp = %TT, %d.%n", new Date(timeStamp), timeStamp));
                    log.debug((Object)"======================");
                    PDU request = event.getRequest();
                    ((Snmp)event.getSource()).cancel(request, (ResponseListener)this);
                    PDU response = event.getResponse();
                    OperationTaskRuntimeStatus runtimeStatus = GetCountersJob.this.executor.getOperationTaskRuntimeStatus();
                    if (response == null) {
                        log.warn((Object)String.format("Timeout for request %s", request.toString()));
                        return;
                    }
                    log.debug((Object)String.format("Received %s %d request", PDU.getTypeString((int)request.getType()), request.getRequestID().toInt()));
                    log.debug((Object)String.format("Request %s", request.toString()));
                    log.debug((Object)String.format("Response %s", response.toString()));
                    UserData handle = (UserData)event.getUserObject();
                    handle.putTimeStamp(event.getRequest().getRequestID(), GetCountersJob.this.baseTime.get());
                    if (request.getType() == -95) {
                        OID rootOid;
                        OID oid;
                        Object newRequest = null;
                        newRequest = handle.getTarget().getVersion() == 0 ? new PDUv1() : new PDU();
                        newRequest.setType(-95);
                        Vector respVarBinds = response.getVariableBindings();
                        int size = respVarBinds.size();
                        Vector<VariableBinding> rootVarBinds = handle.getVariableBindings();
                        if (size > 0 && (oid = ((VariableBinding)respVarBinds.get(0)).getOid()).startsWith(rootOid = rootVarBinds.get(0).getOid())) {
                            for (int i = 0; i < size; ++i) {
                                VariableBinding respBind = (VariableBinding)respVarBinds.get(i);
                                newRequest.add(respBind);
                            }
                        }
                        if (newRequest.getVariableBindings().size() > 0) {
                            log.debug((Object)"add response ");
                            handle.addResponseEvent(event);
                            this.getCountersJob.sendSnmpRequest(handle.getTarget(), (PDU)newRequest, handle);
                        } else {
                            log.debug((Object)"ignore last response ");
                            List<ResponseEvent> responses = handle.getResponses();
                            log.debug((Object)String.format("put in queue to process %d", responses.size()));
                            for (ResponseEvent responseEvent : responses) {
                                try {
                                    log.debug((Object)String.format("put in queue response %s on cycle: %d", responseEvent.getResponse().getRequestID().toString(), ((UserData)responseEvent.getUserObject()).getCycleIndex()));
                                    this.queue.offer(responseEvent, 100L, TimeUnit.MILLISECONDS);
                                }
                                catch (InterruptedException e) {}
                            }
                        }
                        break block13;
                    }
                    try {
                        log.debug((Object)String.format("put in queue on cycle %d to process %s", ((UserData)event.getUserObject()).getCycleIndex(), event));
                        this.queue.offer(event, 100L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                    }
                }
                catch (Throwable e) {
                    log.error((Object)("Error occurs in onMessage processing. Error msg = " + e.getMessage()), e);
                }
            }
        }
    }
}

