/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.tasks.networkscan;

import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.model.NetworkScanTask;
import com.bwanms.model.Task;
import com.bwanms.tasks.networkscan.NetworkScanTaskPanel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkScanTaskView
extends AbstractBindedEditorView<Task> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(NetworkScanTaskView.class);
    NetworkScanTaskPanel panel = new NetworkScanTaskPanel();

    @Override
    public void fillUI(Task entity) {
        NetworkScanTask task = (NetworkScanTask)entity;
        this.panel.getSpnrTimeout().setValue(task.getTimeout() / 1000L);
        this.panel.getSprnRetries().setValue(task.getRetries());
    }

    @Override
    public List<InvalidValue> configureEntity(Task entity) {
        NetworkScanTask task = (NetworkScanTask)entity;
        task.setTimeout(1000L * ((Number)this.panel.getSpnrTimeout().getValue()).longValue());
        task.setRetries((Integer)this.panel.getSprnRetries().getValue());
        return this.validate();
    }

    public List<InvalidValue> validate() {
        return new ArrayList<InvalidValue>();
    }

    @Override
    public JComponent getUI() {
        return this.panel;
    }

    @Override
    public boolean close() {
        return true;
    }

    @Override
    public String getTitle() {
        return i18n.translateString("NetworkScanTask");
    }

    @Override
    public String getApplicationPermission() {
        return "Av:ConfigureTasks";
    }

    @Override
    public String getHelpTopic() {
        return "bwanms.help.tasks.networkscan";
    }
}

