/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.tasks.networkscan;

import com.bwanms.gui.TaskRuntimeResultsView;
import com.bwanms.gui.taskmanager.ClientDataCallback;
import com.bwanms.model.IPScanResult;
import com.bwanms.model.NetworkScanTask;
import com.bwanms.model.NetworkScanTaskRuntimeRanges;
import com.bwanms.model.NetworkScanTaskRuntimeStatus;
import com.bwanms.model.Task;
import com.bwanms.model.TaskRuntimeStatus;
import com.bwanms.tasks.networkscan.NetworkScanTaskRuntimeResultsPanel;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class NetworkScanTaskRuntimeResultsView
implements TaskRuntimeResultsView {
    private static final Logger log = Logger.getLogger(NetworkScanTaskRuntimeResultsView.class);
    private NetworkScanTaskRuntimeResultsPanel panel = new NetworkScanTaskRuntimeResultsPanel();
    private boolean rangesSet = false;

    public void setTask(Task task) {
        NetworkScanTask nTask = (NetworkScanTask)task;
    }

    public void updateResults(TaskRuntimeStatus runtime) {
        if (runtime instanceof NetworkScanTaskRuntimeRanges) {
            if (!this.rangesSet) {
                log.debug((Object)" ------------------ CLIENT GOT RANGES");
                NetworkScanTaskRuntimeRanges runtimeRanges = (NetworkScanTaskRuntimeRanges)runtime;
                this.panel.setRanges(runtimeRanges.getRanges());
                this.rangesSet = true;
            }
        } else {
            NetworkScanTaskRuntimeStatus runtimeStatus = (NetworkScanTaskRuntimeStatus)runtime;
            if (runtimeStatus != null) {
                log.debug((Object)(" [[[[[[ SCANNED ]]]]]  --> " + runtimeStatus.getResults().size()));
                for (IPScanResult result : runtimeStatus.getResults()) {
                    this.panel.getController().setResultForAddress(runtimeStatus.getUserId(), result);
                }
            }
        }
    }

    public JComponent getUI() {
        return this.panel;
    }

    public boolean close() {
        return true;
    }

    public void cleanup() {
    }

    public String getTitle() {
        return "NetworkScanRuntimeResultsView";
    }

    public void setClientDataCallback(ClientDataCallback callback) {
        this.panel.getController().setCallback(callback);
    }
}

