/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.tasks.networkscan;

import com.bwanms.gui.taskmanager.ClientDataCallback;
import com.bwanms.model.IPScanResult;
import com.bwanms.tasks.networkscan.NetworkScanTaskRuntimeResultsPanel;
import com.bwanms.tasks.singlerangescan.RangeScanTaskRuntimeResultsTableModel;
import com.bwanms.util.IpAddressRange;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class NetworkScanTaskRuntimeResultsPanelController {
    private static final Logger log = Logger.getLogger(NetworkScanTaskRuntimeResultsPanelController.class);
    private NetworkScanTaskRuntimeResultsPanel panel;
    private Map<Long, RangeScanTaskRuntimeResultsTableModel> modelMap;
    private ClientDataCallback callback;

    public NetworkScanTaskRuntimeResultsPanelController(NetworkScanTaskRuntimeResultsPanel panel) {
        this.panel = panel;
        this.modelMap = new HashMap<Long, RangeScanTaskRuntimeResultsTableModel>();
    }

    public void addRange(long id, IpAddressRange ipRange) {
        this.modelMap.put(id, new RangeScanTaskRuntimeResultsTableModel(ipRange));
    }

    public void setActiveDetailsPanel() {
        int row = this.panel.getTableRanges().getSelectedRow();
        if (row >= 0) {
            long id = this.panel.getRangesTableModel().getEntity(row).getId();
            if (this.modelMap.get(id) != null) {
                this.panel.getTableDetails().setModel(this.modelMap.get(id));
                Integer userId = new Long(id).intValue();
                log.info((Object)("SELECTED RANGE WITH ID " + userId));
                this.callback.setClientDataValue(userId);
            } else {
                log.warn((Object)("RANGE " + this.panel.getRangesTableModel().getEntity(row).getStartIp() + " .. " + this.panel.getRangesTableModel().getEntity(row).getEndIp() + " WAS NOT ADDED IN THE MAP ?????"));
            }
        }
    }

    public void setResultForAddress(Integer userId, IPScanResult result) {
        this.modelMap.get(userId.longValue()).setResultForAddress(result);
    }

    public void setCallback(ClientDataCallback callback) {
        this.callback = callback;
    }
}

