/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.tasks.networkscan;

import com.bwanms.gui.Internationalizer;
import com.bwanms.model.NetworkIpAddressRange;
import com.bwanms.tasks.networkscan.NetworkScanTaskRuntimeResultsPanelController;
import com.bwanms.ui.components.EntityManagerTableModel;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.IpAddressRange;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkScanTaskRuntimeResultsPanel
extends JPanel {
    private EntityManagerTableModel<NetworkIpAddressRange> rangesTableModel;
    private NetworkScanTaskRuntimeResultsPanelController controller;
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(NetworkScanTaskRuntimeResultsPanel.class);
    private JScrollPane scrollPane1;
    private JTable tableRanges;
    private JScrollPane scrollPane2;
    private JTable tableDetails;
    private boolean rangesSet = false;

    public NetworkScanTaskRuntimeResultsPanel() {
        this.initComponents();
        this.postInitComponents();
        i18n.getSwingInternationalizer().translateComponent(this);
    }

    private void postInitComponents() {
        this.tableDetails.setSelectionMode(0);
        this.tableRanges.setSelectionMode(0);
        this.controller = new NetworkScanTaskRuntimeResultsPanelController(this);
        this.rangesTableModel = new EntityManagerTableModel<NetworkIpAddressRange>(new SimpleRowTableModel.ColumnDefinition[]{new SimpleRowTableModel.ColumnDefinition(i18n.translateString("Start"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("End/Subnet"), String.class)}){

            @Override
            public void setRowValues(int row, NetworkIpAddressRange entity) {
                int col = 0;
                this.setInitialValueAt(entity.getStartIp(), row, col++);
                this.setInitialValueAt(entity.getEndIp(), row, col++);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        };
        this.tableRanges.setModel(this.rangesTableModel);
    }

    private void initComponents() {
        this.scrollPane1 = new JScrollPane();
        this.tableRanges = new JTable();
        this.scrollPane2 = new JScrollPane();
        this.tableDetails = new JTable();
        CellConstraints cc = new CellConstraints();
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.dluX((int)150), 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.tableRanges.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                NetworkScanTaskRuntimeResultsPanel.this.tableRangesMouseClicked(e);
            }
        });
        this.tableRanges.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                NetworkScanTaskRuntimeResultsPanel.this.tableRangesKeyReleased(e);
            }
        });
        this.scrollPane1.setViewportView(this.tableRanges);
        this.add((Component)this.scrollPane1, cc.xy(1, 3));
        this.scrollPane2.setViewportView(this.tableDetails);
        this.add((Component)this.scrollPane2, cc.xy(3, 3));
    }

    private void tableRangesMouseClicked(MouseEvent e) {
        if (this.rangesSet) {
            this.controller.setActiveDetailsPanel();
        }
    }

    private void tableRangesKeyReleased(KeyEvent e) {
        if (this.rangesSet) {
            this.controller.setActiveDetailsPanel();
        }
    }

    public JTable getTableDetails() {
        return this.tableDetails;
    }

    public JTable getTableRanges() {
        return this.tableRanges;
    }

    public void setRanges(List<NetworkIpAddressRange> ranges) {
        for (NetworkIpAddressRange range : ranges) {
            this.rangesTableModel.addRow(range, String.valueOf(range.getId()));
            IpAddressRange ipRange = range.toIpAddressRange();
            this.controller.addRange(range.getId(), ipRange);
        }
        this.rangesSet = true;
    }

    public EntityManagerTableModel<NetworkIpAddressRange> getRangesTableModel() {
        return this.rangesTableModel;
    }

    public NetworkScanTaskRuntimeResultsPanelController getController() {
        return this.controller;
    }
}

