/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.setup.dd;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class InstallDD {
    private static final String timestampPattern = "HH:mm:ss,S";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss,S");
    private File destDir;
    private String ddFilePath;

    public InstallDD(File destDir, String ddFilePath) {
        this.destDir = destDir;
        this.ddFilePath = ddFilePath;
    }

    public void unpack() throws FileNotFoundException, IOException {
        System.out.println(sdf.format(new Date()) + " INFO TASK:Unpacking");
        File ddFileDir = new File(this.ddFilePath);
        File[] ddFiles = ddFileDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".dd");
            }
        });
        if (ddFiles.length == 0) {
            System.out.println(sdf.format(new Date()) + " INFO No dd files found");
            return;
        }
        ZipInputStream ddFile = new ZipInputStream(new FileInputStream(ddFiles[0]));
        ZipEntry entry = null;
        long offset = 0L;
        String name = null;
        while ((entry = ddFile.getNextEntry()) != null) {
            name = entry.getName();
            if (!name.startsWith("craft")) continue;
            String destName = name.substring(6);
            File f = new File(this.destDir + "/" + destName);
            offset += entry.getCompressedSize();
            if (entry.isDirectory()) {
                if (f.exists()) continue;
                if (!f.mkdirs()) {
                    System.out.println(sdf.format(new Date()) + " ERROR Failed to create directory : " + f.getPath());
                    continue;
                }
                System.out.println(sdf.format(new Date()) + " INFO " + f.getPath());
                continue;
            }
            System.out.println(sdf.format(new Date()) + " INFO " + f.getPath());
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
            InstallDD.copyIO(ddFile, out, 1024, entry.getSize());
            out.close();
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println(sdf.format(new Date()) + " ERROR Wrong number of arguments");
            System.out.println("\nUsage : java com.bwanms.installer.light.InstallDD <destination> <dd_file>");
            System.out.println("\t<destination>: path where to unpack");
            System.out.println("\t<dd_file>: absolute path to the device driver file\n");
            System.out.println();
            return;
        }
        File destDir = new File(args[0]);
        if (!destDir.exists() && !destDir.mkdirs()) {
            System.out.println(sdf.format(new Date()) + " ERROR Could not create folder : " + destDir.getAbsolutePath());
        }
        InstallDD installDD = new InstallDD(destDir, args[1]);
        try {
            installDD.unpack();
        }
        catch (Exception e) {
            System.out.println(sdf.format(new Date()) + " ERROR " + e.getMessage());
            e.printStackTrace();
        }
        System.out.println(sdf.format(new Date()) + " INFO STATUS:finished");
    }

    private static void copyIO(InputStream source, OutputStream dest, int bufferSize, long maxBytes) throws IOException {
        byte[] buff = new byte[bufferSize];
        int read = 0;
        long countBytes = 0L;
        while ((read = source.read(buff)) > 0 && (countBytes += (long)read) <= maxBytes) {
            dest.write(buff, 0, read);
        }
    }
}

