/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.setup.dd;

import com.bwanms.setup.dd.CommandExecutor;
import com.bwanms.setup.migration.TrivialLogger;
import com.bwanms.util.IOUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class DDUtils {
    public static final void executeCmd(String cmd) throws IOException {
        CommandExecutor cmdExec = new CommandExecutor(cmd, System.out);
        cmdExec.exec();
    }

    public static final void executeSQL(String path, Connection con) throws SQLException, IOException {
        DDUtils.executeSQL(new File(path), con);
    }

    public static final void executeSQL(File source, Connection con) throws SQLException, IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(source)));
        DDUtils.executeSQL(in, con);
        in.close();
    }

    public static final void executeSQL(BufferedReader source, Connection con) throws IOException, SQLException {
        TrivialLogger log = TrivialLogger.getLogger();
        String line = null;
        Statement stmt = con.createStatement();
        String stmtStr = null;
        while ((line = source.readLine()) != null) {
            if (line.length() <= 0) continue;
            stmtStr = line.endsWith(";") ? line.substring(0, line.length() - 1) : line;
            stmt.addBatch(stmtStr);
            log.debug(stmtStr, new Object[0]);
        }
        stmt.executeBatch();
        stmt.clearBatch();
        stmt.close();
    }

    public static void executeSQL(String path, Connection con, boolean batch, boolean failOnError) throws IOException, SQLException, IllegalArgumentException {
        if (batch && !failOnError) {
            throw new IllegalArgumentException("Batch mode does not support failOnError=false");
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(path)));
        if (batch) {
            DDUtils.executeSQL(in, con);
        } else {
            String line = null;
            Statement stmt = con.createStatement();
            String stmtStr = null;
            while ((line = in.readLine()) != null) {
                if (line.length() <= 0 || (stmtStr = line.endsWith(";") ? line.substring(0, line.length() - 1) : line).equalsIgnoreCase("quit")) continue;
                try {
                    stmt.executeUpdate(stmtStr);
                }
                catch (SQLException ex) {
                    if (!failOnError) continue;
                    throw ex;
                }
            }
            stmt.close();
        }
        in.close();
    }

    public static void unzip(File zipFile, String destDir) throws IOException {
        TrivialLogger log = TrivialLogger.getLogger();
        long zipSize = zipFile.length();
        File destDirFile = new File(destDir);
        destDirFile.mkdirs();
        ZipInputStream in = new ZipInputStream(new FileInputStream(zipFile));
        ZipEntry entry = null;
        String name = null;
        long prog = 0L;
        long totalProg = 0L;
        while ((entry = in.getNextEntry()) != null) {
            name = entry.getName();
            totalProg += entry.getCompressedSize();
            File destFile = new File(destDirFile.getAbsolutePath() + "/" + name);
            if (entry.isDirectory()) {
                destFile.mkdirs();
                continue;
            }
            prog = Math.round((double)(totalProg * 100L) / (double)zipSize);
            log.info("PROG:" + prog, new Object[0]);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destFile));
            IOUtil.copyStream(in, out, (int)entry.getCompressedSize());
        }
        in.close();
    }
}

