/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.setup.dd;

import com.bwanms.setup.dd.DDAbstractInstallTool;
import com.bwanms.setup.dd.DDUtils;
import com.bwanms.util.IOUtil;
import java.io.File;
import java.sql.Connection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDServerInstallTool
extends DDAbstractInstallTool {
    private String dbType;
    private Connection con;
    protected String installerFiles;
    protected String ddCode;
    private File ddFile;

    public DDServerInstallTool(File ddFile, String ddCode, List<String> installedDD, String os, Connection con, String dbType) {
        super(ddCode, installedDD, os);
        this.ddCode = ddCode;
        this.ddFile = ddFile;
        this.con = con;
        this.dbType = dbType;
        this.installerFiles = this.infrInstallDir + "/inventory";
    }

    @Override
    protected void doInstall() {
        log.info("Installing " + this.ddCode, new Object[0]);
        try {
            if (this.ddFile.isFile()) {
                this.copyDD();
            }
            this.installDD();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), new Object[0]);
            System.exit(1);
        }
    }

    public void installDD() throws Exception {
        this.server();
        this.client();
        String clientZip = this.infrInstallDir + "/" + "owareapps" + "/" + this.ddCode + ".zip";
        log.info("Ocpinstall extract", new Object[0]);
        log.info("TASK:Ocpinstall extract", new Object[0]);
        this.runOcpinstallCmd("-x", clientZip);
        log.info("Ocpinstall extract finished", new Object[0]);
        log.info("Ocpinstall seeding", new Object[0]);
        log.info("TASK:Ocpinstall seed", new Object[0]);
        this.runOcpinstallCmd("-s", clientZip);
        log.info("Ocpinstall seeding finished", new Object[0]);
        this.schema();
        log.info("INSTALLATION FINISHED", new Object[0]);
    }

    @Override
    public void doUpgrade() {
        log.info("Upgrading " + this.ddCode, new Object[0]);
        try {
            this.backupDB();
            this.dropSchemaAll();
            this.deleteDD();
            this.copyDD();
            this.server();
            this.client();
            String clientZip = this.infrInstallDir + "/" + "owareapps" + "/" + this.ddCode + ".zip";
            log.info("Ocpinstall extract", new Object[0]);
            log.info("TASK:Ocpinstall extract", new Object[0]);
            this.runOcpinstallCmd("-x", clientZip);
            log.info("Ocpinstall extract finished", new Object[0]);
            log.info("Ocpinstall seeding", new Object[0]);
            log.info("TASK:ocpinstall seed", new Object[0]);
            this.runOcpinstallCmd("-s", clientZip);
            log.info("Ocpinstall seeding finished", new Object[0]);
            this.createSchemaAll();
            this.restoreDB();
            log.info("UPGRADE FINISHED", new Object[0]);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), new Object[0]);
            System.exit(1);
        }
    }

    private void backupDB() throws Exception {
        log.info("Backup database", new Object[0]);
        String cmdStr = null;
        String security = this.infrInstallDir + "/migration/temp/security.ocp";
        String backup = this.infrInstallDir + "/migration/temp/backup.zip";
        String licenseBak = this.infrInstallDir + "/migration/temp/License";
        String configBakPath = this.infrInstallDir + "/migration/temp/BackupFiles";
        cmdStr = this.os.equals("windows") ? this.infrInstallDir + "/oware.cmd " + this.infrInstallDir + "/migration/export.sh '" + security + "' '" + backup + "' '" + licenseBak + "' '" + configBakPath + "'" : this.infrInstallDir + "/migration/export.sh " + security + " " + backup + " " + licenseBak + " " + configBakPath;
        log.info(cmdStr, new Object[0]);
        DDUtils.executeCmd(cmdStr);
        log.info("Backup database done", new Object[0]);
    }

    private void dropSchemaAll() throws Exception {
        log.info("PROG:0", new Object[0]);
        log.info("TASK:Drop Schema", new Object[0]);
        log.info("Drop database schema", new Object[0]);
        String[] scripts = new String[]{"drop_table.sql"};
        int totalSteps = 1 + this.installedDD.size();
        int prog = 0;
        for (int i = 0; i < scripts.length; ++i) {
            log.info("Run sql script : ", new Object[]{scripts[i]});
            log.info(this.installerFiles + "/infrastructure/schema/" + this.dbType + "/" + scripts[i], new Object[0]);
            DDUtils.executeSQL(this.installerFiles + "/infrastructure/schema/" + this.dbType + "/" + scripts[i], this.con);
            prog = Math.round(100.0f / (float)totalSteps);
            log.info("PROG:" + prog, new Object[0]);
            int j = 2;
            for (String dd : this.installedDD) {
                log.info("Run sql script : ", new Object[0]);
                log.info(this.installerFiles + "/dd/" + dd + "/schema/" + this.dbType + "/" + scripts[i], new Object[0]);
                DDUtils.executeSQL(this.installerFiles + "/dd/" + dd + "/schema/" + this.dbType + "/" + scripts[i], this.con);
                prog = Math.round((float)(j * 100) / (float)totalSteps);
                log.info("PROG:" + prog, new Object[0]);
            }
        }
        log.info("Database schema dropped", new Object[0]);
    }

    private void createSchemaAll() throws Exception {
        log.info("PROG:0", new Object[0]);
        log.info("TASK:Create schema", new Object[0]);
        log.info("Create database schema", new Object[0]);
        String[] scripts = new String[]{"create_table.sql", "create_idx.sql"};
        int totalSteps = 2 * (1 + this.installedDD.size());
        int prog = 0;
        for (int i = 0; i < scripts.length; ++i) {
            log.info("Run sql script : ", new Object[0]);
            log.info(this.installerFiles + "/infrastructure/schema/" + this.dbType + "/" + scripts[i], new Object[0]);
            DDUtils.executeSQL(this.installerFiles + "/infrastructure/schema/" + this.dbType + "/" + scripts[i], this.con, false, false);
            prog = Math.round((float)(i + 1) * 100.0f / (float)totalSteps);
            log.info("PROG:" + prog, new Object[0]);
            int j = 2;
            for (String dd : this.installedDD) {
                log.info("Run sql script : ", new Object[0]);
                log.info(this.installerFiles + "/dd/" + dd + "/schema/" + this.dbType + "/" + scripts[i], new Object[0]);
                if (scripts[i].equals("create_idx.sql")) {
                    DDUtils.executeSQL(this.installerFiles + "/dd/" + dd + "/schema/" + this.dbType + "/" + scripts[i], this.con, false, false);
                } else {
                    DDUtils.executeSQL(this.installerFiles + "/dd/" + dd + "/schema/" + this.dbType + "/" + scripts[i], this.con);
                }
                prog = Math.round((float)((i + j) * 100) / (float)totalSteps);
                log.info("PROG:" + prog, new Object[0]);
            }
        }
        log.info("Database schema created", new Object[0]);
    }

    protected void deleteDD() throws Exception {
        log.info("PROG:0", new Object[0]);
        log.info("TASK:Delete " + this.ddCode, new Object[0]);
        log.info("Delete existing %s device driver files", new Object[]{this.ddCode});
        String instDDDir = this.installerFiles + "/dd/" + this.ddCode;
        IOUtil.deleteFiles(instDDDir + "/server/bwanms.sar/lib", this.infrInstallDir + "/" + "oware/jboss-3.2.3/server/oware/deploy" + "/bwanms.sar/lib/", false, new String[0]);
        log.info("PROG:33.3", new Object[0]);
        IOUtil.deleteFiles(instDDDir + "/server/bwanms.sar/lib/dd", this.infrInstallDir + "/" + "oware/jboss-3.2.3/server/oware/deploy" + "/bwanms.sar/lib/dd", false, new String[0]);
        log.info("PROG:66.6", new Object[0]);
        IOUtil.deleteFiles(instDDDir + "/server/", this.infrInstallDir + "/" + "oware/jboss-3.2.3/server/oware/deploy", true, new String[]{"bwanms.sar"});
        IOUtil.deleteDir(new File(this.infrInstallDir + "/" + "owareapps" + "/" + this.ddCode));
        IOUtil.deleteDir(new File(instDDDir));
        log.info("PROG:100", new Object[0]);
        log.info("%s deleted", new Object[]{this.ddCode});
    }

    private void server() throws Exception {
        log.info("PROG:0", new Object[0]);
        log.info("TASK:Copy server files", new Object[0]);
        File source = new File(this.installerFiles + "/dd/" + this.ddCode + "/server");
        File dest = new File(this.infrInstallDir + "/" + "oware/jboss-3.2.3/server/oware/deploy");
        log.info("Copy server files:", new Object[0]);
        log.info("Source      : " + source.getPath(), new Object[0]);
        log.info("Destination : " + dest.getPath(), new Object[0]);
        IOUtil.copyDir(source, dest);
        log.info("PROG:100", new Object[0]);
        log.info("Server files copied", new Object[0]);
    }

    private void schema() throws Exception {
        log.info("PROG:0", new Object[0]);
        log.info("TASK:Create %s schema", new Object[]{this.ddCode});
        log.info("Create %s schema", new Object[]{this.ddCode});
        File schemaDir = new File(this.installerFiles + "/dd/" + this.ddCode + "/schema/" + this.dbType + "/");
        if (schemaDir.isDirectory()) {
            String[] scripts = new String[]{"create_table.sql", "create_idx.sql"};
            int i = 1;
            for (String script : scripts) {
                log.info("Run script : ", new Object[0]);
                log.info(schemaDir.getPath() + "/" + script, new Object[0]);
                log.info("PROG:" + i * 50, new Object[0]);
                if (this.dbType.equals("oracle") && script.equals("create_idx.sql")) {
                    DDUtils.executeSQL(schemaDir.getAbsolutePath() + "/" + script, this.con, false, false);
                } else {
                    DDUtils.executeSQL(schemaDir.getAbsolutePath() + "/" + script, this.con);
                }
                ++i;
            }
        } else {
            throw new Exception("Could not create schema. Path " + this.installerFiles + "/dd/" + this.ddCode + "/schema/" + this.dbType + " not found");
        }
        log.info("Schema for %s created", new Object[]{this.ddCode});
    }

    private void restoreDB() throws Exception {
        log.info("Restore database", new Object[0]);
        String security = this.infrInstallDir + "/migration/temp/security.ocp";
        String backup = this.infrInstallDir + "/migration/temp/backup.zip";
        if (this.os.equals("windows")) {
            log.info(this.infrInstallDir + "/oware.cmd " + this.infrInstallDir + "/migration/import.sh -s '" + security + "'", new Object[0]);
            DDUtils.executeCmd(this.infrInstallDir + "/oware.cmd " + this.infrInstallDir + "/migration/import.sh -s '" + security + "'");
            log.info(this.infrInstallDir + "/oware.cmd " + this.infrInstallDir + "/migration/import.sh -c '" + backup + "'", new Object[0]);
            DDUtils.executeCmd(this.infrInstallDir + "/oware.cmd " + this.infrInstallDir + "/migration/import.sh -c '" + backup + "'");
        } else {
            log.info(this.infrInstallDir + "/migration/import.sh -s " + security, new Object[0]);
            DDUtils.executeCmd(this.infrInstallDir + "/migration/import.sh -s " + security);
            log.info(this.infrInstallDir + "/migration/import.sh -s " + security, new Object[0]);
            DDUtils.executeCmd(this.infrInstallDir + "/migration/import.sh -c " + backup);
        }
        log.info("Restore database ended", new Object[0]);
    }

    protected void client() throws Exception {
        log.info("PROG:0", new Object[0]);
        log.info("TASK:Copy " + this.ddCode + ".zip", new Object[0]);
        log.info("Copy " + this.ddCode + ".zip to " + this.infrInstallDir + "/owareapps", new Object[0]);
        File destDir = new File(this.infrInstallDir + "/" + "owareapps" + "/" + this.ddCode);
        destDir.mkdirs();
        log.info("PROG:33", new Object[0]);
        File zipFile = new File(this.installerFiles + "/dd/" + this.ddCode + "/client/" + this.ddCode + ".zip");
        log.info("Copy " + zipFile.getPath() + " to " + this.infrInstallDir + "/" + "owareapps", new Object[0]);
        IOUtil.copyFile(zipFile, new File(this.infrInstallDir + "/owareapps/" + zipFile.getName()));
        log.info("PROG:66", new Object[0]);
        File httpDir = new File(this.infrInstallDir + "/" + "oware/jboss-3.2.3/server/oware/deploy" + "/bwanms.war/dd");
        httpDir.mkdirs();
        log.info("Copy " + zipFile.getPath() + " to " + this.infrInstallDir + "/" + "oware/jboss-3.2.3/server/oware/deploy" + "/bwanms.war/dd", new Object[0]);
        IOUtil.copyFile(zipFile, new File(httpDir, zipFile.getName()));
        log.info("PROG:100", new Object[0]);
        log.info("PROG:0", new Object[0]);
        log.info("TASK:Unzip " + this.ddCode + ".zip", new Object[0]);
        log.info("Unzip " + zipFile.getPath() + " to " + destDir.getAbsolutePath(), new Object[0]);
        DDUtils.unzip(zipFile, destDir.getAbsolutePath());
        log.info("End copy client files", new Object[0]);
    }

    protected void copyDD() throws Exception {
        log.info("PROG:0", new Object[0]);
        log.info("TASK:Extract " + this.ddFile.getName(), new Object[0]);
        log.info("Extract " + this.ddFile.getPath() + " to " + this.installerFiles + "/dd/" + this.ddCode, new Object[0]);
        DDUtils.unzip(this.ddFile, this.installerFiles + "/dd/" + this.ddCode + "/");
        log.info("DD file extracted", new Object[0]);
    }
}

