/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.setup.dd;

import com.bwanms.setup.dd.DDServerInstallTool;
import com.bwanms.setup.migration.DatasourceParser;
import com.bwanms.setup.migration.Datasources;
import com.bwanms.setup.migration.TrivialLogger;
import com.bwanms.setup.os.SupportedOS;
import com.bwanms.util.IOUtil;
import com.bwanms.util.InstallInfoUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDCmdTool {
    private static final TrivialLogger log = TrivialLogger.getLogger();
    private static Properties ddProperties = new Properties();
    private static Properties hibernateProps = new Properties();

    public static void main(String[] args) {
        log.info("TASK:Preparing...", new Object[0]);
        if (args.length < 3) {
            System.out.println("usage : java DDCmdTool -i (-s ddFile)|(-c (ddFile1|d ddCode1) (ddFile2|d ddCode2)...)");
            System.exit(1);
        }
        String action = args[0];
        String installationType = args[1];
        String dd = args[2];
        try {
            String owareUserRoot = InstallInfoUtil.OWARE_USER_ROOT;
            if (owareUserRoot == null || owareUserRoot.length() == 0) {
                log.error("OWARE_USER_ROOT not defined", new Object[0]);
                return;
            }
            String os = DDCmdTool.getOS();
            log.info("OS type = " + os, new Object[0]);
            if (action.equals("-i")) {
                if (!installationType.equals("-c")) {
                    List<String> installedDD = null;
                    File paramDDFile = new File(dd);
                    if (!paramDDFile.isFile()) {
                        if (!paramDDFile.isDirectory()) {
                            log.error("Installation location not found: " + dd, new Object[0]);
                            System.exit(1);
                        } else {
                            File ddPropsFile = new File(paramDDFile.getCanonicalPath() + "/dd.properties");
                            if (!ddPropsFile.isFile()) {
                                log.error("dd.properties file not found in: " + dd, new Object[0]);
                                System.exit(1);
                            } else {
                                ddProperties = new Properties();
                                ddProperties.load(new FileInputStream(ddPropsFile));
                            }
                        }
                    } else {
                        ddProperties = DDCmdTool.loadDDProperties(paramDDFile);
                        log.info("Scanning installed device drivers...", new Object[0]);
                        installedDD = DDCmdTool.getInstalledDD();
                        log.info("Found following device drivers : " + installedDD, new Object[0]);
                    }
                    String ddCode = ddProperties.getProperty("DD");
                    if (ddCode == null) {
                        log.error("Property DD not found in dd.properties", new Object[0]);
                        System.exit(1);
                    }
                    hibernateProps = DDCmdTool.getHibernateProps();
                    Connection con = DDCmdTool.getDBConnection(hibernateProps);
                    String dbType = DDCmdTool.getDBType(hibernateProps);
                    log.info("Database type = " + dbType, new Object[0]);
                    DDServerInstallTool tool = null;
                    tool = new DDServerInstallTool(paramDDFile, ddCode, installedDD, os, con, dbType);
                    if (tool == null) {
                        throw new AssertionError((Object)"Could not instantiate InstallTool");
                    }
                    tool.doInstallOrUpgrade();
                }
            } else {
                System.out.println("usage : java DDCmdTool -i (-s ddFile)|(-c (ddFile1|d ddCode1) (ddFile2|d ddCode2)...)");
                System.exit(1);
            }
        }
        catch (ValidationException ex) {
            log.error(ex.getMessage(), new Object[0]);
            System.exit(1);
        }
        catch (Throwable t) {
            log.error(t.getMessage(), new Object[0]);
            System.exit(1);
        }
    }

    private static List<String> getInstalledDD() {
        File[] ct;
        ArrayList<String> ret = new ArrayList<String>();
        File ddDir = new File(InstallInfoUtil.OWARE_USER_ROOT + "/inventory/dd");
        log.info("DD location : " + ddDir.getPath(), new Object[0]);
        if (ddDir.isDirectory()) {
            // empty if block
        }
        block0: for (File f : ct = ddDir.listFiles()) {
            String[] ddCt = f.list();
            if (ddCt == null || ddCt.length <= 0) continue;
            for (String ddCtFile : ddCt) {
                if (!ddCtFile.endsWith("dd.properties")) continue;
                ret.add(f.getName());
                continue block0;
            }
        }
        return ret;
    }

    private static Properties loadDDProperties(File ddFile) throws ValidationException {
        log.info("Scan archive content for dd.properties", new Object[0]);
        ZipInputStream zip = null;
        ByteArrayInputStream in = null;
        try {
            zip = new ZipInputStream(new FileInputStream(ddFile));
            ZipEntry entry = null;
            String name = null;
            while ((entry = zip.getNextEntry()) != null) {
                name = entry.getName();
                if (!name.equals("dd.properties")) continue;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                IOUtil.copyStream(zip, out);
                in = new ByteArrayInputStream(out.toByteArray());
                break;
            }
            if (in == null) {
                throw new ValidationException("File dd.properties not found in DD file");
            }
            Properties ddProps = new Properties();
            ddProps.load(in);
            Properties properties = ddProps;
            return properties;
        }
        catch (IOException ex) {
            throw new ValidationException(ex.getMessage(), ex);
        }
        finally {
            try {
                if (zip != null) {
                    zip.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException rex) {
                rex.printStackTrace();
            }
        }
    }

    private static Properties getHibernateProps() throws ValidationException {
        try {
            log.info("Load hibernate.properties file", new Object[0]);
            Properties props = new Properties();
            Properties temp = new Properties();
            temp.load(new FileInputStream(InstallInfoUtil.OWARE_USER_ROOT + "/" + "oware/jboss-3.2.3/server/oware/deploy" + "/bwanms.sar/hibernate.properties"));
            props.setProperty("hibernate.dialect", temp.getProperty("hibernate.dialect"));
            DatasourceParser parser = new DatasourceParser((InputStream)new FileInputStream(InstallInfoUtil.OWARE_USER_ROOT + "/" + "oware/jboss-3.2.3/server/oware/deploy" + "/alvaristar-ds.xml"));
            Datasources result = parser.parseDatasource();
            props.setProperty("hibernate.connection.driver_class", result.getDriverClass());
            props.setProperty("hibernate.connection.url", result.getConnectionUrl());
            props.setProperty("hibernate.connection.username", result.getUserName());
            props.setProperty("hibernate.connection.password", result.getPassword());
            props.setProperty("hibernate.c3p0.min_size", result.getMinPoolSize());
            props.setProperty("hibernate.c3p0.max_size", result.getMaxPoolSize());
            props.setProperty("hibernate.c3p0.timeout", result.getIdleTimeoutMinutes());
            log.info("Hibernate properties loaded", new Object[0]);
            return props;
        }
        catch (IOException ex) {
            throw new ValidationException(ex.getMessage(), ex);
        }
    }

    private static Connection getDBConnection(Properties conProps) throws ValidationException {
        try {
            log.info("Aquire a connection to the database", new Object[0]);
            String driver = conProps.getProperty("hibernate.connection.driver_class");
            String url = conProps.getProperty("hibernate.connection.url");
            String userName = conProps.getProperty("hibernate.connection.username");
            String passwd = conProps.getProperty("hibernate.connection.password");
            log.info("Making a test connection using hibernate.properties", new Object[0]);
            Class.forName(driver);
            Connection con = DriverManager.getConnection(url, userName, passwd);
            log.info("Connection to database succesfull", new Object[0]);
            return con;
        }
        catch (Exception ex) {
            throw new ValidationException(ex.getMessage(), ex);
        }
    }

    private static String getDBType(Properties conProps) throws ValidationException {
        String url = hibernateProps.getProperty("hibernate.connection.url");
        if (url == null) {
            throw new AssertionError((Object)"This validation should have been done already");
        }
        if (url.toLowerCase().indexOf("oracle") != -1) {
            return "oracle";
        }
        if (url.toLowerCase().indexOf("mysql") != -1) {
            return "mysql";
        }
        throw new ValidationException("Unsupported database type");
    }

    private static String getOS() throws ValidationException {
        String term = System.getenv("TERM");
        if (term == null) {
            String osName = SupportedOS.getSupportedOS(System.getProperty("os.name"));
            if (osName == null) {
                throw new ValidationException("Could not determine OS type");
            }
            return osName;
        }
        if (term.toLowerCase().equals("cygwin")) {
            return SupportedOS.windows.getSupportedOSName();
        }
        return SupportedOS.solaris.getSupportedOSName();
    }

    public static class ValidationException
    extends Exception {
        public ValidationException() {
        }

        public ValidationException(String s, Throwable throwable) {
            super(s, throwable);
        }

        public ValidationException(String s) {
            super(s);
        }

        public ValidationException(Throwable throwable) {
            super(throwable);
        }
    }
}

