/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.setup.dd;

import com.bwanms.setup.dd.DDInstallToolIf;
import com.bwanms.setup.dd.DDUtils;
import com.bwanms.setup.migration.TrivialLogger;
import com.bwanms.util.InstallInfoUtil;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DDAbstractInstallTool
implements DDInstallToolIf {
    public static final String JBOSS_DEPLOYMENT_FOLDER = "oware/jboss-3.2.3/server/oware/deploy";
    protected static final String OWAREAPPS_FOLDER = "owareapps";
    protected static TrivialLogger log = TrivialLogger.getLogger();
    protected List<String> installedDD = new ArrayList<String>();
    protected String ddCode;
    protected String infrInstallDir = InstallInfoUtil.OWARE_USER_ROOT;
    protected String os;

    public DDAbstractInstallTool(String ddCode, List<String> installedDD, String os) {
        this.ddCode = ddCode;
        this.installedDD = installedDD;
        this.os = os;
    }

    @Override
    public void doInstallOrUpgrade() {
        if (this.isDDInstalled()) {
            this.doUpgrade();
        } else {
            this.doInstall();
        }
    }

    protected abstract void doInstall();

    public boolean isDDInstalled() {
        if (this.installedDD == null) {
            return false;
        }
        for (String dd : this.installedDD) {
            if (!dd.equals(this.ddCode)) continue;
            return true;
        }
        return false;
    }

    protected void runOcpinstallCmd(String cmdSwitch, String clientZip) throws Exception {
        log.info("PROG:0", new Object[0]);
        String cmd = null;
        cmd = this.os.equals("windows") ? this.infrInstallDir + "/oware.cmd ocpinstall " + cmdSwitch + " " + clientZip : this.infrInstallDir + "/install/root/launcher.sh ocpinstall " + cmdSwitch + " " + clientZip;
        log.info(cmd, new Object[0]);
        DDUtils.executeCmd(cmd);
        log.info("PROG:100", new Object[0]);
    }
}

