/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.setup.dd;

import com.bwanms.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CommandExecutor {
    private String cmd;
    private OutputStream out;

    public CommandExecutor(String cmd, OutputStream out) {
        this.cmd = cmd;
        this.out = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void exec() throws IOException {
        Runtime rt = Runtime.getRuntime();
        Process p = rt.exec(this.cmd);
        InputStream in = p.getInputStream();
        OutputCatcher catcher = new OutputCatcher(in, this.out);
        catcher.start();
        try {
            p.waitFor();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        OutputCatcher outputCatcher = catcher;
        synchronized (outputCatcher) {
            try {
                while (!catcher.isDone()) {
                    catcher.wait();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    class OutputCatcher
    extends Thread {
        private InputStream in;
        private final Lock lock = new ReentrantLock();
        private final Condition finished = this.lock.newCondition();
        private boolean done = false;

        public OutputCatcher(InputStream in, OutputStream out) {
            this.in = in;
        }

        public void run() {
            this.done = false;
            try {
                IOUtil.copyStream(this.in, CommandExecutor.this.out);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.done = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void await() {
            this.lock.lock();
            try {
                this.finished.await();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            finally {
                this.lock.unlock();
            }
        }

        public boolean isDone() {
            return this.done;
        }
    }
}

