/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.setup.clientupdater;

import com.bwanms.setup.clientupdater.ClientUpdaterWizardFrame;
import com.bwanms.setup.clientupdater.ClientUpdaterWizardPage;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public abstract class ClientUpdaterWizard {
    private ClientUpdaterWizardFrame wizzardFrame = new ClientUpdaterWizardFrame();
    private List<ClientUpdaterWizardPage> pageList = new ArrayList<ClientUpdaterWizardPage>();
    private int currentPage = 0;

    public ClientUpdaterWizard() {
        this.init();
    }

    private void init() {
        this.wizzardFrame.setDefaultCloseOperation(0);
        this.wizzardFrame.getButtonNext().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientUpdaterWizard.this.btnNextActionPerformed(e);
            }
        });
        this.wizzardFrame.getButtonCancel().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientUpdaterWizard.this.btnCancelActionPerformed(e);
            }
        });
    }

    protected abstract void initPages() throws Exception;

    protected abstract String getTitle();

    protected abstract String getBtnNext();

    protected abstract String getBtnCancel();

    protected abstract String getBtnFinish();

    public void start() {
        try {
            this.initPages();
        }
        catch (Exception e) {
            System.out.println(e);
            return;
        }
        this.wizzardFrame.getButtonCancel().setText(this.getBtnCancel());
        this.wizzardFrame.getButtonNext().setText(this.getBtnNext());
        this.wizzardFrame.setTitle(this.getTitle());
        this.setPageAndRun(0);
        this.wizzardFrame.pack();
        this.wizzardFrame.setResizable(false);
        int maxWidth = (int)this.wizzardFrame.getGraphicsConfiguration().getBounds().getWidth();
        int maxHeight = (int)this.wizzardFrame.getGraphicsConfiguration().getBounds().getHeight();
        int width = this.wizzardFrame.getWidth();
        int height = this.wizzardFrame.getHeight();
        this.wizzardFrame.setLocation((maxWidth - width) / 2, (maxHeight - height) / 2);
        this.wizzardFrame.setVisible(true);
    }

    private void btnNextActionPerformed(ActionEvent e) {
        if (this.isLastPage()) {
            this.wizzardFrame.dispose();
        } else {
            JPanel panelCard = this.wizzardFrame.getPanelCard();
            ((CardLayout)panelCard.getLayout()).next(panelCard);
            this.setPageAndRun(++this.currentPage);
        }
    }

    private void setPageAndRun(int pageNumber) {
        final ClientUpdaterWizardPage page = this.pageList.get(pageNumber);
        this.wizzardFrame.getLabelTitle().setText(page.getTitle());
        if (this.isLastPage()) {
            this.wizzardFrame.getButtonNext().setText(this.getBtnFinish());
        }
        this.wizzardFrame.getButtonCancel().setVisible(this.pageList.get(this.currentPage).enableCancel());
        this.wizzardFrame.getButtonNext().setEnabled(false);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    page.run();
                }
                catch (Exception exception) {
                }
                finally {
                    ClientUpdaterWizard.this.wizzardFrame.getButtonNext().setEnabled(true);
                }
            }
        }.start();
    }

    private void btnCancelActionPerformed(ActionEvent e) {
        this.stop();
    }

    private boolean isLastPage() {
        return this.currentPage == this.pageList.size() - 1;
    }

    public void addPage(ClientUpdaterWizardPage page) {
        this.pageList.add(page);
        this.wizzardFrame.getPanelCard().add((Component)page.getUI(), page.getTitle());
    }

    private void stop() {
        this.wizzardFrame.dispose();
    }
}

