/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.setup.clientupdater;

import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;

public class ClientUpdaterDDDownload
implements Runnable {
    private static final int MAX_BUFFER_SIZE = 1024;
    private static final int RESUME_CHECK_SIZE = 1024;
    private static final String EXTENSION = ".dldd";
    public static final int COMPLETE = 0;
    public static final int DOWNLOADING = 1;
    public static final int ERROR = 2;
    private File to;
    private File toTmp;
    private URL url;
    private long size;
    private long downloaded;
    private byte status;
    private boolean overwrite;
    private boolean retry = false;
    private byte retries = (byte)2;
    private byte timeout = (byte)2;

    public ClientUpdaterDDDownload(File to, URL url) throws Exception {
        this(to, url, false);
    }

    public ClientUpdaterDDDownload(File to, URL url, boolean overwrite) throws Exception {
        this.to = to;
        this.toTmp = new File(to.getCanonicalPath() + EXTENSION);
        this.url = url;
        this.overwrite = overwrite;
    }

    private void configure() throws Exception {
        this.downloaded = 0L;
        this.size = -1L;
        if (this.to.isFile()) {
            if (!this.overwrite) {
                throw new Exception("Destination exists");
            }
            this.delDestination();
        }
    }

    private void delDestination() throws Exception {
        if (!this.to.delete()) {
            throw new Exception("Can't delete existing destination");
        }
    }

    private void moveCompleted() throws Exception {
        if (this.to.isFile()) {
            this.delDestination();
        }
        this.toTmp.renameTo(this.to);
    }

    public void start() {
        this.status = 1;
        Thread thread = new Thread(this);
        thread.start();
    }

    public String getUrl() {
        return this.url.toString();
    }

    public long getSize() {
        return this.size;
    }

    public float getProgress() {
        return (float)this.downloaded / (float)this.size * 100.0f;
    }

    public int getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download() {
        RandomAccessFile file = null;
        InputStream stream = null;
        this.retry = true;
        try {
            int read;
            byte[] buffer;
            file = new RandomAccessFile(this.toTmp, "rw");
            if (file.length() > 0L) {
                this.downloaded = file.length() / 1024L * 1024L - 1024L;
                if (this.downloaded < 0L) {
                    this.downloaded = 0L;
                }
            }
            HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
            connection.setRequestProperty("Range", "bytes=" + this.downloaded + "-");
            connection.connect();
            if (connection.getResponseCode() / 100 != 2) {
                throw new Exception("bad HTTP response");
            }
            int contentLength = connection.getContentLength();
            if (contentLength < 1) {
                throw new Exception("bad HTTP content length");
            }
            this.size = (long)contentLength + this.downloaded;
            file.setLength(this.size);
            file.seek(this.downloaded);
            stream = connection.getInputStream();
            if (this.downloaded > 0L) {
                buffer = new byte[1024];
                read = stream.read(buffer);
                if (read < 1) {
                    throw new Exception("bad HTTP read");
                }
                byte[] bufferFile = new byte[1024];
                int readFile = file.read(bufferFile);
                if (readFile == -1) {
                    this.retry = false;
                    throw new Exception("bad File read");
                }
                if (read != readFile || this.compare(buffer, bufferFile, 0, read) != 0) {
                    file.setLength(0L);
                    this.downloaded = 0L;
                    throw new Exception("downloaded File different from source HTTP file");
                }
                this.downloaded += (long)readFile;
            }
            while (this.downloaded < this.size) {
                buffer = this.size - this.downloaded > 1024L ? new byte[1024] : new byte[(int)(this.size - this.downloaded)];
                read = stream.read(buffer);
                if (read == -1) {
                    throw new Exception("bad HTTP read");
                }
                file.write(buffer, 0, read);
                this.downloaded += (long)read;
            }
            this.retry = false;
        }
        catch (Exception e) {
            if (!this.retry || this.retries <= 0) {
                this.status = (byte)2;
            }
            e.printStackTrace();
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (Exception e) {}
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {}
            }
        }
        try {
            if (this.status == 1 && !this.retry) {
                this.moveCompleted();
                this.status = 0;
            }
        }
        catch (Exception e) {
            this.status = (byte)2;
            e.printStackTrace();
        }
    }

    public void run() {
        try {
            this.configure();
            while (true) {
                this.download();
                if (this.status == 1 && this.retry) {
                    byte by = this.retries;
                    this.retries = (byte)(by - 1);
                    if (by > 0) {
                        try {
                            Thread.sleep(this.timeout * 1000);
                        }
                        catch (InterruptedException ie) {}
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            this.status = (byte)2;
        }
    }

    private int compare(byte[] b1, byte[] b2, int start, int end) {
        try {
            for (int i = start; i < end; ++i) {
                if (b1[i] == b2[i]) continue;
                return -1;
            }
        }
        catch (Exception e) {
            return -1;
        }
        return 0;
    }

    public byte getRetries() {
        return this.retries;
    }

    public void setRetries(byte retries) {
        this.retries = retries;
    }

    public byte getTimeout() {
        return this.timeout;
    }

    public void setTimeout(byte timeout) {
        this.timeout = timeout;
    }
}

