/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.setup.clientupdater;

import com.bwanms.setup.clientupdater.ClientUpdater;
import com.bwanms.setup.clientupdater.ClientUpdaterDDDownload;
import com.bwanms.util.IOUtil;
import com.bwanms.util.InstallInfoUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ClientUpdaterDD {
    private URL ddFileHTTP;
    private File ddFileLocal;
    private String ddCode;
    private String os;
    private ClientUpdater observer;

    public ClientUpdaterDD(String ddCode, String ddFileHTTP, String os, ClientUpdater observer) throws Exception {
        this.ddCode = ddCode;
        this.os = os;
        this.observer = observer;
        this.ddFileHTTP = new URL(ddFileHTTP);
        this.ddFileLocal = new File(InstallInfoUtil.PATH_OWAREAPPS + "/" + new File(this.ddFileHTTP.getFile()).getName());
    }

    public void install() throws Exception {
        File f = new File(InstallInfoUtil.PATH_OWAREAPPS + "/" + this.ddCode);
        try {
            this.downloadDD();
            if (f.isDirectory()) {
                this.deleteDD(f, this.ddCode);
            }
            this.installDD();
        }
        catch (Exception ex) {
            this.observer.error(ex.getMessage(), new Object[0]);
            if (f.isDirectory()) {
                this.deleteDD(f, this.ddCode);
            }
            throw ex;
        }
    }

    private void downloadDD() throws Exception {
        this.observer.progress(0.0f);
        this.observer.task("Downloading " + this.ddCode);
        this.observer.info("Downloading " + this.ddCode + " device driver files to " + this.ddFileLocal.getCanonicalPath(), new Object[0]);
        ClientUpdaterDDDownload dl = new ClientUpdaterDDDownload(this.ddFileLocal, this.ddFileHTTP, true);
        dl.start();
        while (dl.getStatus() == 1) {
            try {
                Thread.sleep(100L);
                this.observer.progress(dl.getProgress());
            }
            catch (InterruptedException ie) {
                throw new Exception("Download interrupted");
            }
        }
        if (dl.getStatus() == 2) {
            this.observer.info("Error downloading!", new Object[0]);
            throw new Exception("Download error");
        }
        this.observer.progress(100.0f);
        this.observer.info("Download successful!", new Object[0]);
    }

    private void installDD() throws Exception {
        this.observer.info("Installing " + this.ddCode, new Object[0]);
        this.extractDD();
        this.observer.info("Ocpinstall extract", new Object[0]);
        this.observer.task("Ocpinstall extract");
        this.runOcpinstallCmd("-x", this.ddFileLocal.getCanonicalPath());
        this.observer.info("Ocpinstall extract finished", new Object[0]);
        this.observer.info("Installation finished", new Object[0]);
    }

    public void delete() {
        this.deleteDD(new File(InstallInfoUtil.PATH_OWAREAPPS + "/" + this.ddCode), this.ddCode);
    }

    private void deleteDD(File f, String ddcode) {
        this.observer.progress(0.0f);
        this.observer.task("Delete " + ddcode);
        this.observer.info("Deleting existing " + ddcode + " device driver files", new Object[0]);
        if (f.isDirectory()) {
            try {
                IOUtil.deleteDir(f);
                if (f.isDirectory()) {
                    throw new Exception("can't delete");
                }
            }
            catch (Exception e) {
                this.observer.progress(100.0f);
                this.observer.error("Error delete " + this.ddCode + " " + e, new Object[0]);
                return;
            }
        }
        this.observer.progress(100.0f);
        this.observer.info("Deleted " + this.ddCode, new Object[0]);
    }

    private void extractDD() throws Exception {
        this.observer.info("Extracting client files", new Object[0]);
        this.observer.progress(0.0f);
        this.observer.task("Create folder" + this.ddCode);
        File destDir = new File(InstallInfoUtil.PATH_OWAREAPPS + "/" + this.ddCode);
        destDir.mkdirs();
        this.observer.progress(100.0f);
        this.observer.progress(0.0f);
        this.observer.task("Unzip " + this.ddFileLocal.getName());
        this.observer.info("Unzip " + this.ddFileLocal.getCanonicalPath() + " to " + destDir.getCanonicalPath(), new Object[0]);
        this.unzip(this.ddFileLocal, destDir.getCanonicalPath());
        this.observer.progress(100.0f);
        this.observer.info("End extracting client files", new Object[0]);
    }

    private void unzip(File zipFile, String destDir) throws Exception {
        long zipSize = zipFile.length();
        File destDirFile = new File(destDir);
        destDirFile.mkdirs();
        FileInputStream fin = new FileInputStream(zipFile);
        ZipInputStream in = new ZipInputStream(fin);
        try {
            ZipEntry entry = null;
            String name = null;
            long prog = 0L;
            long totalProg = 0L;
            while ((entry = in.getNextEntry()) != null) {
                name = entry.getName();
                totalProg += entry.getCompressedSize();
                File destFile = new File(destDirFile.getAbsolutePath() + "/" + name);
                if (entry.isDirectory()) {
                    destFile.mkdirs();
                    continue;
                }
                prog = Math.round((double)(totalProg * 100L) / (double)zipSize);
                this.observer.progress(prog);
                FileOutputStream ffin = new FileOutputStream(destFile);
                BufferedOutputStream out = new BufferedOutputStream(ffin);
                IOUtil.copyStream(in, out, (int)entry.getCompressedSize());
                out.close();
                ffin.close();
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOcpinstallCmd(String cmdSwitch, String clientZip) throws Exception {
        this.observer.progress(0.0f);
        String cmd = null;
        cmd = this.os.equals("windows") ? InstallInfoUtil.OWARE_USER_ROOT + "/oware.cmd ocpinstall " + cmdSwitch + " \"" + clientZip + "\"" : InstallInfoUtil.OWARE_USER_ROOT + "/install/root/launcher.sh ocpinstall " + " \"" + clientZip + "\"";
        this.observer.info(cmd, new Object[0]);
        Runtime rt = Runtime.getRuntime();
        try {
            Process p = rt.exec(cmd);
            OutputParser output = new OutputParser(p.getInputStream());
            output.start();
            try {
                p.waitFor();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            OutputParser ex = output;
            synchronized (ex) {
                try {
                    while (!output.isDone()) {
                        output.wait();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            int ev = p.exitValue();
            if (ev != 0) {
                throw new Exception("exit code " + ev);
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        this.observer.progress(100.0f);
    }

    class OutputParser
    extends Thread {
        private final Lock lock = new ReentrantLock();
        private final Condition finished = this.lock.newCondition();
        private InputStream in;
        private boolean done;

        public OutputParser(InputStream in) {
            this.in = in;
            this.done = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void await() {
            this.lock.lock();
            try {
                this.finished.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.in));
            String buf = null;
            try {
                while ((buf = reader.readLine()) != null) {
                    ClientUpdaterDD.this.observer.info(buf, new Object[0]);
                }
                reader.close();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            finally {
                this.done = true;
                OutputParser outputParser = this;
                synchronized (outputParser) {
                    this.notifyAll();
                }
            }
        }

        public boolean isDone() {
            return this.done;
        }
    }
}

