/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.setup.clientupdater;

import com.bwanms.plugin.IPluginDefinition;
import com.bwanms.setup.clientupdater.ClientUpdaterDD;
import com.bwanms.setup.clientupdater.ClientUpdaterWizard;
import com.bwanms.setup.clientupdater.ClientUpdaterWizardActionPage;
import com.bwanms.setup.clientupdater.ClientUpdaterWizardPage;
import com.bwanms.setup.dd.DDCmdTool;
import com.bwanms.setup.os.SupportedOS;
import com.bwanms.util.InstallInfoUtil;
import com.bwanms.util.Settings;
import com.bwanms.util.version.impl.DefaultVersion;
import java.awt.Container;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.html.HTMLEditorKit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientUpdater
extends ClientUpdaterWizard {
    public static final String HTTP_SERVER_ROOT = "http://%s:%s/bwanms";
    public static final String HTTP_DD_FILE = "http://%s:%s/bwanms/dd/%s.zip";
    public static final String FILE_INIT_DIR = InstallInfoUtil.OWARE_USER_ROOT + "/temp";
    public static final String FILE_INIT = FILE_INIT_DIR + "/clientupdater.dat";
    public static final String FILE_PROPS = InstallInfoUtil.OWARE_USER_ROOT + "/inventory/installation_summary.properties";
    public static final String FILE_OWAPPSERVER_PROPS = InstallInfoUtil.OWARE_USER_ROOT + "/oware/lib/owappserver.properties";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private ClientUpdaterWizardActionPage action;
    private ReportPage finishPage;
    private List<String[]> ddList;
    private StringBuffer finished;
    private String osName;
    private StringBuffer summary;
    private List oldInfoList;
    private List serverList;
    private String propsFile;
    private String ip;
    private String port;
    private Properties internalProps;
    private static final String LINE_BREAK = "<br>";

    public ClientUpdater(String propsFile) {
        this.propsFile = propsFile;
        this.action = new ClientUpdaterWizardActionPage();
    }

    @Override
    protected void initPages() throws Exception {
        this.configure();
        ReportPage report = new ReportPage(this.internalProps.getProperty(ClientUpdaterProps.P_PRESUMMARY_TITLE.getPropertyName()));
        report.setReport(String.format(this.internalProps.getProperty(ClientUpdaterInputProps.P_PRESUMMARY.getPropertyName()), this.summary));
        this.addPage(report);
        this.addPage(new ActionPage(this.internalProps.getProperty(ClientUpdaterProps.P_ACTION_TITLE.getPropertyName()), this.action));
        this.finishPage = new ReportPage(this.internalProps.getProperty(ClientUpdaterProps.P_POSTSUMMARY_TITLE.getPropertyName())){

            public boolean enableCancel() {
                return false;
            }
        };
        this.addPage(this.finishPage);
    }

    @Override
    protected String getTitle() {
        return this.internalProps.getProperty(ClientUpdaterProps.P_TITLE.getPropertyName());
    }

    @Override
    protected String getBtnNext() {
        return this.internalProps.getProperty(ClientUpdaterProps.P_BTN_NEXT.getPropertyName());
    }

    @Override
    protected String getBtnCancel() {
        return this.internalProps.getProperty(ClientUpdaterProps.P_BTN_CANCEL.getPropertyName());
    }

    @Override
    protected String getBtnFinish() {
        return this.internalProps.getProperty(ClientUpdaterProps.P_BTN_FINISH.getPropertyName());
    }

    private String getProperty(Properties props, String key) throws Exception {
        String s = props.getProperty(key);
        if (s == null) {
            throw new Exception("cant read needed property " + key);
        }
        return s;
    }

    private void configure() throws Exception {
        this.internalProps = new Properties();
        InputStream is = this.getClass().getResource("Resources.properties").openStream();
        this.internalProps.load(is);
        is.close();
        Properties props = new Properties();
        is = new FileInputStream(FILE_PROPS);
        props.load(is);
        is.close();
        this.ip = this.getProperty(props, ClientUpdaterInputProps.P_IP.getPropertyName());
        this.port = this.getProperty(props, ClientUpdaterInputProps.P_PORT.getPropertyName());
        is = new FileInputStream(FILE_OWAPPSERVER_PROPS);
        props.load(is);
        is.close();
        try {
            String serverUrl = this.getProperty(props, ClientUpdaterInputProps.P_OWAPPSERVER_URL.getPropertyName());
            this.ip = serverUrl.replaceAll("jnp://", "").replaceAll(":3100", "");
        }
        catch (Exception e) {
            // empty catch block
        }
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.propsFile));
        this.serverList = (List)ois.readObject();
        this.oldInfoList = (List)ois.readObject();
        ois.close();
        this.summary = new StringBuffer();
        this.ddList = new ArrayList<String[]>();
        this.checkBefore(this.oldInfoList, this.serverList, this.ddList, this.summary);
        if (this.ddList.size() <= 0) {
            throw new Exception("nothing to update");
        }
        this.osName = SupportedOS.getSupportedOS(System.getProperty("os.name"));
        if (this.osName == null) {
            throw new DDCmdTool.ValidationException("Could not determine OS type");
        }
        this.finished = new StringBuffer();
    }

    private void checkBefore(List oldList, List newList, List<String[]> dds, StringBuffer report) throws Exception {
        String rep;
        IPluginDefinition newInfo;
        IPluginDefinition oldInfo;
        Comparator<IPluginDefinition> cmp = InstallInfoUtil.getComparator();
        int si = 0;
        int ci = 0;
        report.setLength(0);
        dds.clear();
        block4: while (si < oldList.size() && ci < newList.size()) {
            oldInfo = (IPluginDefinition)oldList.get(si);
            newInfo = (IPluginDefinition)newList.get(ci);
            switch (cmp.compare(oldInfo, newInfo)) {
                case 0: {
                    ++si;
                    ++ci;
                    DefaultVersion oldVersion = new DefaultVersion(oldInfo.getVersion());
                    DefaultVersion newVersion = new DefaultVersion(newInfo.getVersion());
                    if (oldVersion.isEqualWith(newVersion)) {
                        rep = String.format(this.internalProps.getProperty(ClientUpdaterProps.PROPERTY_INSTALLATION_FINISHED_DD_UNCHANGED.getPropertyName()), oldInfo.getNameTranslated(), oldInfo.getVersion());
                        report.append(rep).append(LINE_BREAK);
                        dds.add(new String[]{oldInfo.getModule(), "", rep});
                        continue block4;
                    }
                    if (oldVersion.isNewerThan(newVersion)) {
                        rep = String.format(this.internalProps.getProperty(ClientUpdaterProps.PROPERTY_INSTALLATION_FINISHED_DD_DOWNGRADED.getPropertyName()), oldInfo.getNameTranslated(), oldInfo.getVersion(), newInfo.getVersion());
                        report.append(rep).append(LINE_BREAK);
                        dds.add(new String[]{newInfo.getModule(), "d", rep});
                        continue block4;
                    }
                    rep = String.format(this.internalProps.getProperty(ClientUpdaterProps.PROPERTY_INSTALLATION_FINISHED_DD_UPGRADED.getPropertyName()), oldInfo.getNameTranslated(), oldInfo.getVersion(), newInfo.getVersion());
                    report.append(rep).append(LINE_BREAK);
                    dds.add(new String[]{newInfo.getModule(), "u", rep});
                    continue block4;
                }
                case 1: {
                    ++ci;
                    rep = String.format(this.internalProps.getProperty(ClientUpdaterProps.PROPERTY_INSTALLATION_FINISHED_DD_NEW.getPropertyName()), newInfo.getNameTranslated(), newInfo.getVersion());
                    report.append(rep).append(LINE_BREAK);
                    dds.add(new String[]{newInfo.getModule(), "n", rep});
                    continue block4;
                }
            }
            ++si;
            rep = String.format(this.internalProps.getProperty(ClientUpdaterProps.PROPERTY_INSTALLATION_FINISHED_DD_DELETED.getPropertyName()), oldInfo.getNameTranslated(), oldInfo.getVersion());
            report.append(rep).append(LINE_BREAK);
            dds.add(new String[]{oldInfo.getModule(), "r", rep});
        }
        if (si < oldList.size()) {
            oldInfo = (IPluginDefinition)oldList.get(si++);
            rep = String.format(this.internalProps.getProperty(ClientUpdaterProps.PROPERTY_INSTALLATION_FINISHED_DD_DELETED.getPropertyName()), oldInfo.getNameTranslated(), oldInfo.getVersion());
            report.append(rep).append(LINE_BREAK);
            dds.add(new String[]{oldInfo.getModule(), "r", rep});
        }
        while (ci < newList.size()) {
            newInfo = (IPluginDefinition)newList.get(ci++);
            rep = String.format(this.internalProps.getProperty(ClientUpdaterProps.PROPERTY_INSTALLATION_FINISHED_DD_NEW.getPropertyName()), newInfo.getNameTranslated(), newInfo.getVersion());
            report.append(rep).append(LINE_BREAK);
            dds.add(new String[]{newInfo.getModule(), "n", rep});
        }
    }

    public void info(String info, Object ... args) {
        this.action.getTxtOutput().append(this.format("INFO", info, args));
        this.action.getTxtOutput().setCaretPosition(this.action.getTxtOutput().getText().length());
    }

    public void error(String error, Object ... args) {
        this.action.getTxtOutput().append(this.format("ERROR", error, args));
        this.action.getTxtOutput().setCaretPosition(this.action.getTxtOutput().getText().length());
    }

    private String format(String level, String message, Object ... args) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(dateFormat.format(new Date())).append(' ').append(level).append(' ');
        if (args != null && args.length > 0) {
            buffer.append(String.format(message, args));
        } else {
            buffer.append(message);
        }
        buffer.append("\r\n");
        return buffer.toString();
    }

    public void progress(float prg) {
        this.action.getProgressBar().setValue(Math.round(prg));
    }

    public void task(String task) {
        this.action.getLblTxtStatus().setText(task);
    }

    private void update() {
        this.info("UPDATE STARTED", new Object[0]);
        this.info("", new Object[0]);
        boolean error = false;
        for (int i = 0; i < this.ddList.size(); ++i) {
            this.finished.append(this.ddList.get(i)[2]);
            try {
                if (this.ddList.get(i)[1].equals("r")) {
                    new ClientUpdaterDD(this.ddList.get(i)[0], "http://", this.osName, this).delete();
                } else if (!this.ddList.get(i)[1].equals("")) {
                    String url = String.format(HTTP_DD_FILE, this.ip, this.port, this.ddList.get(i)[0]);
                    new ClientUpdaterDD(this.ddList.get(i)[0], url, this.osName, this).install();
                }
                this.finished.append(this.internalProps.getProperty(ClientUpdaterProps.PROPERTY_INSTALLATION_DD_OK.getPropertyName()));
            }
            catch (Exception e) {
                error = true;
                this.finished.append(this.internalProps.getProperty(ClientUpdaterProps.PROPERTY_INSTALLATION_DD_ERROR.getPropertyName()));
            }
            this.finished.append(LINE_BREAK);
        }
        this.progress(100.0f);
        this.task("Update finished");
        this.info("", new Object[0]);
        this.info("UPDATE FINISHED", new Object[0]);
        if (error) {
            this.finished.insert(0, this.internalProps.getProperty(ClientUpdaterProps.PROPERTY_INSTALLATION_FINISHED_ERROR.getPropertyName()));
        } else {
            this.finished.insert(0, this.internalProps.getProperty(ClientUpdaterProps.PROPERTY_INSTALLATION_FINISHED_OK.getPropertyName()));
        }
        this.finishPage.setReport(this.finished.toString());
    }

    public static void main(String[] args) {
        try {
            Settings.setLookAndFeel();
        }
        catch (Exception e) {
            // empty catch block
        }
        ClientUpdater wizard = args.length < 1 ? new ClientUpdater(FILE_INIT) : new ClientUpdater(args[0]);
        wizard.start();
    }

    private class ActionPage
    implements ClientUpdaterWizardPage {
        JPanel panel;
        String title;

        public ActionPage(String title, JPanel panel) {
            this.title = title;
            this.panel = panel;
        }

        public Container getUI() {
            return this.panel;
        }

        public String getTitle() {
            return this.title;
        }

        public void run() {
            ClientUpdater.this.update();
        }

        public boolean enableCancel() {
            return false;
        }
    }

    private class ReportPage
    implements ClientUpdaterWizardPage {
        JScrollPane scrollPane1;
        JEditorPane report;
        String title;

        public ReportPage(String title) {
            this.title = title;
            this.scrollPane1 = new JScrollPane();
            this.scrollPane1.setHorizontalScrollBarPolicy(31);
            this.report = new JEditorPane();
            this.report.setEditorKit(new HTMLEditorKit());
            this.report.setEditable(false);
            this.scrollPane1.setViewportView(this.report);
        }

        public Container getUI() {
            return this.scrollPane1;
        }

        public String getTitle() {
            return this.title;
        }

        public void run() {
        }

        public boolean enableCancel() {
            return true;
        }

        public void setReport(String report) {
            this.report.setText(report);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClientUpdaterInputProps {
        PROPERTY_COMMAND_LINE("clientupdater.command.line"),
        P_PRESUMMARY("clientupdater.presummary"),
        P_IP("server.address"),
        P_PORT("server.http.port"),
        P_OWAPPSERVER_URL("OWARE.CONTEXT.SERVER.URL");

        String property;

        private ClientUpdaterInputProps(String p) {
            this.property = p;
        }

        public String getPropertyName() {
            return this.property;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClientUpdaterProps {
        PROPERTY_INSTALLATION_FINISHED_OK("clientupdater.installation.finished.ok"),
        PROPERTY_INSTALLATION_FINISHED_ERROR("clientupdater.installation.finished.error"),
        PROPERTY_INSTALLATION_FINISHED_DD_UNCHANGED("clientupdater.installation.finished.dd.unchanged"),
        PROPERTY_INSTALLATION_FINISHED_DD_UPGRADED("clientupdater.installation.finished.dd.upgraded"),
        PROPERTY_INSTALLATION_FINISHED_DD_DELETED("clientupdater.installation.finished.dd.deleted"),
        PROPERTY_INSTALLATION_FINISHED_DD_NEW("clientupdater.installation.finished.dd.new"),
        PROPERTY_INSTALLATION_FINISHED_DD_DOWNGRADED("clientupdater.installation.finished.dd.downgraded"),
        P_TITLE("clientupdater.title"),
        P_PRESUMMARY_TITLE("clientupdater.presummary.title"),
        P_ACTION_TITLE("clientupdater.action.title"),
        P_POSTSUMMARY_TITLE("clientupdater.postsummary.title"),
        P_BTN_CANCEL("clientupdater.button.cancel"),
        P_BTN_NEXT("clientupdater.button.next"),
        P_BTN_FINISH("clientupdater.button.finish"),
        PROPERTY_INSTALLATION_DD_OK("clientupdater.installation.finished.dd.ok"),
        PROPERTY_INSTALLATION_DD_ERROR("clientupdater.installation.finished.dd.error");

        String property;

        private ClientUpdaterProps(String p) {
            this.property = p;
        }

        public String getPropertyName() {
            return this.property;
        }
    }
}

