/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services.local;

import com.bwanms.platform.PlatformFactory;
import com.bwanms.services.TimingThreadPool;
import com.bwanms.services.impl.TimingThreadPoolImpl;

public class TimingThreadPoolLocal
implements TimingThreadPool {
    private static TimingThreadPoolLocal singleton;
    private TimingThreadPool delegate = new TimingThreadPoolImpl();

    private TimingThreadPoolLocal() {
        this.delegate.setCorePoolSize(10);
        this.delegate.setMaxPoolSize(20);
        this.delegate.setKeepAliveTime(6L);
        this.delegate.setTimeUnitCode(3);
        this.delegate.setBlockingQueueSize(20);
        this.delegate.setRejectedExecutionHandlerCode(3);
        this.delegate.setPrestartAllCoreThreads(true);
    }

    public static synchronized TimingThreadPoolLocal getInstance() {
        if (singleton == null) {
            singleton = new TimingThreadPoolLocal();
        }
        return singleton;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("A singleton can't be cloned");
    }

    public int getBlockingQueueSize() {
        return this.delegate.getBlockingQueueSize();
    }

    public int getCorePoolSize() {
        return this.delegate.getCorePoolSize();
    }

    public int getMaxPoolSize() {
        return this.delegate.getMaxPoolSize();
    }

    public int getRejectedExecutionHandlerCode() {
        return this.delegate.getRejectedExecutionHandlerCode();
    }

    public int getTimeUnitCode() {
        return this.delegate.getTimeUnitCode();
    }

    public boolean getPrestartAllCoreThreads() {
        return this.delegate.getPrestartAllCoreThreads();
    }

    public void setBlockingQueueSize(int rejectedExecutionHandlerCode) {
        this.delegate.setBlockingQueueSize(rejectedExecutionHandlerCode);
    }

    public void setCorePoolSize(int corePoolSize) {
        this.delegate.setCorePoolSize(corePoolSize);
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.delegate.setMaxPoolSize(maxPoolSize);
    }

    public void setPrestartAllCoreThreads(boolean prestartAllCoreThreads) {
        this.delegate.setPrestartAllCoreThreads(prestartAllCoreThreads);
    }

    public void setRejectedExecutionHandlerCode(int rejectedExecutionHandlerCode) {
        this.delegate.setRejectedExecutionHandlerCode(rejectedExecutionHandlerCode);
    }

    public void setTimeUnitCode(int timeUnitCode) {
        this.delegate.setTimeUnitCode(timeUnitCode);
    }

    public long getKeepAliveTime() {
        return this.delegate.getKeepAliveTime();
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.delegate.setKeepAliveTime(keepAliveTime);
    }

    public void execute(Runnable runnable) {
        this.delegate.execute(runnable);
    }

    public void start() {
        this.delegate.start();
        PlatformFactory.getApplicationLayerPlatform().getLookup().bind("bwanms/TimingThreadPool", this);
    }

    public void stop() {
        PlatformFactory.getApplicationLayerPlatform().getLookup().unbind("bwanms/TimingThreadPool");
        this.delegate.stop();
    }
}

