/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services.local;

import com.bwanms.model.Schedule;
import com.bwanms.services.SchedulerService;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.services.impl.SchedulerServiceImpl;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class SchedulerServiceLocal
implements SchedulerService {
    private static final Logger log = Logger.getLogger(SchedulerServiceLocal.class);
    private SchedulerServiceImpl delegate = new SchedulerServiceImpl();
    private static SchedulerServiceLocal instance;

    private SchedulerServiceLocal() {
    }

    public static SchedulerServiceLocal getInstance() {
        if (instance == null) {
            instance = new SchedulerServiceLocal();
        }
        List<Schedule> schedules = ServiceRegistry.getEntityManagerService().retrieveAll(Schedule.class);
        for (Schedule schedule : schedules) {
            instance.startOrUpdateSchedule(schedule);
            try {
                ServiceRegistry.getEntityManagerService().save(schedule);
            }
            catch (ServiceException e) {
                log.error((Object)"Failed to save schedule.", (Throwable)e);
            }
        }
        return instance;
    }

    public Date startOrUpdateSchedule(Schedule schedule) {
        return this.delegate.startOrUpdateSchedule(schedule);
    }

    public void stopSchedule(Schedule schedule) {
        this.delegate.stopSchedule(schedule);
    }

    public Date getNextFireTime(long scheduleId) {
        return this.delegate.getNextFireTime(scheduleId);
    }
}

