/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services.local;

import com.bwanms.model.ScheduleRecurrence;
import com.bwanms.model.Task;
import com.bwanms.model.TaskRuntimeStatus;
import com.bwanms.model.TaskSchedule;
import com.bwanms.model.task.DatabaseAgingGenericTask;
import com.bwanms.model.task.Destination;
import com.bwanms.persistence.Datastore;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.services.ActiveTaskManager;
import com.bwanms.services.EntityManagerService;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.services.impl.ActiveTaskManagerImpl;
import com.bwanms.services.local.ServiceLocal;
import java.util.Date;
import java.util.List;

public class ActiveTaskManagerLocal
implements ActiveTaskManager,
ServiceLocal {
    public ActiveTaskManagerImpl delegate = new ActiveTaskManagerImpl();
    private static ActiveTaskManagerLocal instance;

    public static ActiveTaskManagerLocal getInstance() {
        if (instance == null) {
            instance = new ActiveTaskManagerLocal();
        }
        return instance;
    }

    private ActiveTaskManagerLocal() {
    }

    public void startTask(long taskID) {
        this.delegate.startTask(taskID);
    }

    public void stopTask(long taskID) {
        this.delegate.stopTask(taskID);
    }

    public void deleteTask(long taskID) {
        this.delegate.deleteTask(taskID);
    }

    public void taskStateChanged(Task task) {
        Datastore.session().evict((Object)task);
        this.delegate.taskStateChanged(task);
    }

    public TaskRuntimeStatus getTaskRuntimeStatus(long taskID, Object clientData) {
        return this.delegate.getTaskRuntimeStatus(taskID, clientData);
    }

    public TaskRuntimeStatus getVolatileRuntimeStatus(String userId, Object clientData) {
        return this.delegate.getVolatileRuntimeStatus(userId, clientData);
    }

    public String startVolatileTask(Task task) {
        return this.delegate.startVolatileTask(task);
    }

    public void stopVolatileTask(String userId) {
        this.delegate.stopVolatileTask(userId);
    }

    public void startLocalService() {
        PlatformFactory.getApplicationLayerPlatform().getLookup().bind("bwanms/ActiveTaskManager", this.delegate);
        EntityManagerService ems = ServiceRegistry.getEntityManagerService();
        List<DatabaseAgingGenericTask> dbaTasks = ems.retrieveAll(DatabaseAgingGenericTask.class);
        if (dbaTasks == null || dbaTasks.isEmpty()) {
            this.createDBAgingTask(DatabaseAgingGenericTask.Table.EventHistory);
            this.createDBAgingTask(DatabaseAgingGenericTask.Table.AuditLog);
        }
    }

    public void stopLocalService() {
        PlatformFactory.getApplicationLayerPlatform().getLookup().unbind("bwanms/ActiveTaskManager");
    }

    private void createDBAgingTask(DatabaseAgingGenericTask.Table table) {
        ScheduleRecurrence scheduleRecurrence = new ScheduleRecurrence();
        scheduleRecurrence.setType(2);
        scheduleRecurrence.setEndType(0);
        scheduleRecurrence.setParam2(1);
        TaskSchedule taskSchedule = new TaskSchedule();
        taskSchedule.setScheduleStart(new Date());
        DatabaseAgingGenericTask dbaTask = new DatabaseAgingGenericTask();
        dbaTask.setName(table.toString() + " DAP");
        dbaTask.setState(0);
        dbaTask.setCreatedBy("LOCAL");
        dbaTask.setModifiedBy("LOCAL");
        Destination destination = new Destination();
        destination.setDestinationType(Destination.Type.CSV);
        String path = System.getProperty("OWARE_USER_ROOT");
        if (path == null || path.length() == 0) {
            path = System.getProperty("oware.user.root");
        }
        path = path + "/filesystem/archive";
        destination.setParam1(path);
        dbaTask.setDestination(destination);
        dbaTask.setTargetTable(table);
        dbaTask.setThreshold(20L);
        try {
            EntityManagerService ems = ServiceRegistry.getEntityManagerService();
            taskSchedule.setRecurrence(ems.save(scheduleRecurrence));
            taskSchedule.setTask(ems.save(dbaTask));
            ems.save(taskSchedule);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }
}

