/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services.impl;

import com.bwanms.domain.logic.TopologyServiceHelper;
import com.bwanms.model.AlarmState;
import com.bwanms.model.AlarmStateCompute;
import com.bwanms.model.ObjectID;
import com.bwanms.model.topology.TopologyAdapter;
import com.bwanms.model.topology.TopologyAdapters;
import com.bwanms.persistence.CallableDatastoreDecorator;
import com.bwanms.persistence.Datastore;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.services.impl.LockManagerLocator;
import com.bwanms.services.impl.TopologyChangeEvent;
import com.bwanms.services.impl.TopologyService;
import com.bwanms.services.impl.TopologyUpdateRequest;
import com.bwanms.util.DatastoreOperationUtil;
import com.bwanms.util.ExecutorUtils;
import com.bwanms.util.NamedThreadFactory;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.Lock;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopologyServiceImpl
implements TopologyService {
    private static final Logger log = Logger.getLogger(TopologyServiceImpl.class);
    private HashSet<ObjectID> alarmStateChangeRequests;
    private AlarmStateChangeListener listener;
    private ExecutorService executor;
    private int processorThreads = 5;
    private long eventsProcessedCount = 0L;
    private long totalEventProcessingTime = 0L;

    public void start() {
        this.alarmStateChangeRequests = new HashSet();
        this.listener = new AlarmStateChangeListener();
        PlatformFactory.getApplicationLayerPlatform().getMessaging().setQueueListener("queue/AlarmStateUpdate", this.listener);
        this.executor = Executors.newFixedThreadPool(this.processorThreads, new NamedThreadFactory("AlarmStateChange"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        HashSet<ObjectID> hashSet = this.alarmStateChangeRequests;
        synchronized (hashSet) {
            this.alarmStateChangeRequests.clear();
        }
        ExecutorUtils.shutdownAndWait("AlarmStateChange", this.executor);
        PlatformFactory.getApplicationLayerPlatform().getMessaging().removeQueueListener(this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAlarmStateChangeRequests(List<ObjectID> linkEndPointIds) {
        log.debug((Object)"addAlarmStateChangeRequests");
        HashSet<ObjectID> hashSet = this.alarmStateChangeRequests;
        synchronized (hashSet) {
            for (ObjectID linkEndPointId : linkEndPointIds) {
                if (this.alarmStateChangeRequests.contains(linkEndPointId)) continue;
                this.alarmStateChangeRequests.add(linkEndPointId);
                this.executor.submit(new AlarmStateUpdateRunnable(linkEndPointId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAlarmStateChangeRequests(ObjectID linkEndPointId) {
        log.debug((Object)"addAlarmStateChangeRequests");
        HashSet<ObjectID> hashSet = this.alarmStateChangeRequests;
        synchronized (hashSet) {
            if (!this.alarmStateChangeRequests.contains(linkEndPointId)) {
                this.alarmStateChangeRequests.add(linkEndPointId);
                this.executor.execute(new AlarmStateUpdateRunnable(linkEndPointId));
            }
        }
    }

    @Override
    public int getProcessorThreads() {
        return this.processorThreads;
    }

    @Override
    public void setProcessorThreads(int processorThreads) {
        this.processorThreads = processorThreads;
    }

    private Lock getEntityLock(ObjectID linkEndPointID) {
        return LockManagerLocator.locate().getLock(linkEndPointID.getClassName() + "#" + linkEndPointID.getIdentifier() + "#topologyLock");
    }

    private class AlarmStateUpdateRunnable
    implements Runnable {
        private ObjectID linkEndPointId;

        public AlarmStateUpdateRunnable(ObjectID linkEndPointId) {
            this.linkEndPointId = linkEndPointId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            HashSet hashSet = TopologyServiceImpl.this.alarmStateChangeRequests;
            synchronized (hashSet) {
                TopologyServiceImpl.this.alarmStateChangeRequests.remove(this.linkEndPointId);
            }
            log.debug((Object)("[" + this.linkEndPointId + "] updating alarm state"));
            long _time = System.currentTimeMillis();
            Lock lock = TopologyServiceImpl.this.getEntityLock(this.linkEndPointId);
            try {
                lock.lock();
                try {
                    new CallableDatastoreDecorator<Object>(new Callable<Object>(){

                        @Override
                        public Object call() {
                            AlarmStateUpdateRunnable.this.updateStateImpl();
                            return null;
                        }
                    }).call();
                }
                catch (Exception e) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
                TopologyServiceImpl.this.totalEventProcessingTime += System.currentTimeMillis() - _time;
                TopologyServiceImpl.this.eventsProcessedCount++;
                log.debug((Object)("Avg.Proc: " + (System.currentTimeMillis() - _time) + " millis"));
                log.debug((Object)("Actual.Threads: " + ((ThreadPoolExecutor)TopologyServiceImpl.this.executor).getPoolSize()));
            }
            catch (Throwable t) {
                log.debug((Object)t, t);
                TopologyServiceImpl.this.addAlarmStateChangeRequests(this.linkEndPointId);
            }
            finally {
                lock.unlock();
            }
        }

        private void updateStateImpl() {
            AlarmState endPoint = (AlarmState)ObjectID.getEntity(this.linkEndPointId);
            if (endPoint == null) {
                log.debug((Object)("[" + this.linkEndPointId + "] was deleted"));
                return;
            }
            TopologyAdapter adapter = TopologyAdapters.getTopologyAdapter(endPoint.getClass().getName());
            if (adapter != null) {
                if (endPoint instanceof AlarmStateCompute) {
                    int alarmState = endPoint.getAlarmState();
                    ((AlarmStateCompute)endPoint).computeAlarmState();
                    if (alarmState == endPoint.getAlarmState()) {
                        DatastoreOperationUtil.publishMessageOperation("topic/TopologyChange", new TopologyChangeEvent(adapter.getVertex(endPoint))).run();
                        return;
                    }
                    List<Object> propagationEndPoints = adapter.getAlarmPropagationLinks(endPoint);
                    if (propagationEndPoints != null) {
                        for (Object affectedEndPoint : propagationEndPoints) {
                            if (!(affectedEndPoint instanceof AlarmState)) continue;
                            TopologyServiceHelper.topologyChanged(affectedEndPoint);
                        }
                    }
                    Datastore.addOperationAfterTransaction(DatastoreOperationUtil.publishMessageOperation("topic/TopologyChange", new TopologyChangeEvent(adapter.getVertex(endPoint))));
                    Datastore.session().saveOrUpdate((Object)endPoint);
                } else {
                    List<Object> propagationEndPoints = adapter.getAlarmPropagationLinks(endPoint);
                    if (propagationEndPoints != null) {
                        for (Object affectedEndPoint : propagationEndPoints) {
                            if (!(affectedEndPoint instanceof AlarmState)) continue;
                            TopologyServiceHelper.topologyChanged(affectedEndPoint);
                        }
                    }
                    DatastoreOperationUtil.publishMessageOperation("topic/TopologyChange", new TopologyChangeEvent(adapter.getVertex(endPoint))).run();
                }
            }
        }
    }

    private class AlarmStateChangeListener
    implements MessageListener {
        private AlarmStateChangeListener() {
        }

        public void onMessage(Message msg) {
            log.debug((Object)"onMessage");
            try {
                ObjectMessage objMsg = (ObjectMessage)msg;
                TopologyUpdateRequest request = (TopologyUpdateRequest)objMsg.getObject();
                TopologyServiceImpl.this.addAlarmStateChangeRequests(request.getAffectedLinkEndPoints());
            }
            catch (JMSException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }
}

