/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services.impl;

import com.bwanms.backend.fault.LoggingThreadFactory;
import com.bwanms.backend.fault.TimingThreadPoolExecutor;
import com.bwanms.services.TimingThreadPool;
import com.bwanms.services.impl.RejectedExecutionHandlerEnum;
import com.bwanms.util.ExecutorUtils;
import com.bwanms.util.TimeUnitEnum;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class TimingThreadPoolImpl
implements TimingThreadPool {
    private static final Logger log = Logger.getLogger(TimingThreadPoolImpl.class);
    private int corePoolSize;
    private int maxPoolSize;
    private long keepAliveTime;
    private int timeUnitCode;
    private int blockingQueueSize;
    private int rejectedExecutionHandlerCode;
    private boolean prestartAllCoreThreads;
    private TimingThreadPoolExecutor ttpe;

    public int getBlockingQueueSize() {
        return this.blockingQueueSize;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getRejectedExecutionHandlerCode() {
        return this.rejectedExecutionHandlerCode;
    }

    public int getTimeUnitCode() {
        return this.timeUnitCode;
    }

    public boolean getPrestartAllCoreThreads() {
        return this.prestartAllCoreThreads;
    }

    public void setBlockingQueueSize(int blockingQueueSize) {
        this.blockingQueueSize = blockingQueueSize;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setPrestartAllCoreThreads(boolean prestartAllCoreThreads) {
        this.prestartAllCoreThreads = prestartAllCoreThreads;
    }

    public void setRejectedExecutionHandlerCode(int rejectedExecutionHandlerCode) {
        this.rejectedExecutionHandlerCode = rejectedExecutionHandlerCode;
    }

    public void setTimeUnitCode(int timeUnitCode) {
        this.timeUnitCode = timeUnitCode;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public void start() {
        log.log(Priority.INFO, (Object)"Creating timing thread pool executor...");
        this.ttpe = new TimingThreadPoolExecutor(this.getCorePoolSize(), this.getMaxPoolSize(), this.getKeepAliveTime(), this.getTimeUnit(this.getTimeUnitCode()), new ArrayBlockingQueue<Runnable>(this.getBlockingQueueSize()), new LoggingThreadFactory("Timing Thread Pool"), this.getRejectedExecutionHandler(this.getRejectedExecutionHandlerCode()));
        log.log(Priority.INFO, (Object)"Timing thread pool executor was created");
        if (this.getPrestartAllCoreThreads()) {
            this.ttpe.prestartAllCoreThreads();
        }
    }

    private RejectedExecutionHandler getRejectedExecutionHandler(int rejectedExecutionHandlerCode) {
        RejectedExecutionHandlerEnum rehe = RejectedExecutionHandlerEnum.getRejectedExecutionHandlerEnum(rejectedExecutionHandlerCode);
        switch (rehe) {
            case ABORT_POLICY: {
                return new ThreadPoolExecutor.AbortPolicy();
            }
            case CALLER_RUNS_POLICY: {
                return new ThreadPoolExecutor.CallerRunsPolicy();
            }
            case DISCARD_OLDIEST_POLICY: {
                return new ThreadPoolExecutor.DiscardOldestPolicy();
            }
            case DISCARD_POLICY: {
                return new ThreadPoolExecutor.DiscardPolicy();
            }
        }
        throw new IllegalArgumentException("Unknown code");
    }

    private TimeUnit getTimeUnit(int timeUnitCode) {
        TimeUnitEnum timeUnitEnum = TimeUnitEnum.getTimeUnitEnum(timeUnitCode);
        switch (timeUnitEnum) {
            case NANOSECONDS: {
                return TimeUnit.NANOSECONDS;
            }
            case MICROSECONDS: {
                return TimeUnit.MICROSECONDS;
            }
            case MILLISECONDS: {
                return TimeUnit.MILLISECONDS;
            }
            case SECONDS: {
                return TimeUnit.SECONDS;
            }
        }
        throw new IllegalArgumentException("Unknown code");
    }

    public void stop() {
        ExecutorUtils.shutdownAndWait("Timing thread pool executor - workers", this.ttpe, 60);
    }

    public void execute(Runnable runnable) {
        this.ttpe.execute(runnable);
    }
}

