/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services.impl;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.taskmanager.TaskManagerMediator;
import com.bwanms.model.Task;
import com.bwanms.model.TaskRunResult;
import com.bwanms.model.TaskRuntimeStatus;
import com.bwanms.model.TaskSchedule;
import com.bwanms.persistence.Datastore;
import com.bwanms.persistence.PrivateSessionHelper;
import com.bwanms.persistence.PrivateSessionManager;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtension;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import com.bwanms.services.ActiveTaskManager;
import com.bwanms.services.SchedulerService;
import com.bwanms.services.TaskManagerService;
import com.bwanms.services.impl.EntityPersistenceInterpretor;
import com.bwanms.services.impl.EntityPersistenceStrategyAdaptor;
import com.bwanms.util.ServerValidationException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskManagerServiceImpl
implements TaskManagerService {
    private static final transient Logger log = Logger.getLogger(TaskManagerServiceImpl.class);
    private static Map<String, Class> taskPersistenceInterpretor = new HashMap<String, Class>();

    @Override
    public List<Task> retrieveTasks() {
        return Datastore.session().createQuery("from " + Task.class.getName()).list();
    }

    @Override
    public Task retrieveTask(long taskID) {
        log.debug((Object)("RETRIEVING ----------- > " + taskID));
        Task task = (Task)Datastore.session().get(Task.class, (Serializable)Long.valueOf(taskID));
        if (null != task) {
            TaskManagerServiceImpl.getPersistenceInterpretor(task.getClass()).prepareFetch(task);
        }
        return task;
    }

    @Override
    public Task updateTask(Task task, int manageSchedule) {
        return this.justUpdateTask(task, manageSchedule);
    }

    @Override
    public Task validateAndUpdateTask(Task task, int manageSchedule) throws ServerValidationException {
        this.validateTask(task);
        return this.justUpdateTask(task, manageSchedule);
    }

    private Task justUpdateTask(Task task, int manageSchedule) {
        log.info((Object)("RETRIEVING ----------- > " + task.getId()));
        TaskManagerServiceImpl.getPersistenceInterpretor(task.getClass()).prepareCommit(task);
        if (task.getSchedule() != null) {
            log.info((Object)("MANAGE SCHEDULE IS " + manageSchedule));
            TaskSchedule schedule = task.getSchedule();
            SchedulerService service = (SchedulerService)PlatformFactory.getApplicationLayerPlatform().getLookup().lookup("bwanms/SchedulerService");
            if (manageSchedule == 1) {
                service.stopSchedule(schedule);
                task.setSchedule(null);
                PrivateSessionHelper.deleteAndCommit(schedule.getRecurrence(), schedule);
            } else {
                if (schedule.getRecurrence() != null) {
                    PrivateSessionHelper.persistAndCommit(schedule.getRecurrence(), schedule, task);
                } else {
                    PrivateSessionHelper.persistAndCommit(schedule, task);
                }
                service.startOrUpdateSchedule(schedule);
                schedule.setNextRun(service.getNextFireTime(schedule.getId()));
                log.info((Object)(" \n\n PERSISTING SCHEDULE WITH NEXT FIRE TIME FOR " + schedule.getId() + " : " + schedule.getNextRun() + "(" + service.getNextFireTime(schedule.getId()) + ")"));
                PrivateSessionHelper.persistAndCommit((Object)schedule);
            }
        } else {
            PrivateSessionHelper.persistAndCommit((Object)task);
        }
        PlatformFactory.getApplicationLayerPlatform().getMessaging().publish("topic/TaskObserverTopic", task);
        log.debug((Object)("FINISHED UPDATING ----------- > " + task.getId()));
        return task;
    }

    private void validateTask(Task task) throws ServerValidationException {
        Session session = PrivateSessionManager.privateSession();
        List match = new ArrayList();
        match = session.createQuery("from " + Task.class.getName() + " where name=:name and id!=:id").setString("name", task.getName()).setLong("id", task.getId()).list();
        session.close();
        List<InvalidValue> ivList = task.performServerValidation();
        if (match.size() > 0) {
            Internationalizer i18n = Internationalizer.getInternationalizer(TaskManagerMediator.class);
            ivList.add(new InvalidValue(i18n.translateString("uniqueViolation"), Task.class, "name", (Object)task.getName(), (Object)task));
        }
        if (ivList.size() > 0) {
            throw new ServerValidationException(ivList);
        }
    }

    @Override
    public void startTask(long taskID) {
        ActiveTaskManager activeTaskManager = (ActiveTaskManager)PlatformFactory.getApplicationLayerPlatform().getLookup().lookup("bwanms/ActiveTaskManager");
        activeTaskManager.startTask(taskID);
    }

    @Override
    public void stopTask(long taskID) {
        ActiveTaskManager activeTaskManager = (ActiveTaskManager)PlatformFactory.getApplicationLayerPlatform().getLookup().lookup("bwanms/ActiveTaskManager");
        activeTaskManager.stopTask(taskID);
    }

    @Override
    public TaskRuntimeStatus getRuntimeStatus(long taskID, Object clientData) {
        ActiveTaskManager activeTaskManager = (ActiveTaskManager)PlatformFactory.getApplicationLayerPlatform().getLookup().lookup("bwanms/ActiveTaskManager");
        return activeTaskManager.getTaskRuntimeStatus(taskID, clientData);
    }

    @Override
    public List<TaskRunResult> getHistory(long taskID) {
        Query query = Datastore.session().createQuery("from " + TaskRunResult.class.getName() + " where taskID=:id order by start asc");
        query.setLong("id", taskID);
        return query.list();
    }

    @Override
    public void deleteTask(long taskID) {
        Task task = (Task)Datastore.session().get(Task.class, (Serializable)Long.valueOf(taskID));
        if (null == task) {
            return;
        }
        EntityPersistenceInterpretor interpreter = TaskManagerServiceImpl.getPersistenceInterpretor(task.getClass());
        if (interpreter.prepareDelete(task)) {
            ActiveTaskManager activeTaskManager = (ActiveTaskManager)PlatformFactory.getApplicationLayerPlatform().getLookup().lookup("bwanms/ActiveTaskManager");
            activeTaskManager.deleteTask(taskID);
        }
        interpreter.afterDelete(taskID);
    }

    @Override
    public TaskRunResult getLastRunResult(long taskID) {
        Query query = Datastore.session().createQuery("select max(trr.end) from " + TaskRunResult.class.getName() + " as trr where trr.task.id = :taskID");
        query.setLong("taskID", taskID);
        Long lastRunTime = (Long)query.uniqueResult();
        if (lastRunTime == null) {
            return null;
        }
        query = Datastore.session().createQuery("from " + TaskRunResult.class.getName() + " as trr where trr.end = :end and trr.task.id = :taskID");
        query.setLong("end", lastRunTime.longValue());
        query.setLong("taskID", taskID);
        return (TaskRunResult)query.uniqueResult();
    }

    private static EntityPersistenceInterpretor getPersistenceInterpretor(Class entityClass) {
        Class strategyClass = taskPersistenceInterpretor.get(entityClass.getName());
        if (null != strategyClass) {
            try {
                return (EntityPersistenceInterpretor)strategyClass.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return new EntityPersistenceStrategyAdaptor();
        }
        return new EntityPersistenceStrategyAdaptor();
    }

    @Override
    public TaskRuntimeStatus getVolatileRuntimeStatus(String userId, Object clientData) {
        ActiveTaskManager activeTaskManager = (ActiveTaskManager)PlatformFactory.getApplicationLayerPlatform().getLookup().lookup("bwanms/ActiveTaskManager");
        return activeTaskManager.getVolatileRuntimeStatus(userId, clientData);
    }

    @Override
    public String startVolatileTask(Task task) {
        ActiveTaskManager activeTaskManager = (ActiveTaskManager)PlatformFactory.getApplicationLayerPlatform().getLookup().lookup("bwanms/ActiveTaskManager");
        return activeTaskManager.startVolatileTask(task);
    }

    @Override
    public void stopVolatileTask(String userId) {
        ActiveTaskManager activeTaskManager = (ActiveTaskManager)PlatformFactory.getApplicationLayerPlatform().getLookup().lookup("bwanms/ActiveTaskManager");
        activeTaskManager.stopVolatileTask(userId);
    }

    static {
        IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.task.persistenceInterpretor");
        for (IExtension extension : extensionPoint.getExtensions()) {
            IConfigurationElement[] configElements = extension.getConfigurationElements();
            for (int i = 0; i < configElements.length; ++i) {
                try {
                    taskPersistenceInterpretor.put(configElements[i].getAttribute("class"), Class.forName(configElements[i].getAttribute("interpretorClass")));
                    continue;
                }
                catch (ClassNotFoundException cnfe) {
                    log.error((Object)("Class not found " + configElements[i].getAttribute("interpretorClass") + " for class " + configElements[i].getAttribute("class")));
                    cnfe.printStackTrace();
                }
            }
        }
    }
}

