/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.services.impl;

import com.bwanms.services.TFTPManager;
import com.bwanms.tftp.server.TFTPServer;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public class TFTPManagerImpl
implements TFTPManager {
    private static final transient Logger log = Logger.getLogger(TFTPManagerImpl.class);
    private TFTPServer tftpServer;
    private String workingDir;
    private int port = 69;

    public TFTPManagerImpl() {
        try {
            log.debug((Object)"Creating TFTP server");
            this.tftpServer = new TFTPServer();
            log.debug((Object)"TFTP server created");
        }
        catch (UnknownHostException ex) {
            log.error((Object)("Failed to instantiate tftp server : " + ex.getMessage()));
        }
    }

    public void start() {
        try {
            File f;
            this.tftpServer.setPort(this.port);
            String ip = System.getProperty("oware.config.server");
            if (ip == null) {
                ip = System.getProperty("oware.local.ip.address");
            }
            if (ip == null) {
                ip = System.getProperty("com.dorado.local.host");
            }
            if (ip == null) {
                ip = "0.0.0.0";
            }
            this.tftpServer.setAddress(InetAddress.getByName(ip));
            StringBuilder rootDir = new StringBuilder();
            if (System.getProperty("com.bwanms.home") != null) {
                rootDir.append(System.getProperty("com.bwanms.home"));
            } else if (System.getenv("OWARE_USER_ROOT") != null) {
                rootDir.append(System.getenv("OWARE_USER_ROOT"));
            } else {
                log.warn((Object)("Using user.dir property : " + System.getProperty("user.dir")));
                rootDir.append(System.getProperty("user.dir"));
            }
            if (rootDir.charAt(rootDir.length() - 1) != File.separatorChar) {
                rootDir.append(File.separatorChar);
            }
            if (this.workingDir != null) {
                rootDir.append(this.workingDir);
            }
            if (!(f = new File(rootDir.toString())).exists()) {
                log.debug((Object)("Create working directory : " + rootDir));
                if (!f.mkdir()) {
                    log.error((Object)("Failed to create ROOT_DIRECTORY for TFTPServer : " + rootDir));
                }
            }
            this.tftpServer.setRootDir(rootDir.toString());
            log.debug((Object)("Set working directory : " + this.tftpServer.getRootDir()));
            this.tftpServer.start();
            log.debug((Object)("TFTP server started on port=" + this.tftpServer.getPort() + " root=" + this.tftpServer.getRootDir()));
        }
        catch (Exception e) {
            log.error((Object)("Failed to start tftp server : " + e.getMessage()));
        }
    }

    public void stop() {
        try {
            this.tftpServer.stop();
        }
        catch (Exception e) {
            log.error((Object)("Failed to stop tftp server : " + e.getMessage()));
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }
}

